<?php
namespace HugeAddons;

class Activator {
    public static function activate() {
      if ( ! class_exists( 'Elementor\Plugin' ) ) {
        deactivate_plugins( plugin_basename( __FILE__ ) );
		    wp_die( esc_html__( 'This plugin requires Elementor to be installed and activated.', 'huge-addons-for-elementor' ) );
	    }

	    $current_time = gmdate( 'Y-m-d H:i:s' );

      // Get plugin version
      $plugin_version = THHA_VERSION; 

      // Get Elementor version (if applicable)
      if (defined('ELEMENTOR_VERSION')) {
        $elementor_version = ELEMENTOR_VERSION;
      } else {
        $elementor_version = 'Not installed';
      }

      // Get PHP version
      $php_version = phpversion();

      // Get MySQL version
      global $wpdb;

      $cache_key = 'thha_mysql_version';
      $mysql_version = wp_cache_get( $cache_key );

      if ( false === $mysql_version ) {
          $mysql_version = $wpdb->get_var( "SHOW GLOBAL STATUS LIKE 'version'" );  // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
          wp_cache_set( $cache_key, $mysql_version, '', HOUR_IN_SECONDS );
      }

      // Create an array to store the data
      $activation_data = array(
          'activation_time' => $current_time,
          'plugin_version' => $plugin_version,
          'elementor_version' => $elementor_version,
          'php_version' => $php_version,
          'mysql_version' => $mysql_version,
      );

      // Save the data to the options table
      update_option('thha_activation_data', $activation_data);
    }
}
?>