/******/ (() => { // webpackBootstrap
/*!******************************************!*\
  !*** ./assets/js/thha-huge-accordion.js ***!
  \******************************************/
document.addEventListener("DOMContentLoaded", function () {
  var accordions = document.querySelectorAll(".thha-accordion");
  accordions.forEach(function (accordion) {
    var accordionItems = accordion.querySelectorAll(".thha-accordion-item");
    accordionItems.forEach(function (item) {
      var title = item.querySelector(".thha-accordion-title");
      title.addEventListener("click", function () {
        accordionItems.forEach(function (otherItem) {
          if (otherItem !== item) {
            otherItem.classList.remove("active");
            otherItem.querySelector(".thha-accordion-content").style.display = "none";
          }
        });

        // Toggle the clicked item
        var isActive = item.classList.contains("active");
        if (isActive) {
          item.classList.remove("active");
          item.querySelector(".thha-accordion-content").style.display = "none";
        } else {
          item.classList.add("active");
          item.querySelector(".thha-accordion-content").style.display = "block";
        }
      });
    });
  });
});
/******/ })()
;
//# sourceMappingURL=thha-huge-accordion.js.map