<?php
namespace HugeAddons\Widgets\Renders;

use WP_Query;


function render_huge_post_grid_widget( $settings, $unique_id, $page = 1, $only_items = false ) {
    
    
    // Add all settings as data attributes
    echo '<div class="elementor-widget-huge-post-grid" 
          data-posts-per-page="' . esc_attr($settings['posts_per_page']) . '"
          data-selected-category="' . esc_attr($settings['selected_category']) . '"
          data-post-style="' . esc_attr($settings['post_style']) . '"
          data-show-image="' . esc_attr($settings['show_image']) . '"
          data-show-category="' . esc_attr($settings['show_category']) . '"
          data-show-content="' . esc_attr($settings['show_content']) . '"
          data-content-type="' . esc_attr($settings['content_type']) . '"
          data-show-author="' . esc_attr($settings['show_author']) . '"
          data-show-date="' . esc_attr($settings['show_date']) . '"
          data-image-size="' . esc_attr($settings['image_size']) . '"
          data-title-word-limit="' . esc_attr($settings['title_word_limit']) . '"
          data-content-word-limit="' . esc_attr($settings['content_word_limit']) . '">';
    
    // Initial query
    $query_args = [
        'post_type' => 'post',
        'posts_per_page' => $settings['posts_per_page'],
        'paged' => $page,
        'category_name' => $settings['selected_category']
    ];
    
    $query = new WP_Query($query_args);
    
    if ($query->have_posts()) {
        // echo '<div id="' . esc_attr($unique_id) . '" class="huge-post-grid ep-post-grid huge-post-grid-' . esc_attr($settings['post_style']) . ' huge-post-columns-' . esc_attr($settings['columns']) . '">';
        echo '<div id="' . esc_attr($unique_id) . '" class="huge-post-grid ep-post-grid huge-post-grid-' . esc_attr($settings['post_style']) . '">';
        
        while ($query->have_posts()) {
            $query->the_post();
            thha_render_huge_post_style($settings['post_style'], $settings);
        }
        
        echo '</div>';
        
        // Render pagination
        if ($settings['show_pagination'] === 'yes') {
            render_pagination($query, $settings, $unique_id);
        }
        
        wp_reset_postdata();
    }
    
    echo '</div>'; // Close widget wrapper
}

function thha_render_huge_post_style($style, $settings){
    switch ($style) {
        case 'huge-style1':
           render_thha_huge_style1($settings);
            break;
        case 'huge-style2':
            render_thha_huge_style2($settings);
            break;
        case 'huge-style3':
            render_thha_huge_style3($settings);
            break;
        case 'huge-style4':
            render_thha_huge_style4($settings);
            break;     
        case 'huge-style5':
            render_thha_huge_style5($settings);
            break;
        case 'huge-style6':
            render_thha_huge_style6($settings);
            break;
        case 'huge-style7':
            render_thha_huge_style7($settings);
            break;
        case 'huge-style8':
            render_thha_huge_style8($settings);
            break;
        case 'huge-style9':
            render_thha_huge_style9($settings);
            break;
        case 'huge-style10':
            render_thha_huge_style10($settings);
            break;    
        default:
            render_thha_huge_style1($settings);
    }
}

function render_thha_huge_style1($settings) {
    // Card Design
    echo '<div class="huge-post-item huge-post-style-1">';
    
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        $image_size = isset($settings['image_size']) ? $settings['image_size'] : 'large';
        echo '<div class="huge-post-thumbnail"><a href="' . esc_url( get_permalink() ) . '">' . wp_kses_post( get_the_post_thumbnail( get_the_ID(), $image_size ) ) . '</a></div>';
    }
    
    echo '<div class="huge-post-content-wrapper">';
    
    if ($settings['show_category'] === 'yes') {
        $categories = get_the_category();
        if (!empty($categories)) {
            echo '<div class="huge-post-category">' . esc_html($categories[0]->name) . '</div>';
        }
    }
    
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words( get_the_title(), $settings['title_word_limit'], '...' ) ) . '</a></h3>';



    if ($settings['show_content'] === 'yes') {
        $word_limit = !empty($settings['content_word_limit']) ? $settings['content_word_limit'] : 20;
        
        if ($settings['content_type'] === 'excerpt') {
            $content = get_the_excerpt();
            if (empty($content)) {
                $content = get_the_content();
            }
        } else {
            $content = get_the_content();
        }
        
        // Apply word limit to both excerpt and content
        $content = esc_html( wp_trim_words($content, $word_limit, '...') );
        
        // Apply content filters (for shortcodes, formatting etc.)
        $content = apply_filters('the_content', $content);
        
        echo '<div class="huge-post-excerpt">'. wp_kses_post($content) . '</div>';
    }

    
    if ($settings['show_author'] === 'yes' || $settings['show_date'] === 'yes') {
        echo '<div class="huge-post-footer">';
        if ($settings['show_author'] === 'yes') {
            echo '<span class="huge-post-author">' . get_the_author() . '</span>';
        }
        if ($settings['show_date'] === 'yes') {
            echo '<span class="huge-post-date">' . get_the_date() . '</span>';
        }
        echo '</div>';
    }
    if ($settings['show_tags'] === 'yes') {
        $tags = get_the_tags();
        if (!empty($tags)) {
            echo '<div class="huge-post-tags">';
            foreach ($tags as $tag) {
                echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
            }
            echo '</div>';
        }
    }
    
    echo '</div></div>';
}

function render_thha_huge_style2($settings) {
    // Card Overlay
    echo '<div class="huge-post-item style-2 huge-post-style-2">';
    
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        $image_size = isset($settings['image_size']) ? $settings['image_size'] : 'large';
        echo '<div class="huge-post-thumbnail">';
        echo get_the_post_thumbnail(get_the_ID(), $image_size);
        echo '<div class="huge-post-overlay"></div>';
        echo '</div>';
    }
    
    echo '<div class="huge-post-content">';
    
    if ($settings['show_date'] === 'yes') {
        echo '<div class="huge-post-meta-top">';
        echo '<span class="huge-post-date">' . get_the_date('d M') . '</span>';
        echo '</div>';
    }
    
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words( get_the_title(), $settings['title_word_limit'], '...' ) ) . '</a></h3>';

    
    echo '<div class="huge-post-meta-bottom">';
    if ($settings['show_author'] === 'yes') {
        echo '<span class="huge-post-author"><i class="fas fa-user"></i> ' . get_the_author() . '</span>';
    }
    if ($settings['show_category'] === 'yes') {
        $categories = get_the_category();
        if (!empty($categories)) {
            echo '<span class="huge-post-category"><i class="fas fa-tag"></i> ' . esc_html($categories[0]->name) . '</span>';
        }
    }
    echo '</div>';
    
    echo '</div>';
    echo '</div>';
}

function render_thha_huge_style3($settings) {
    // Creative Box
    echo '<div class="huge-post-item huge-post-style-3">';
    
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        echo '<div class="huge-post-thumbnail">';
        echo get_the_post_thumbnail(get_the_ID(), isset($settings['image_size']) ? $settings['image_size'] : 'large');
        echo '<div class="huge-post-overlay"></div>';
        
        echo '<div class="huge-post-hover-content">';
        echo '<div class="huge-post-hover-inner">';
        
        if ($settings['show_category'] === 'yes') {
            $categories = get_the_category();
            if (!empty($categories)) {
                echo '<span class="huge-post-category">' . esc_html($categories[0]->name) . '</span>';
            }
        }
        
        echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';
        
        if ($settings['show_date'] === 'yes') {
            echo '<span class="huge-post-date">' . get_the_date() . '</span>';
        }
        
        echo '</div>';
        echo '</div>';
        echo '</div>';
    }
    
    echo '</div>';
}

function render_thha_huge_style4($settings) {
    echo '<div class="huge-post-item huge-post-style-4">';
    
    // Image container with overlay
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        $image_size = isset($settings['image_size']) ? $settings['image_size'] : 'large';
        echo '<div class="huge-post-image-side">';
        echo '<div class="huge-post-overlay"></div>';
        echo '<a href="' . esc_url( get_permalink() ) . '">' . get_the_post_thumbnail(get_the_ID(), $image_size) . '</a>';
        
        // Icon badge
        echo '<div class="huge-post-icon-badge">';
        echo '<i class="fas fa-bookmark"></i>';
        echo '</div>';
        echo '</div>';
    }
    
    // Content side
    echo '<div class="huge-post-content-side">';
    
    if ($settings['show_category'] === 'yes') {
        $categories = get_the_category();
        if (!empty($categories)) {
            echo '<div class="huge-post-category">' . esc_html($categories[0]->name) . '</div>';
        }
    }
    
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';

    if ($settings['show_content'] === 'yes') {
        $word_limit = !empty($settings['content_word_limit']) ? $settings['content_word_limit'] : 20;
        
        if ($settings['content_type'] === 'excerpt') {
            $content = get_the_excerpt();
            if (empty($content)) {
                $content = get_the_content();
            }
        } else {
            $content = get_the_content();
        }
        
        // Apply word limit to both excerpt and content
        $content = esc_html( wp_trim_words($content, $word_limit, '...') );
        
        // Apply content filters (for shortcodes, formatting etc.)
        $content = apply_filters('the_content', $content);
        
        echo '<div class="huge-post-excerpt">'. wp_kses_post($content) . '</div>';
    }
    
    echo '<div class="huge-post-meta-footer">';
    if ($settings['show_author'] === 'yes') {
        echo '<span class="huge-post-author"><i class="fas fa-user"></i> ' . get_the_author() . '</span>';
    }
    if ($settings['show_date'] === 'yes') {
        echo '<span class="huge-post-date"><i class="far fa-calendar-alt"></i> ' . get_the_date() . '</span>';
    }
    echo '</div>';
    
    echo '</div></div>';
}

function render_thha_huge_style5($settings) {
    // Hover Card
    echo '<div class="huge-post-item huge-post-style-5">';  // Changed from style-5
    
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        echo '<div class="huge-post-thumbnail">';
        echo get_the_post_thumbnail(get_the_ID(), isset($settings['image_size']) ? $settings['image_size'] : 'large');
        echo '</div>';
    }
    
    echo '<div class="huge-post-content">';
    
    if ($settings['show_date'] === 'yes') {
        echo '<span class="huge-post-date">' . get_the_date('M d') . '</span>';
    }
    
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';
    
    if ($settings['show_content'] === 'yes') {
        $word_limit = !empty($settings['content_word_limit']) ? $settings['content_word_limit'] : 20;
        
        if ($settings['content_type'] === 'excerpt') {
            $content = get_the_excerpt();
            if (empty($content)) {
                $content = get_the_content();
            }
        } else {
            $content = get_the_content();
        }
        
        // Apply word limit to both excerpt and content
        $content = esc_html( wp_trim_words($content, $word_limit, '...') );
        
        // Apply content filters (for shortcodes, formatting etc.)
        $content = apply_filters('the_content', $content);
        
        echo '<div class="huge-post-excerpt">'. wp_kses_post($content) . '</div>';
    }
    
    echo '<a href="' . esc_url( get_permalink() ) . '" class="huge-read-more"><i class="fas fa-arrow-right"></i></a>';
    
    echo '</div>';
    echo '</div>';
}

function render_thha_huge_style6($settings) {
    // Overlay Content with Gradient Design
    echo '<div class="huge-post-item huge-post-style-6">';
    
    // Image container
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        $image_size = isset($settings['image_size']) ? $settings['image_size'] : 'large';
        echo '<div class="huge-post-thumbnail">';
        echo get_the_post_thumbnail(get_the_ID(), $image_size);
        echo '<div class="huge-post-overlay"></div>';
        echo '</div>';
    }
    
    // Content container
    echo '<div class="huge-post-content-wrapper">';
    
    // Top meta (category and date)
    echo '<div class="huge-post-meta-top">';
    if ($settings['show_category'] === 'yes') {
        $categories = get_the_category();
        if (!empty($categories)) {
            echo '<span class="huge-post-category">' . esc_html($categories[0]->name) . '</span>';
        }
    }
    if ($settings['show_date'] === 'yes') {
        echo '<span class="huge-post-date">' . get_the_date('M d, Y') . '</span>';
    }
    echo '</div>';
    
    // Title
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';
    
    // Bottom meta (author and read time)
    echo '<div class="huge-post-meta-bottom">';
    if ($settings['show_tags'] === 'yes') {
        $tags = get_the_tags();
        if (!empty($tags)) {
            echo '<div class="huge-post-tags">';
            foreach ($tags as $tag) {
                echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
            }
            echo '</div>';
        }
    }
    if ($settings['show_readmore'] === 'yes') {
        echo '<a href="' . esc_url( get_permalink() ) . '" class="huge-read-more">Read More</a>';
    }
    echo '</div>';
    
    echo '</div></div>';
}

function render_thha_huge_style7($settings) {
    // Card Gradient Design
    echo '<div class="huge-post-item huge-post-style-7">';
    
    echo '<div class="huge-post-thumbnail">';
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        echo '<a href="' . esc_url( get_permalink() ) . '">' . get_the_post_thumbnail(get_the_ID(), isset($settings['image_size']) ? $settings['image_size'] : 'large') . '</a>';
    }
    echo '</div>';
    
    echo '<div class="huge-post-content">';
    
    if ($settings['show_date'] === 'yes') {
        echo '<div class="huge-post-date">';
        echo '<span class="huge-date-day">' . get_the_date('d') . '</span>';
        echo '<span class="huge-date-month">' . get_the_date('M') . '</span>';
        echo '</div>';
    }
    
    echo '<div class="huge-post-content-inner">';
    if ($settings['show_category'] === 'yes') {
        $categories = get_the_category();
        if (!empty($categories)) {
            echo '<div class="huge-post-category">' . esc_html($categories[0]->name) . '</div>';
        }
    }
    
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';
    
    echo '<div class="huge-post-meta">';
    if ($settings['show_author'] === 'yes') {
        echo '<span class="huge-post-author"><i class="fas fa-user"></i> ' . get_the_author() . '</span>';
    }
    if ($settings['show_comments'] === 'yes') {
        echo '<span class="huge-post-comments"><i class="far fa-comment"></i> ' .  esc_html(  get_comments_number() ) . '</span>';
    }
    echo '</div>';
    
    if ($settings['show_content'] === 'yes') {
        $word_limit = !empty($settings['content_word_limit']) ? $settings['content_word_limit'] : 20;
        
        if ($settings['content_type'] === 'excerpt') {
            $content = get_the_excerpt();
            if (empty($content)) {
                $content = get_the_content();
            }
        } else {
            $content = get_the_content();
        }
        
        // Apply word limit to both excerpt and content
        $content = esc_html( wp_trim_words($content, $word_limit, '...') );
        
        // Apply content filters (for shortcodes, formatting etc.)
        $content = apply_filters('the_content', $content);
        
        echo '<div class="huge-post-excerpt">'. wp_kses_post($content) . '</div>';
    }
    echo '</div></div></div>';
}

function render_thha_huge_style8($settings) {
    // Modern Hover Design
    echo '<div class="huge-post-item huge-post-style-8">';
    
    echo '<div class="huge-post-thumbnail">';
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        echo '<a href="' . esc_url( get_permalink() ) . '">' . get_the_post_thumbnail(get_the_ID(), isset($settings['image_size']) ? $settings['image_size'] : 'large') . '</a>';
    }
    echo '<div class="huge-post-hover-content">';
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';
    
    echo '<div class="huge-post-meta">';
    if ($settings['show_date'] === 'yes') {
        echo '<span class="huge-post-date">' . get_the_date() . '</span>';
    }
    echo '</div>';
    
    if ($settings['show_readmore'] === 'yes') {
        echo '<a href="' . esc_url( get_permalink() ) . '" class="huge-read-more"><i class="fas fa-long-arrow-alt-right"></i></a>';
    }
    echo '</div></div>';

    if ($settings['show_category'] === 'yes') {
        $categories = get_the_category();
        if (!empty($categories)) {
            echo '<div class="huge-post-category"><a href="' . esc_url(get_category_link($categories[0]->term_id)) . '">' . esc_html($categories[0]->name) . '</a></div>';
        }
    }


    if ($settings['show_content'] === 'yes') {
        $word_limit = !empty($settings['content_word_limit']) ? $settings['content_word_limit'] : 20;
        
        if ($settings['content_type'] === 'excerpt') {
            $content = get_the_excerpt();
            if (empty($content)) {
                $content = get_the_content();
            }
        } else {
            $content = get_the_content();
        }
        
        // Apply word limit to both excerpt and content
        $content = esc_html( wp_trim_words($content, $word_limit, '...') );
        
        // Apply content filters (for shortcodes, formatting etc.)
        $content = apply_filters('the_content', $content);
        
        echo '<div class="huge-post-excerpt">'. wp_kses_post($content) . '</div>';
    }

    if ($settings['show_tags'] === 'yes') {
        $tags = get_the_tags();
        if (!empty($tags)) {
            echo '<div class="huge-post-tags">';
            foreach ($tags as $tag) {
                echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
            }
            echo '</div>';
        }
    }

    echo '</div>';
}

function render_thha_huge_style9($settings) {
    // Creative Tilt Design
    echo '<div class="huge-post-item huge-post-style-9">';
    echo '<div class="huge-post-tilt-box">';
    
    echo '<div class="huge-post-thumbnail">';
    if ($settings['show_image'] === 'yes' && has_post_thumbnail()) {
        echo '<a href="' . esc_url( get_permalink() ) . '">' . get_the_post_thumbnail(get_the_ID(), isset($settings['image_size']) ? $settings['image_size'] : 'large') . '</a>';
    }
    echo '</div>';
    
    echo '<div class="huge-post-content">';
    if ($settings['show_category'] === 'yes') {
        $categories = get_the_category();
        if (!empty($categories)) {
            echo '<div class="huge-post-category">' . esc_html($categories[0]->name) . '</div>';
        }
    }
    
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';
    
    echo '<div class="huge-post-meta">';
    if ($settings['show_author'] === 'yes') {
        echo '<span class="huge-post-author"><i class="fas fa-user"></i> ' . get_the_author() . '</span>';
    }
    if ($settings['show_date'] === 'yes') {
        echo '<span class="huge-post-date">' . get_the_date() . '</span>';
    }
    echo '</div>';
    
    if ($settings['show_content'] === 'yes') {
        $word_limit = !empty($settings['content_word_limit']) ? $settings['content_word_limit'] : 20;
        
        if ($settings['content_type'] === 'excerpt') {
            $content = get_the_excerpt();
            if (empty($content)) {
                $content = get_the_content();
            }
        } else {
            $content = get_the_content();
        }
        
        // Apply word limit to both excerpt and content
        $content = esc_html( wp_trim_words($content, $word_limit, '...') );
        
        // Apply content filters (for shortcodes, formatting etc.)
        $content = apply_filters('the_content', $content);
        
        echo '<div class="huge-post-excerpt">'. wp_kses_post($content) . '</div>';
    }

    if ($settings['show_tags'] === 'yes') {
        $tags = get_the_tags();
        if (!empty($tags)) {
            echo '<div class="huge-post-tags">';
            foreach ($tags as $tag) {
                echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
            }
            echo '</div>';
        }
    }
    
    if ($settings['show_readmore'] === 'yes') {
        echo '<a href="' . esc_url( get_permalink() ) . '" class="huge-read-more">' . esc_html__( 'Continue Reading', 'huge-addons-for-elementor' ) . '</a>';

    }
    echo '</div></div></div>';
}

function render_thha_huge_style10($settings) {
    // Minimal List Design
    echo '<div class="huge-post-item huge-post-style-10">';
    
    if ($settings['show_date'] === 'yes') {
        echo '<div class="huge-post-date">';
        echo '<span class="huge-date-day">' . get_the_date('d') . '</span>';
        echo '<span class="huge-date-month">' . get_the_date('M') . '</span>';
        echo '</div>';
    }
    
    echo '<div class="huge-post-content">';
    echo '<h3 class="huge-post-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( wp_trim_words(get_the_title(), $settings['title_word_limit'], '...') ) . '</a></h3>';
    
    echo '<div class="huge-post-meta">';
    if ($settings['show_author'] === 'yes') {
        echo '<span class="huge-post-author">' . esc_html__('By', 'huge-addons-for-elementor') . ' ' . get_the_author() . '</span>';
    }
    if ($settings['show_comments'] === 'yes') {
        echo '<span class="huge-post-comments">' . esc_html( get_comments_number() ) . ' ' . esc_html__('Comments', 'huge-addons-for-elementor') . '</span>';
    }
    echo '</div>';
    
    if ($settings['show_content'] === 'yes') {
        $word_limit = !empty($settings['content_word_limit']) ? $settings['content_word_limit'] : 20;
        
        if ($settings['content_type'] === 'excerpt') {
            $content = get_the_excerpt();
            if (empty($content)) {
                $content = get_the_content();
            }
        } else {
            $content = get_the_content();
        }
        
        // Apply word limit to both excerpt and content
        $content = esc_html( wp_trim_words($content, $word_limit, '...') );
        
        // Apply content filters (for shortcodes, formatting etc.)
        $content = apply_filters('the_content', $content);
        
        echo '<div class="huge-post-excerpt">'. wp_kses_post($content) . '</div>';
    }
    echo '</div></div>';
}


function render_pagination($query, $settings, $unique_id) {
    if ($settings['pagination_type'] === 'load_more') {
        $max_pages = $query->max_num_pages;
        if ($max_pages > 1) {
            echo '<div class="load-more-wrapper">';
            echo '<button class="load-more-btn" 
                      data-container="' . esc_attr($unique_id) . '"
                      data-page="1" 
                      data-max-pages="' . esc_attr($max_pages) . '"
                      data-posts-per-page="' . esc_attr($settings['posts_per_page']) . '"
                      data-category="' . esc_attr($settings['selected_category']) . '"
                      data-post-style="' . esc_attr($settings['post_style']) . '"
                      data-show-image="' . esc_attr($settings['show_image']) . '"
                      data-show-category="' . esc_attr($settings['show_category']) . '"
                      data-show-content="' . esc_attr($settings['show_content']) . '"
                      data-content-type="' . esc_attr($settings['content_type']) . '"
                      data-show-author="' . esc_attr($settings['show_author']) . '"
                      data-show-date="' . esc_attr($settings['show_date']) . '"
                      data-image-size="' . esc_attr($settings['image_size']) . '"
                      data-title-word-limit="' . esc_attr($settings['title_word_limit']) . '"
                      data-content-word-limit="' . esc_attr($settings['content_word_limit']) . '" >'
                   . esc_html__('Load More', 'huge-addons-for-elementor') 
                   . '</button>';
            echo '</div>';
        }
    } elseif ($settings['pagination_type'] === 'pagination') {
        $total_pages = $query->max_num_pages;
        if ($total_pages > 1) {
            $current_page = max(1, get_query_var('paged'), get_query_var('page'));
            
            echo '<div class="post-grid-pagination">';
            echo wp_kses_post( paginate_links( [
                'base'      => add_query_arg( 'paged', '%#%' ),
                'format'    => '?paged=%#%',
                'current'   => $current_page,
                'total'     => $total_pages,
                'prev_text' => esc_html__( '« Previous', 'huge-addons-for-elementor' ),
                'next_text' => esc_html__( 'Next »', 'huge-addons-for-elementor' ),
                'type'      => 'list',
                'end_size'  => 1,
                'mid_size'  => 2,
            ] ) );
            echo '</div>';

        }
    }
}
