<?php

namespace HugeAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;



if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

class HugeAdvancedIconBoxWidget extends Widget_Base {

    public function get_name() {
        return 'thha-huge-advanced-icon-box';
    }

    public function get_title() {
        return __( 'Huge Advanced Icon Box', 'huge-addons-for-elementor' );
    }

    public function get_icon() {
        return 'thha-icon hugeicon-advanced-icon-box';
    }

    public function get_categories() {
        return ['thha-addons-category']; 
    }

    public function get_style_depends() {
        $widget_name = strtolower( str_replace( '_', '-', $this->get_name() ) );
        $css_file_path = THHA_PLUGIN_PATH . "public/css/{$widget_name}.min.css";

        if ( file_exists( $css_file_path ) ) {
            wp_register_style( $widget_name, THHA_URL . "public/css/{$widget_name}.min.css", [], THHA_VERSION );
            return [ $widget_name ];
        }
        return [];
    }

    public function get_script_depends() {
        $widget_name = strtolower( str_replace( '_', '-', $this->get_name() ) );
        $js_file_path = THHA_PLUGIN_PATH . "public/js/{$widget_name}.min.js";

        if ( file_exists( $js_file_path ) ) {
            wp_register_script( $widget_name, THHA_URL . "public/js/{$widget_name}.min.js", ['jquery'], THHA_VERSION, true );
            return [ $widget_name ];
        }
        return [];
    }

    protected function _register_controls() {
      // Content Section
      $this->start_controls_section(
          'icon_box_content_section',
          [
              'label' => __( 'Content', 'huge-addons-for-elementor' ),
              'tab'   => Controls_Manager::TAB_CONTENT,
          ]
      );

      $this->add_control(
          'title',
          [
              'label'   => __( 'Title', 'huge-addons-for-elementor' ),
              'type'    => Controls_Manager::TEXT,
              'default' => __( 'Icon Box Title', 'huge-addons-for-elementor' ),
          ]
      );

      $this->add_control(
          'description',
          [
              'label'   => __( 'Description', 'huge-addons-for-elementor' ),
              'type'    => Controls_Manager::TEXTAREA,
              'default' => __( 'This is a description', 'huge-addons-for-elementor' ),
          ]
      );

      // Icon Section
      $this->add_control(
          'icon_type',
          [
              'label'   => __( 'Icon Type', 'huge-addons-for-elementor' ),
              'type'    => Controls_Manager::SELECT,
              'options' => [
                  'icon'   => __( 'Icon', 'huge-addons-for-elementor' ),
                  'image'  => __( 'Image', 'huge-addons-for-elementor' ),
                  'none'   => __( 'None', 'huge-addons-for-elementor' ),
              ],
              'default' => 'icon',
          ]
      );

      $this->add_control(
          'icon',
          [
              'label' => __( 'Icon', 'huge-addons-for-elementor' ),
              'type'  => Controls_Manager::ICONS,
              'default' => [
                  'value'   => 'fas fa-star', 
                  'library' => 'solid',
              ],
              'condition' => [
                  'icon_type' => 'icon',
              ],
          ]
      );

      $this->add_control(
          'icon_image',
          [
              'label'   => __( 'Image', 'huge-addons-for-elementor' ),
              'type'    => Controls_Manager::MEDIA,
              'condition' => [
                  'icon_type' => 'image',
              ],
          ]
      );

      $this->end_controls_section();

      // Style Section
      $this->start_controls_section(
          'icon_box_style_section',
          [
              'label' => __( 'Style', 'huge-addons-for-elementor' ),
              'tab'   => Controls_Manager::TAB_STYLE,
          ]
      );

      $this->add_control(
          'icon_color',
          [
              'label'     => __( 'Icon Color', 'huge-addons-for-elementor' ),
              'type'      => Controls_Manager::COLOR,
              'selectors' => [
                  '{{WRAPPER}} .thha-icon' => 'color: {{VALUE}};',
              ],
          ]
      );

      $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $icon_color = !empty($settings['icon_color']) ? $settings['icon_color'] : '#333';
        ?>
        <div class="thha-advanced-icon-box">
            <div class="thha-advanced-icon-box-icon">
            <?php
                if ( 'icon' === $settings['icon_type'] && ! empty( $settings['icon']['value'] ) ) {
                if( isset($settings['icon']['value']['url'] ) && !empty($settings['icon']['value']['url']) ) {
                    echo '<img src="' . esc_url( $settings['icon']['value']['url'] ) . '" alt="Icon" style="color: ' . esc_attr($icon_color) . ';">';
                }else{
                    echo '<i class="' . esc_attr( $settings['icon']['value'] ) . '" style="color: ' . esc_attr($icon_color) . ';"></i>';
                }
                    // Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );
                } elseif ( 'image' === $settings['icon_type'] && ! empty( $settings['icon_image']['url'] ) ) {
                    echo '<img src="' . esc_url( $settings['icon_image']['url'] ) . '" alt="Icon">';
                } 
            ?>
            </div>
            <div class="thha-advanced-icon-box-content">
                <h3 class="thha-advanced-icon-box-title"><?php echo esc_html( $settings['title'] ); ?></h3>
                <p class="thha-advanced-icon-box-description"><?php echo wp_kses_post( $settings['description'] ); ?></p>
            </div>
        </div>
        <?php

    }
}
