<?php
namespace HugeAddons;
use HugeAddons\Classes\NotificationManager;

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

use HugeAddons\Classes\WidgetManager;
use HugeAddons\Classes\ExtensionManager;
use HugeAddons\Classes\Admin;
use HugeAddons\Loader;


class Main {
    public $widget_manager;
    public function __construct() {
        $this->init();
    }

    private function init() {
        // Initialize Admin pages
        new Admin();

        // Initialize Extensions
        $this->init_extensions();

        // Initialize Widget Manager
        $widget_manager = new WidgetManager();
        // $extensions_manager = new ExtensionManager();
        add_action('elementor/widgets/register', [$widget_manager, 'register_widgets']);

        // Initialize Loader for icons and other assets
        $loader = new Loader();
        $loader->init();

        // Initialize Notification Manager and add notices
        $this->setup_notices();
        
        // Load in frontend + Elementor preview iframe
        add_action( 'wp_enqueue_scripts', [ $this, 'load_thha_scripts' ] );

        // Load in Elementor editor panel (left sidebar)
        add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'load_thha_scripts' ] );

        $this->widget_manager = $widget_manager;
    }

    /**
     * Setup admin notices.
     */
    private function setup_notices() {
        $notification_manager = NotificationManager::instance();
        delete_option('thha_notice');
        // $notification_manager->add_notice([
        //     'unique_id' => 'huge_addons_review_request',
        //     'message'   => '<b>Found beneficial HugeAddons?</b> Please <a href="https://wordpress.org/support/plugin/huge-addons-for-elementor/reviews/" target="_blank">leave us a review</a>!',
        //     'type'      => 'info',
        //     'buttons'   => [
        //         ['label' => 'Review Now', 'url' => 'https://wordpress.org/support/plugin/huge-addons-for-elementor/reviews/', 'target' => '_blank', 'class' => 'button-primary'],
        //     ],
        //     'reminder'  => true,
        // ]);
    }

    public function load_thha_scripts() {
        wp_enqueue_style(
            'thha-common-style',
            trailingslashit( THHA_URL ) . 'public/css/common.min.css',
            array(),
            THHA_VERSION,
            'all'
        );
    }

    /**
     * Initialize Elementor extensions
     */
    private function init_extensions() {
        // Load Custom CSS Extension
        require_once THHA_PLUGIN_PATH . 'includes/extentions/custom-css.php';
    }

}
?>