<?php 
/**
 * Plugin Name: Huge Addons for Elementor
 * Description: Huge Addons for Elementor brings a set of modern, flexible widgets to enhance your Elementor-powered website. Easily add interactive parallax images, advanced image galleries, accordions, post grids, icon boxes, and flip boxes with rich customization options.
 * Author: mahafujurmasum
 * Version: 1.0.7.6
 * Text Domain: huge-addons-for-elementor
 * Elementor tested up to: 3.34.2  
 * Elementor Pro tested up to: 3.34.2  
 * Domain Path: /languages
 * Requires Plugins: elementor
 * License: GNU General Public License v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Prevent direct access
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$thha_plugin_data = get_file_data(
	__FILE__,
	array(
		'Plugin Name' => 'Plugin Name',
		'Version'     => 'Version',
		'Author'      => 'Author',
		'Description' => 'Description',
	),
	false
);

if( !defined('THHA')){
    define('THHA', $thha_plugin_data['Plugin Name']);
}

if( !defined('THHA_PLUGIN_DESC')){
    define('THHA_PLUGIN_DESC', $thha_plugin_data['Description']);
}

if( !defined('THHA_PLUGIN_AUTHOR')){
    define('THHA_PLUGIN_AUTHOR', $thha_plugin_data['Author']);
}

if( !defined('THHA_VERSION')){
    define('THHA_VERSION', $thha_plugin_data['Version']);
}

if( !defined('THHA_BASE')){
    define('THHA_BASE', plugin_basename(__FILE__));
}

if( !defined('THHA_SLUG')){
    define('THHA_SLUG', dirname(plugin_basename(__FILE__)));
}

if( !defined('THHA_PLUGIN_FILE')){
    define('THHA_PLUGIN_FILE', __FILE__);
}

if( !defined('THHA_URL')){
    define('THHA_URL', plugin_dir_url( __FILE__ ) );
}

if( !defined('THHA_PLUGIN_PATH')){
    define('THHA_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
}

if( !defined('THHA_WIDGET_PREFIX')){
    define('THHA_WIDGET_PREFIX', 'thha_' ); 
}

if( !defined('THHA_WIDGETS_JSON')){
    define('THHA_WIDGETS_JSON', THHA_PLUGIN_PATH . 'widgets.json');
}

if( !defined('THHA_EXTENSIONS_JSON')){
    define('THHA_EXTENSIONS_JSON', THHA_PLUGIN_PATH . 'extensions.json');
}

// Include Composer autoloader
if ( file_exists( THHA_PLUGIN_PATH . 'vendor/autoload.php' ) ) {
    require_once THHA_PLUGIN_PATH . 'vendor/autoload.php';
}

require_once THHA_PLUGIN_PATH . 'includes/functions.php';

// Main class instance
final class HugeAddons {
    private static $instance = null;

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor.
     */
    private function __construct() {
        $this->setup_hooks();
    }

    /**
     * Setup plugin hooks.
     */
    private function setup_hooks() {
        // Activation and deactivation hooks
        register_activation_hook( THHA_PLUGIN_FILE, [ '\HugeAddons\Activator', 'activate' ] );
        register_deactivation_hook( THHA_PLUGIN_FILE, [ '\HugeAddons\Deactivator', 'deactivate' ] );

        add_action( 'plugins_loaded', [ $this, 'init' ] );
    }

    /**
     * Initialize the plugin.
     *
     * This is where we load the components and run the main logic.
     */
    public function init() {
        // Check for Elementor
        if ( ! did_action( 'elementor/loaded' ) ) {
            add_action( 'admin_notices', [ $this, 'admin_notice_missing_elementor' ] );
            return;
        }

        // Initialize plugin components
        new \HugeAddons\Main();
    }

    public function admin_notice_missing_elementor() {
        if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );
        $message = sprintf( esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'huge-addons-for-elementor' ), '<strong>' . esc_html( THHA ) . '</strong>', '<strong>' . esc_html__( 'Elementor', 'huge-addons-for-elementor' ) . '</strong>' );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }
}

// Get the instance of the HugeAddons class
HugeAddons::get_instance();
