<?php
/**
 * Plugin Name: HTML5 Semantic Elements
 * Plugin URI: https://wordpress.org/plugins/html5-semantic-elements
 * Description: Adds Article and Aside blocks for HTML5 semantic elements in the WordPress block editor
 * Version: 1.0.2
 * Author: Nic Ward
 * Author URI: http://2cp.net
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: html5-semantic-elements
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class HTML5_Semantic_Elements {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('init', array($this, 'register_blocks'));
        add_action('enqueue_block_editor_assets', array($this, 'enqueue_editor_assets'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_frontend_styles'));
    }
    
    public function register_blocks() {
        // Register Article block
        register_block_type('html5-semantic/article', array(
            'api_version' => 2,
            'title' => __('Article', 'html5-semantic-elements'),
            'description' => __('HTML5 Article element for independent content', 'html5-semantic-elements'),
            'category' => 'design',
            'icon' => 'media-document',
            'keywords' => array('article', 'html5', 'semantic'),
            'supports' => array(
                'html' => false,
                'align' => array('wide', 'full'),
                'anchor' => true,
                'className' => true,
            ),
        ));
        
        // Register Aside block
        register_block_type('html5-semantic/aside', array(
            'api_version' => 2,
            'title' => __('Aside', 'html5-semantic-elements'),
            'description' => __('HTML5 Aside element for tangentially related content', 'html5-semantic-elements'),
            'category' => 'design',
            'icon' => 'align-right',
            'keywords' => array('aside', 'sidebar', 'html5', 'semantic'),
            'supports' => array(
                'html' => false,
                'align' => array('left', 'right', 'wide', 'full'),
                'anchor' => true,
                'className' => true,
            ),
        ));
    }
    
    public function enqueue_editor_assets() {
        wp_enqueue_script(
            'html5-semantic-blocks',
            plugins_url('js/blocks.js', __FILE__),
            array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n'),
            '1.0.3',
            true
        );
        
        wp_enqueue_style(
            'html5-semantic-blocks-editor',
            plugins_url('css/editor.css', __FILE__),
            array('wp-edit-blocks'),
            '1.0.3'
        );
    }
    
    public function enqueue_frontend_styles() {
        wp_enqueue_style(
            'html5-semantic-blocks-frontend',
            plugins_url('css/frontend.css', __FILE__),
            array(),
            '1.0.3'
        );
    }
}

// Initialize plugin
HTML5_Semantic_Elements::get_instance();