<?php
/**
 * Plugin Name: Hover Preview
 * Plugin URI: https://lavrynenko.com/hover-preview
 * Description: Displays a website preview when hovering over a link.
 * Version: 1.1
 * Author: Oleksiy Lavrynenko
 * Author URI: https://lavrynenko.com
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.0
 * Requires PHP: 7.4
 */

function hover_preview_enqueue_scripts() {
    wp_enqueue_script('hover-preview-js', plugins_url('hover-preview.js', __FILE__), array('jquery'), '1.0', true);
    wp_enqueue_style('hover-preview-css', plugins_url('hover-preview.css', __FILE__));

    // Pass the API key to JavaScript
    wp_localize_script('hover-preview-js', 'hoverPreviewData', array(
        'apiKey' => get_option('hover_preview_api_key', ''), // Retrieve the API key from settings
    ));
}
add_action('wp_enqueue_scripts', 'hover_preview_enqueue_scripts');

// Create the plugin settings page
function hover_preview_settings_menu() {
    add_options_page(
        'Hover Preview Settings', // Page title
        'Hover Preview',          // Menu title
        'manage_options',         // Capability
        'hover-preview',          // Menu slug
        'hover_preview_settings_page' // Callback function
    );
}
add_action('admin_menu', 'hover_preview_settings_menu');

// Function to display the settings page
function hover_preview_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    // Save settings
    if (isset($_POST['hover_preview_api_key'])) {
        check_admin_referer('hover_preview_save_settings'); // Nonce verification
        update_option('hover_preview_api_key', sanitize_text_field($_POST['hover_preview_api_key']));
        echo '<div class="updated"><p>API key saved!</p></div>';
    }

    // Retrieve the current API key
    $apiKey = get_option('hover_preview_api_key', '');
    ?>
    <div class="wrap">
        <h1>Hover Preview Settings</h1>
        <form method="POST" action="">
            <?php wp_nonce_field('hover_preview_save_settings'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="hover_preview_api_key">PagePeeker API Key</label></th>
                    <td>
                        <input type="text" name="hover_preview_api_key" id="hover_preview_api_key" 
                               value="<?php echo esc_attr($apiKey); ?>" class="regular-text">
                        <p class="description">
                            Enter your API key to use PagePeeker. <br>
                            If you don't have one, you can get a free API key by signing up at 
                            <a href="https://pagepeeker.com/signup/unbranded/" target="_blank">https://pagepeeker.com/signup/unbranded/</a>.
                        </p>
                    </td>
                </tr>
            </table>
            <?php submit_button('Save Settings'); ?>
        </form>
    </div>
    <?php
}
?>
