jQuery(document).ready(function ($) {
    const previewFrame = $('<div id="hover-preview-frame"></div>').css({
        position: 'absolute',
        width: '150px',
        height: '100px',
        border: '1px solid #ccc',
        display: 'none',
        overflow: 'hidden',
        zIndex: 9999,
        backgroundColor: '#fff',
    }).appendTo('body');

    const apiKey = hoverPreviewData.apiKey; // Получаем API-ключ из локализированных данных

    $('a').hover(function (e) {
        const link = $(this).attr('href');

        // Убедимся, что ссылка содержит протокол http или https
        if (link && (link.startsWith('http://') || link.startsWith('https://'))) {
            // Используем PagePeeker для получения превью сайта
            const previewURL = `https://api.pagepeeker.com/v2/thumbs.php?size=s&url=${encodeURIComponent(link)}&key=${apiKey}`;
            previewFrame.html(`<img src="${previewURL}" alt="Preview" style="width: 100%; height: 100%;">`);
            previewFrame.css({
                top: e.pageY + 10 + 'px',
                left: e.pageX + 10 + 'px',
                display: 'block',
            });
        }
    }, function () {
        previewFrame.hide();
        previewFrame.html('');
    });

    $(document).on('mousemove', function (e) {
        previewFrame.css({
            top: e.pageY + 10 + 'px',
            left: e.pageX + 10 + 'px',
        });
    });
});
