<div class="wrap hizzle-recaptcha-settings">

	<?php

		// Display the title.
		printf(
			'<h1>%s</h1>',
			esc_html( get_admin_page_title() )
		);

		// Fire a hook before printing the settings page.
		do_action( 'hizzle_recaptcha_settings_page_top' );

		if ( false === $saved_settings ) {
			printf(
				'<div class="error is-dismissible hizzle-recaptcha-notice"><p>%s</p></div>',
				esc_html__( 'Could not save your settings. Please try again.', 'hizzle-recaptcha' )
			);
		}

		if ( true === $saved_settings ) {
			printf(
				'<div class="notice notice-success is-dismissible hizzle-recaptcha-notice"><p>%s</p></div>',
				esc_html__( 'Your settings have been saved.', 'hizzle-recaptcha' )
			);
		}

		$selected_type = hizzle_recaptcha_get_option( 'handler', 'recaptcha_v2' );
		$captcha_types = array(
			'Google reCAPTCHA'                 => array(
				'recaptcha_v2'           => __( 'Challenge (v2) - "I\'m not a robot" Checkbox', 'hizzle-recaptcha' ),
				'recaptcha_v2_invisible' => __( 'Challenge (v2) - Invisible', 'hizzle-recaptcha' ),
				'recaptcha_v3'           => __( 'Score based (v3) - Invisible', 'hizzle-recaptcha' ),
			),
			__( 'Others', 'hizzle-recaptcha' ) => array(
				'turnstile' => __( 'Cloudflare Turnstile (Recommended)', 'hizzle-recaptcha' ),
			),
		);

		$has_all_handlers = true;
		?>

	<style>
		.hizzle-recaptcha-field-wrapper {
			display: flex;
			margin-top: 16px;
			margin-bottom: 32px;
			text-align: left;
		}
		.hizzle-recaptcha-label {
			max-width: 200px;
			flex: 1 0 200px;
			font-weight: 600;
		}
		.hizzle-recaptcha_settings-wrapper {
			flex: 1 0 0;
		}
		.notice:not(.hizzle-recaptcha-notice),
		div.error:not(.hizzle-recaptcha-notice),
		div.updated:not(.hizzle-recaptcha-notice) {
			display: none!important;
		}
		.hizzle-recaptcha-upgrade-box {
			background-color: #c8e6c9;
			border: 1px solid #4caf50;
			max-width: 600px;
			padding: 16px;
			border-radius: 4px;
			margin-bottom: 16px;
		}
	</style>
	<form method="POST" class="hizzle-recaptcha-main-settings-form">
		<?php wp_nonce_field( 'hizzle-recaptcha', 'hizzle-recaptcha' ); ?>

			<label class="hizzle-recaptcha-field-wrapper" id="hizzle-recaptcha-field-wrapper__handler">
				<span class="hizzle-recaptcha-label"><?php esc_html_e( 'CAPTCHA Type', 'hizzle-recaptcha' ); ?></span>
				<div class="hizzle-recaptcha_settings-wrapper">
					<select name="hizzle_recaptcha[handler]" id="hizzle-recaptcha-handler" style="width: 25em;">
						<option value=""><?php esc_html_e( 'Select a CAPTCHA type', 'hizzle-recaptcha' ); ?></option>
						<?php foreach ( $captcha_types as $label => $sub_types ) : ?>
							<optgroup label="<?php echo esc_html( $label ); ?>">
								<?php
								foreach ( $sub_types as $recaptcha_type => $label ) {
									$available = apply_filters( 'hizzle_recaptcha_has_handler_' . $recaptcha_type, false );
									printf(
										'<option value="%s" %s %s>%s</option>',
										esc_attr( $recaptcha_type ),
										selected( $recaptcha_type, $selected_type, false ),
										$available ? '' : 'disabled',
										$available ? esc_html( $label ) : esc_html( $label ) . ' 🔒'
									);

									if ( ! $available ) {
										$has_all_handlers = false;
									}
								}
								?>
							</optgroup>
						<?php endforeach; ?>
					</select>
					<?php if ( ! $has_all_handlers ) : ?>
						<p class="description">
							<?php
								printf(
									/* translators: %s: Upgrade link */
									esc_html__( 'Want to make your forms even more user-friendly and secure? %1$sUpgrade to unlock more CAPTCHA types%2$s.', 'hizzle-recaptcha' ),
									sprintf(
										'<a href="%s">',
										esc_url( hizzle_recaptcha_fs()->get_upgrade_url() )
									),
									'</a>'
								);
							?>
						</p>
					<?php endif; ?>
				</div>
			</label>

		<?php foreach ( $settings as $setting_id => $args ) : ?>

			<label class="hizzle-recaptcha-field-wrapper" id="hizzle-recaptcha-field-wrapper__<?php echo esc_attr( $setting_id ); ?>">
				<span class="hizzle-recaptcha-label"><?php echo esc_html( $args['label'] ); ?></span>
				<div class="hizzle-recaptcha_settings-wrapper">
					<?php if ( 'text' === $args['type'] ) : ?>
						<input
							type="text"
							class="regular-text"
							name="hizzle_recaptcha[<?php echo esc_attr( $setting_id ); ?>]"
							value="<?php echo esc_attr( hizzle_recaptcha_get_option( $setting_id, ! isset( $args['default'] ) ? '' : $args['default'] ) ); ?>"
						>
					<?php endif; ?>
					<?php if ( 'checkbox' === $args['type'] ) : ?>
						<input
							type="checkbox"
							name="hizzle_recaptcha[<?php echo esc_attr( $setting_id ); ?>]"
							<?php checked( null !== hizzle_recaptcha_get_option( $setting_id, null ) ); ?>
							value="1"
						>&nbsp;<span><?php echo wp_kses_post( $args['label2'] ); ?></span>
					<?php endif; ?>
					<?php if ( 'select' === $args['type'] ) : ?>
						<select name="hizzle_recaptcha[<?php echo esc_attr( $setting_id ); ?>]" id="hizzle-recaptcha-<?php echo esc_attr( $setting_id ); ?>" style="width: 25em;">
							<?php foreach ( $args['options'] as $option_value => $option_label ) : ?>
								<option
									value="<?php echo esc_attr( $option_value ); ?>"
									<?php selected( $option_value, hizzle_recaptcha_get_option( $setting_id, ! isset( $args['default'] ) ? '' : $args['default'] ) ); ?>
								>
									<?php echo esc_html( $option_label ); ?>
								</option>
							<?php endforeach; ?>
						</select>
					<?php endif; ?>
					<?php do_action( 'hizzle_recaptcha_settings_display_' . $args['type'], $args, $setting_id ); ?>
					<?php
					if ( ! empty( $args['desc'] ) ) {
						printf(
							'<p class="description">%s</p>',
							wp_kses_post( $args['desc'] )
						);
					}
					?>
				</div>
			</label>

			<?php if ( ! empty( $args['handlers'] ) ) : ?>
				<script>
					jQuery( document ).ready( function( $ ) {
						var onChange = function() {
							var handler = $( '#hizzle-recaptcha-handler' ).val();
							var required = <?php echo wp_json_encode( $args['handlers'] ); ?>;
							if ( required.includes( handler ) ) {
								$( '#hizzle-recaptcha-field-wrapper__<?php echo esc_attr( $setting_id ); ?>' ).show();
							} else {
								$( '#hizzle-recaptcha-field-wrapper__<?php echo esc_attr( $setting_id ); ?>' ).hide();
							}
						};
						$( '#hizzle-recaptcha-handler' ).on( 'change', onChange );
						onChange();
					});
				</script>
			<?php endif; ?>
		<?php endforeach; ?>

		<div class="hizzle-recaptcha-field-wrapper">
			<span class="hizzle-recaptcha-label"><?php esc_html_e( 'Show reCAPTCHA on:', 'hizzle-recaptcha' ); ?></span>
			<div class="hizzle-recaptcha_settings-wrapper">
				<?php foreach ( $available_integrations as $integration_id => $integration ) : ?>
					<?php
					printf(
						'<label style="margin-bottom: 10px; display: block;"><input type="checkbox" name="hizzle_recaptcha[enabled_integrations][]" value="%s" %s> <span>%s</span></label>',
						esc_attr( $integration_id ),
						checked( in_array( $integration_id, $enabled_integrations, true ), true, false ),
						esc_html( $integration )
					);
					?>
				<?php endforeach; ?>
			</div>
		</div>

		<?php submit_button(); ?>

	</form>
	<?php do_action( 'hizzle_recaptcha_settings_page_bottom' ); ?>
</div>
