<?php
/**
 * Contains the main wp foro reply class.
 *
 * @package Hizzle
 * @subpackage ReCaptcha
 * @since   1.0.0
 */

namespace Hizzle\Recaptcha\Integrations;

defined( 'ABSPATH' ) || exit;

/**
 * WP Foro reply integration Class.
 *
 */
class WPForo_Reply extends Integration {

	/**
	 * Class constructor
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		add_action( 'wpforo_editor_post_submit_before', array( $this, 'display' ), 99 );
		add_filter( 'wpforo_add_post_data_filter', array( $this, 'verify_wpforo_token' ) );
	}

	/**
	 * Displays the checkbox..
	 *
	 * @since 1.0.0
	 */
	public function display() {
		echo '<div style="padding: 20px;">';
		parent::display();
		echo '</div>';
	}

	/**
	 * Verifies new topic tokens.
	 *
	 * @since 1.0.0
	 */
	public function verify_wpforo_token( $data ) {

		$error = $this->is_valid();

		if ( is_wp_error( $error ) ) {
			WPF()->notice->add( esc_html( $error->get_error_message() ), 'error' );
			return false;
		}

		return $data;
	}
}
