<?php
/**
 * Contains the main password reset class.
 *
 * @package Hizzle
 * @subpackage ReCaptcha
 * @since   1.0.0
 */

namespace Hizzle\Recaptcha\Integrations;

defined( 'ABSPATH' ) || exit;

/**
 * Resetpass integration Class.
 *
 */
class Reset_Password extends Integration {

	/**
	 * Class constructor
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		add_action( 'resetpass_form', array( $this, 'display' ) );
		add_action( 'woocommerce_resetpassword_form', array( $this, 'display' ) );
		add_action( 'validate_password_reset', array( $this, 'add_wp_error_if_invalid' ) );
	}
}
