<?php

/**
 * Main plugin class.
 *
 * @version 1.0.0
 */

namespace Hizzle\Recaptcha\Integrations;

defined( 'ABSPATH' ) || exit;

/**
 * Main plugin class.
 */
class Main {

	/**
	 * Enabled integrations.
	 *
	 * @var Integration[]
	 */
	public static $integrations = array();

	/**
	 * Class Constructor.
	 */
	public function __construct() {
		$this->load_integrations();
	}

	/**
	 * Checks if we should load the integrations.
	 *
	 * @since 1.0.0
	 */
	public function load_integrations() {

		// Load a list of available enabled integrations.
		$available_integrations = self::get_available_integrations();
		foreach ( $this->get_enabled_integrations() as $integration ) {

			// Ensure that it is available.
			if ( isset( $available_integrations[ $integration ] ) ) {
				self::$integrations[ $integration ] = new $available_integrations[ $integration ]['class']();
			}
		}
	}

	/**
	 * Retrieves an array of enabled integrations.
	 *
	 * @since 1.0.0
	 */
	public static function get_enabled_integrations() {
		$options = get_option( 'hizzle_recaptcha' );

		if ( empty( $options ) ) {
			return array( 'registration', 'resetpass', 'comment' );
		}

		return empty( $options['enabled_integrations'] ) ? array() : $options['enabled_integrations'];
	}

	/**
	 * Retrieves an array of available integrations.
	 *
	 * @since 1.0.0
	 */
	public static function get_available_integrations() {

		$integrations = apply_filters(
			'hizzle_recaptcha_available_integrations',
			array(
				'login'            => array(
					'name'  => __( 'Login Form', 'hizzle-recaptcha' ),
					'class' => __NAMESPACE__ . '\Login',
				),
				'registration'     => array(
					'name'  => __( 'Registration Form', 'hizzle-recaptcha' ),
					'class' => __NAMESPACE__ . '\Registration',
				),
				'resetpass'        => array(
					'name'  => __( 'Reset Password Form', 'hizzle-recaptcha' ),
					'class' => __NAMESPACE__ . '\Reset_Password',
				),
				'lostpassword'     => array(
					'name'  => __( 'Lost Password Form', 'hizzle-recaptcha' ),
					'class' => __NAMESPACE__ . '\Lost_Password',
				),
				'comment'          => array(
					'name'  => __( 'Comment Form', 'hizzle-recaptcha' ),
					'class' => __NAMESPACE__ . '\Comment',
				),
				'woocommerce'      => array(
					'name'      => __( 'WooCommerce Checkout', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\Woo',
					'installed' => function_exists( 'WC' ),
				),
				'noptin'           => array(
					'name'      => __( 'Noptin Newsletter Forms', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\Noptin',
					'installed' => function_exists( 'noptin' ),
				),
				'bbpress-reply'    => array(
					'name'      => __( 'New Reply (bbPress)', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\BBPress_Reply',
					'installed' => function_exists( 'bbpress' ),
				),
				'bbpress-topic'    => array(
					'name'      => __( 'New Topic (bbPress)', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\BBPress_Topic',
					'installed' => function_exists( 'bbpress' ),
				),
				'buddypress'       => array(
					'name'      => __( 'New Topic (BuddyPress)', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\BuddyPress',
					'installed' => function_exists( 'buddypress' ),
				),
				'cf7'              => array(
					'name'      => __( 'Contact Form 7', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\Contact_Form_7',
					'installed' => function_exists( 'wpcf7' ),
				),
				'mailchimp'        => array(
					'name'      => __( 'Mailchimp for WordPress', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\Mailchimp_4WP',
					'installed' => defined( 'MC4WP_VERSION' ),
				),
				'wpforms'          => array(
					'name'      => __( 'WPForms', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\WPForms',
					'installed' => function_exists( 'wpforms' ),
				),
				'wpforo_new_topic' => array(
					'name'      => __( 'New Topic (wpForo)', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\WPForo_New_Topic',
					'installed' => function_exists( 'WPF' ),
				),
				'wpforo_reply'     => array(
					'name'      => __( 'New Reply (wpForo)', 'hizzle-recaptcha' ),
					'class'     => __NAMESPACE__ . '\WPForo_Reply',
					'installed' => function_exists( 'WPF' ),
				),
			)
		);

		foreach ( $integrations as $key => $data ) {
			if ( isset( $data['installed'] ) && false === $data['installed'] ) {
				unset( $integrations[ $key ] );
			}
		}

		return $integrations;
	}
}
