<?php
/**
 * Contains the main password lost class.
 *
 * @package Hizzle
 * @subpackage ReCaptcha
 * @since   1.0.0
 */

namespace Hizzle\Recaptcha\Integrations;

defined( 'ABSPATH' ) || exit;

/**
 * Lost password integration Class.
 *
 */
class Lost_Password extends Integration {

	/**
	 * Class constructor
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		add_action( 'lostpassword_form', array( $this, 'display' ) );
		add_action( 'woocommerce_lostpassword_form', array( $this, 'display' ) );
		add_action( 'lostpassword_post', array( $this, 'add_wp_error_if_invalid' ) );
	}
}
