<?php
/**
 * Contains the main integration class.
 *
 * @package Hizzle
 * @subpackage ReCaptcha
 * @since   1.0.0
 */

namespace Hizzle\Recaptcha\Integrations;

defined( 'ABSPATH' ) || exit;

/**
 * Main integration Class.
 *
 */
class Integration {

	/**
	 * Retrieves the checkbox html code
	 *
	 * @since 1.0.0
	 */
	public function get_html() {
		ob_start();
		$this->display();
		return ob_get_clean();
	}

	/**
	 * Displays the checkbox.
	 *
	 * @since 1.0.0
	 */
	public function display() {
		$handler = \Hizzle\Recaptcha\Main::instance()->handler;

		if ( $handler instanceof \Hizzle\Recaptcha\Handler ) {
			return $handler->render();
		}
	}

	/**
	 * Checks if the reCAPTCHA was validated.
	 *
	 * @since 1.0.0
	 * @return true|\WP_Error
	 */
	protected function is_valid() {
		$handler = \Hizzle\Recaptcha\Main::instance()->handler;

		if ( $handler instanceof \Hizzle\Recaptcha\Handler ) {
			return $handler->is_valid();
		}

		return true;
	}

	/**
	 * Verifies the token and adds a WP Error if its invalid.
	 *
	 * @since 1.0.0
	 * @param \WP_Error $validation_error
	 */
	public function add_wp_error_if_invalid( $validation_error ) {
		$error = $this->is_valid();

		if ( is_wp_error( $error ) ) {
			$validation_error->add( 'hizzle_recaptcha', esc_html( $error->get_error_message() ) );
		}

		return $validation_error;
	}

	/**
	 * Verifies the token and returns a WP Error if its invalid.
	 *
	 * @since 1.0.0
	 * @param mixed $result
	 * @return \WP_Error
	 */
	public function return_wp_error_if_invalid( $result ) {
		$error = $this->is_valid();

		if ( is_wp_error( $error ) ) {
			return $error;
		}

		return $result;
	}
}
