<?php

/**
 * Main plugin class.
 *
 * @version 1.0.0
 */

namespace Hizzle\Recaptcha;

defined( 'ABSPATH' ) || exit;

/**
 * Admin class.
 */
class Admin {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_filter( 'plugin_action_links_hizzle-recaptcha/plugin.php', array( $this, 'link_to_settings' ) );
		add_filter( 'plugin_action_links_hizzle-recaptcha-premium/plugin.php', array( $this, 'link_to_settings' ) );
		add_action( 'admin_menu', array( $this, 'add_menu_page' ) );
	}

	/**
	 * Adds the menu page.
	 */
	public function add_menu_page() {
		add_menu_page(
			__( 'Hizzle CAPTCHA', 'hizzle-recaptcha' ),
			__( 'CAPTCHA', 'hizzle-recaptcha' ),
			'manage_options',
			'hizzle-recaptcha',
			null,
			'dashicons-shield'
		);

		add_submenu_page(
			'hizzle-recaptcha',
			__( 'Hizzle CAPTCHA', 'hizzle-recaptcha' ),
			__( 'Settings', 'hizzle-recaptcha' ),
			'manage_options',
			'hizzle-recaptcha',
			array( $this, 'display_settings_page' )
		);
	}

	/**
	 * Displays the settings page.
	 */
	public function display_settings_page() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$saved_settings         = $this->maybe_save_settings();
		$enabled_integrations   = \Hizzle\Recaptcha\Integrations\Main::get_enabled_integrations();
		$available_integrations = wp_list_pluck( \Hizzle\Recaptcha\Integrations\Main::get_available_integrations(), 'name' );
		$settings               = apply_filters(
			'hizzle_recaptcha_settings',
			array(
				'hide_logged_in' => array(
					'type'    => 'checkbox',
					'label'   => __( 'Hide from logged in users', 'hizzle-recaptcha' ),
					'label2'  => __( 'If checked, logged in users will not see the reCAPTCHA checkbox', 'hizzle-recaptcha' ),
					'default' => '',
				),
			)
		);

		include plugin_dir_path( __FILE__ ) . 'settings.php';
	}

	/**
	 * Displays the settings menu.
	 *
	 * @since 1.0.0
	 */
	protected function maybe_save_settings() {

		if ( empty( $_POST['hizzle_recaptcha'] ) ) {
			return '';
		}

		if ( ! current_user_can( 'manage_options' ) || ! wp_verify_nonce( $_POST['hizzle-recaptcha'], 'hizzle-recaptcha' ) ) {
			return false;
		}

		return update_option( 'hizzle_recaptcha', wp_kses_post_deep( $_POST['hizzle_recaptcha'] ) );
	}

	/**
	 * Links to the settings page.
	 *
	 * @param array $actions
	 */
	public function link_to_settings( $actions ) {

		$actions[] = sprintf(
			'<a href="%s">%s</a>',
			esc_url( admin_url( 'admin.php?page=hizzle-recaptcha' ) ),
			__( 'Settings', 'hizzle-recaptcha' )
		);

		return $actions;
	}
}
