<?php

/**
 * Plugin Name: Hizzle CAPTCHA
 * Plugin URI: https://hizzlewp.com/recaptcha
 * Description: The ultimate WordPress and WooCommerce CAPTCHA plugin
 * Version: 2.0.0
 * Author: Hizzle
 * Author URI: https://hizzlewp.com/
 * Text Domain: hizzle-recaptcha
 * Domain Path: /languages/
 * Requires at least: 5.0
 * Requires PHP: 5.6
 *
 * @package Hizzle
 */
defined( 'ABSPATH' ) || exit;
if ( !defined( 'HIZZLE_CAPTCHA_PLUGIN_FILE' ) ) {
    define( 'HIZZLE_CAPTCHA_PLUGIN_FILE', __FILE__ );
}
if ( !defined( 'HIZZLE_CAPTCHA_PLUGIN_VERSION' ) ) {
    define( 'HIZZLE_CAPTCHA_PLUGIN_VERSION', '2.0.0' );
}
require_once __DIR__ . '/vendor/autoload.php';
if ( function_exists( 'hizzle_recaptcha_fs' ) ) {
    hizzle_recaptcha_fs()->set_basename( false, __FILE__ );
} else {
    /**
     * DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE
     * `function_exists` CALL ABOVE TO PROPERLY WORK.
     */
    if ( !function_exists( 'hizzle_recaptcha_fs' ) ) {
        // Create a helper function for easy SDK access.
        function hizzle_recaptcha_fs() {
            global $hizzle_recaptcha_fs;
            if ( !isset( $hizzle_recaptcha_fs ) ) {
                // Activate multisite network integration.
                if ( !defined( 'WP_FS__PRODUCT_17918_MULTISITE' ) ) {
                    define( 'WP_FS__PRODUCT_17918_MULTISITE', true );
                }
                // Include Freemius SDK.
                // SDK is auto-loaded through composer
                $hizzle_recaptcha_fs = fs_dynamic_init( array(
                    'id'              => '17918',
                    'slug'            => 'hizzle-recaptcha',
                    'type'            => 'plugin',
                    'public_key'      => 'pk_bf768dfb26f574ae33f5a4903c6b7',
                    'is_premium'      => false,
                    'premium_suffix'  => 'Premium',
                    'has_addons'      => false,
                    'has_paid_plans'  => true,
                    'has_affiliation' => 'selected',
                    'menu'            => array(
                        'slug'        => 'hizzle-recaptcha',
                        'contact'     => false,
                        'support'     => true,
                        'affiliation' => false,
                    ),
                    'is_live'         => true,
                ) );
            }
            return $hizzle_recaptcha_fs;
        }

        // Init Freemius.
        hizzle_recaptcha_fs();
        // Signal that SDK was initiated.
        do_action( 'hizzle_recaptcha_fs_loaded' );
    }
    /**
     * Loads the plugin textdomain.
     */
    function hizzle_recaptcha_load_plugin_textdomain() {
        load_plugin_textdomain( 'hizzle-recaptcha', false, trailingslashit( dirname( plugin_basename( HIZZLE_CAPTCHA_PLUGIN_FILE ) ) ) . 'languages/' );
    }

    add_action( 'plugins_loaded', 'hizzle_recaptcha_load_plugin_textdomain' );
    /**
     * Retrieves an option value.
     *
     * @param string $key Option key to retrieve.
     * @param mixed $default_value The default value.
     * @return mixed
     */
    function hizzle_recaptcha_get_option(  $key, $default_value = null  ) {
        $options = get_option( 'hizzle_recaptcha' );
        if ( empty( $options ) ) {
            $options = array();
        }
        return ( isset( $options[$key] ) ? $options[$key] : $default_value );
    }

    // Init the main plugin class.
    \Hizzle\Recaptcha\Main::instance();
    // Init the premium plugin if available.
    if ( class_exists( '\\Hizzle\\Recaptcha\\Premium\\Main' ) ) {
        \Hizzle\Recaptcha\Premium\Main::init();
    }
}