/*!
 * File: gbcharts-data-tables.js
 * Description: Initializes and customizes DataTables for displaying historical Goldback data.
 * Author: Ideal Managed Solutions, LLC
 * License: GPLv2 or later
 * Plugin: Historical Charts for Goldback
 * Version: 1.0.0
 */
jQuery(document).ready(function ($) {
    // Initialize each DataTable instance and attach page change scroll behavior
    $('.gbcharts-data-table').each(function () {
        var $table = $(this);
        var dt = $table.DataTable({
            pageLength: 20,
            lengthMenu: [[20, 50, 100, 365], [20, 50, 100, 365]],
            searching: false,
            ordering: true,
            order: [[0, 'desc']],
            pagingType: 'simple_numbers',
            info: true
        });

        // On page change, scroll to the top of this table
        dt.on('page.dt', function () {
            var offset = $table.offset().top;
            window.scrollTo({ top: offset, behavior: 'smooth' });
        });
    });
});