<?php
/**
 * Fired when the plugin is uninstalled.
 *
 */

// If uninstall not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Define plugin directory constant if not already defined
if ( ! defined( 'HPSP_PLUGIN_DIR' ) ) {
    define( 'HPSP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

// Load the autoloader
require_once HPSP_PLUGIN_DIR . 'autoloader.php';
Highpots\SpamProtection\HPSP_Autoloader::register();

// Run the uninstall
Highpots\SpamProtection\HPSP_Uninstaller::uninstall();