<?php

namespace Highpots\SpamProtection\Integrations;

use Highpots\SpamProtection\Helpers\HPSP_Utils;
use Highpots\SpamProtection\Helpers\HPSP_Constants;

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class HPSP_WP_Forms extends HPSP_Form_Integration
{
    public function __construct()
    {
        parent::__construct('wpforms');
    }

    public function should_activate(): bool
    {
        return HPSP_Utils::is_plugin_active('wpforms');
    }

    public function is_enabled(): bool
    {
        return HPSP_Constants::get_enable_wpforms_integration_option();
    }

    public function init(): void
    {
        if (!$this->should_activate() || !$this->is_enabled()) {
            return;
        }

        // Inject fields via native hook
        add_action('wpforms_display_submit_before', [$this, 'inject_fields'], 10, 1);

        // Hook into WPForms validation process
        add_action('wpforms_process', [$this, 'validate_ajax_submission'], 50, 3);
    }

    /**
     * Inject spam protection fields into WPForms
     */
    public function inject_fields(array $form_data): void
    {
        // Prevent double injection using static variable
        static $processed_forms = [];
        $form_id_key = 'wpforms_' . $form_data['id'];

        if (isset($processed_forms[$form_id_key])) {
            return;
        }

        $form_id = $this->generate_form_id($form_data, 'wpforms');

        // Use wrapper-less rendering for WPForms to avoid CSS layout issues
        // WPForms uses flexbox/grid that breaks with extra wrapper divs
        $fields_html = $this->field_renderer->render_as_html($form_id);

        // Output fields directly (echo, not return)
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Sanitized with wp_kses() in HPSP_Utils::sanitize_spam_field_html()
        echo $this->sanitize_field_html($fields_html);

        // Mark this form as processed
        $processed_forms[$form_id_key] = true;
    }

    /**
     * Validate WPForms AJAX submission
     */
    public function validate_ajax_submission($fields, $entry, $form_data): void
    {
        $validation_result = $this->handle_validation();

        if (!$validation_result['success']) {
            // Add defensive check for form ID
            if (isset($form_data['id']) && !empty($form_data['id'])) {
                wpforms()->process->errors[$form_data['id']]['footer'] = $validation_result['message'];
            }
        }
    }
}
