<?php
namespace Highpots\SpamProtection\Integrations;

use DOMDocument;
use Highpots\SpamProtection\HPSP_Form_Field_Extractor;
use Highpots\SpamProtection\HPSP_Validator;

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class HPSP_Form_Integration_Manager {
   
    private array $integrations = [];
    private static ?self $instance = null;

    private function __construct() {
        $this->register_integrations();
        $this->init_integrations();
    }

    /**
     * Get singleton instance
     */
    public static function get_instance(): self {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Register all available integrations
     */
    private function register_integrations(): void {
        $this->integrations = [
            new HPSP_Contact_Form7(),
            new HPSP_WP_Forms(),
            new HPSP_Elementor_Form(),
            new HPSP_Gravity_Forms(),
            new HPSP_Formidable(),

            
            new HPSP_Generic_Form(), // Always last as fallback
        ];
    }

    /**
     * Initialize active integrations
     */
    private function init_integrations(): void {
        foreach ($this->integrations as $integration) {
            if ($integration->should_activate()) {
                $integration->init();
                // Integration activated and initialized
            }
        }
    }

    /**
     * Get all integrations
     */
    public function get_integrations(): array {
        return $this->integrations;
    }

    /**
     * Get active integrations
     */
    public function get_active_integrations(): array {
        return array_filter($this->integrations, fn($integration) => $integration->should_activate());
    }

    /**
     * Add custom integration
     */
    public function add_integration(HPSP_Form_Integration $integration): void {
        $this->integrations[] = $integration;
        
        if ($integration->should_activate()) {
            $integration->init();
        }
    }
}