<?php

namespace Highpots\SpamProtection\Helpers;

if (! defined('ABSPATH')) {
    exit;
}
class HPSP_Constants
{


    public const PLUGIN_NAME = 'Highpots Spam Protection';
    public const DB_VERSION = '1.0';
    public const MIN_PHP_VERSION = '7.4';
    public const MIN_WP_VERSION = '5.8';

    public const WP_OPTION_PREFIX = '_hpsp_';

    // Security salt option keys
    public const HMAC_SECRET_OPTION_KEY = '_hpsp_hmac_secret';
    public const HONEYPOT_SALT_OPTION_KEY = '_hpsp_honeypot_salt';

    // Transient prefixes
    public const TRANSIENT_PREFIX = '_hpsp_';
    public const HMAC_NONCE_TRANSIENT_PREFIX = '_hpsp_hmac_nonce_';
    public const RATE_LIMIT_TRANSIENT_PREFIX = '_hpsp_rate_limit_';

    // Admin notice options
    public const INSTALLATION_NOTICE_DISMISSED = '_hpsp_installation_notice_dismissed';


    public const ENABLE_LOGGING = true;
    public const LOG_RETENTION_DAYS = 30;
    public const MASK_IP_IN_LOGS = true;
    public const DEFAULT_MIN_TIME_IN_SECONDS = 3; // seconds
    public const DEFAULT_MAX_TIME_IN_SECONDS = 1800; // seconds (30 minutes)
    public const TOKEN_GRACE_PERIOD_IN_SECONDS = 30;
    public const ENABLE_RATE_LIMITING = true;
    public const RATE_LIMIT_WINDOW_IN_SECONDS = 60; // seconds (1 minute)
    public const RATE_LIMIT_MAX_ATTEMPTS = 5; // max attempts per IP per window
    public const ENABLE_USER_AGENT_VALIDATION = true;
    public const ENABLE_REFERRER_VALIDATION = false;

    // Form integration toggles
    public const ENABLE_CF7_INTEGRATION = true;
    public const ENABLE_GRAVITY_FORMS_INTEGRATION = true;
    public const ENABLE_WPFORMS_INTEGRATION = true;
    public const ENABLE_ELEMENTOR_INTEGRATION = true;
    public const ENABLE_FORMIDABLE_INTEGRATION = true;
    public const ENABLE_GENERIC_INTEGRATION = false;


    /**
     * Get the logs table name with WordPress prefix
     * 
     * @return string
     */
    public static function get_logs_table_name()
    {
        global $wpdb;
        return $wpdb->prefix . 'hpsp_logs';
    }


    public static function get_defaults(): array
    {
        return [
            self::get_min_time_id() => self::DEFAULT_MIN_TIME_IN_SECONDS,
            self::get_max_time_id() => self::DEFAULT_MAX_TIME_IN_SECONDS,
            self::get_token_grace_period_id() => self::TOKEN_GRACE_PERIOD_IN_SECONDS,
            self::get_enable_rate_limiting_id() => self::ENABLE_RATE_LIMITING,
            self::get_rate_limit_window_id() => self::RATE_LIMIT_WINDOW_IN_SECONDS,
            self::get_rate_limit_max_id() => self::RATE_LIMIT_MAX_ATTEMPTS,
            self::get_blocked_writing_systems_id() => [],
            self::get_enable_logging_id() => self::ENABLE_LOGGING,
            self::get_log_retention_days_id() => self::LOG_RETENTION_DAYS,
            self::get_mask_ip_in_logs_id() => self::MASK_IP_IN_LOGS,
            self::get_enable_user_agent_validation_id() => self::ENABLE_USER_AGENT_VALIDATION,
            self::get_enable_referrer_validation_id() => self::ENABLE_REFERRER_VALIDATION,
            self::get_enable_cf7_integration_id() => self::ENABLE_CF7_INTEGRATION,
            self::get_enable_gravity_forms_integration_id() => self::ENABLE_GRAVITY_FORMS_INTEGRATION,
            self::get_enable_wpforms_integration_id() => self::ENABLE_WPFORMS_INTEGRATION,
            self::get_enable_elementor_integration_id() => self::ENABLE_ELEMENTOR_INTEGRATION,
            self::get_enable_formidable_integration_id() => self::ENABLE_FORMIDABLE_INTEGRATION,
            self::get_enable_generic_integration_id() => self::ENABLE_GENERIC_INTEGRATION,
        ];
    }


    public static function get_min_time_id(): string
    {
        return self::WP_OPTION_PREFIX . 'min_time';
    }

    public static function get_max_time_id(): string
    {
        return self::WP_OPTION_PREFIX . 'max_time';
    }


    public static function get_token_grace_period_id(): string
    {
        return self::WP_OPTION_PREFIX . 'token_grace_period';
    }

    public static function get_rate_limit_window_id(): string
    {
        return self::WP_OPTION_PREFIX . 'rate_limit_window';
    }



    public static function get_rate_limit_max_id(): string
    {
        return self::WP_OPTION_PREFIX . 'rate_limit_max';
    }



    public static function get_blocked_writing_systems_id(): string
    {
        return self::WP_OPTION_PREFIX . 'blocked_writing_systems';
    }


    public static function get_enable_logging_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_logging';
    }

    public static function get_log_retention_days_id(): string
    {
        return self::WP_OPTION_PREFIX . 'log_retention_days';
    }

    public static function get_mask_ip_in_logs_id(): string
    {
        return self::WP_OPTION_PREFIX . 'mask_ip_in_logs';
    }

    public static function get_enable_user_agent_validation_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_user_agent_validation';
    }

    public static function get_enable_referrer_validation_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_referrer_validation';
    }

    public static function get_enable_rate_limiting_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_rate_limiting';
    }

    public static function get_enable_cf7_integration_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_cf7_integration';
    }

    public static function get_enable_gravity_forms_integration_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_gravity_forms_integration';
    }

    public static function get_enable_wpforms_integration_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_wpforms_integration';
    }

    public static function get_enable_elementor_integration_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_elementor_integration';
    }

    public static function get_enable_formidable_integration_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_formidable_integration';
    }

    public static function get_enable_generic_integration_id(): string
    {
        return self::WP_OPTION_PREFIX . 'enable_generic_integration';
    }


    // Option value getters with validation
    public static function get_min_time_option(): int
    {
        $min_time = get_option(self::get_min_time_id(), self::DEFAULT_MIN_TIME_IN_SECONDS);
        return max(1, absint($min_time));
    }

    public static function get_max_time_option(): int
    {
        $max_time = get_option(self::get_max_time_id(), self::DEFAULT_MAX_TIME_IN_SECONDS);
        return max(1, absint($max_time));
    }


    public static function get_token_grace_period_option(): int
    {
        $max_time = get_option(self::get_token_grace_period_id(), self::TOKEN_GRACE_PERIOD_IN_SECONDS);
        return max(1, absint($max_time));
    }

    public static function get_rate_limit_window_option(): int
    {
        $value = get_option(self::get_rate_limit_window_id(), self::RATE_LIMIT_WINDOW_IN_SECONDS);
        return max(1, absint($value));
    }

    public static function get_rate_limit_max_option(): int
    {
        $value = get_option(self::get_rate_limit_max_id(), self::RATE_LIMIT_MAX_ATTEMPTS);
        return max(1, absint($value));
    }

    public static function get_blocked_writing_systems_option(): array
    {
        $value = get_option(self::get_blocked_writing_systems_id(), []);
        return is_array($value) ? $value : [];
    }

    public static function get_enable_logging_option(): bool
    {
        $value = get_option(self::get_enable_logging_id(), self::ENABLE_LOGGING);
        return (bool) $value;
    }

    public static function get_log_retention_days_option(): int
    {
        $value = get_option(self::get_log_retention_days_id(), self::LOG_RETENTION_DAYS);
        return max(1, absint($value));
    }

    public static function get_mask_ip_in_logs_option(): bool
    {
        $value = get_option(self::get_mask_ip_in_logs_id(), self::MASK_IP_IN_LOGS);
        return (bool) $value;
    }

    public static function get_enable_user_agent_validation_option(): bool
    {
        $value = get_option(self::get_enable_user_agent_validation_id(), self::ENABLE_USER_AGENT_VALIDATION);
        return (bool) $value;
    }

    public static function get_enable_referrer_validation_option(): bool
    {
        $value = get_option(self::get_enable_referrer_validation_id(), self::ENABLE_REFERRER_VALIDATION);
        return (bool) $value;
    }

    public static function get_enable_rate_limiting_option(): bool
    {
        $value = get_option(self::get_enable_rate_limiting_id(), self::ENABLE_RATE_LIMITING);
        return (bool) $value;
    }

    public static function get_enable_cf7_integration_option(): bool
    {
        $value = get_option(self::get_enable_cf7_integration_id(), self::ENABLE_CF7_INTEGRATION);
        return (bool) $value;
    }

    public static function get_enable_gravity_forms_integration_option(): bool
    {
        $value = get_option(self::get_enable_gravity_forms_integration_id(), self::ENABLE_GRAVITY_FORMS_INTEGRATION);
        return (bool) $value;
    }

    public static function get_enable_wpforms_integration_option(): bool
    {
        $value = get_option(self::get_enable_wpforms_integration_id(), self::ENABLE_WPFORMS_INTEGRATION);
        return (bool) $value;
    }

    public static function get_enable_elementor_integration_option(): bool
    {
        $value = get_option(self::get_enable_elementor_integration_id(), self::ENABLE_ELEMENTOR_INTEGRATION);
        return (bool) $value;
    }

    public static function get_enable_formidable_integration_option(): bool
    {
        $value = get_option(self::get_enable_formidable_integration_id(), self::ENABLE_FORMIDABLE_INTEGRATION);
        return (bool) $value;
    }

    public static function get_enable_generic_integration_option(): bool
    {
        $value = get_option(self::get_enable_generic_integration_id(), self::ENABLE_GENERIC_INTEGRATION);
        return (bool) $value;
    }
}
