<?php

namespace Highpots\SpamProtection;

use Highpots\SpamProtection\Admin\HPSP_Settings;
use Highpots\SpamProtection\Helpers\HPSP_Constants;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class HPSP_Scheduler {
    
    const HOOK_NAME = 'hpsp_daily_cleanup';



      public static function init(): void {
        add_action(self::HOOK_NAME, [self::class, 'run_cleanup']);
        
        // Listen for settings changes
        add_action('hpsp_logging_setting_changed', [self::class, 'handle_logging_change']);
    }

     public static function handle_logging_change(bool $logging_enabled): void {

        if ( $logging_enabled ) {
            self::enable_schedule();
        } else {
            self::disable_schedule();
        }
    }

    

    /**
     * Activate scheduler on plugin activation
     */
    public static function activate(): void {
        // Check settings to decide if schedule should be enabled
        $logging_enabled = HPSP_Constants::get_enable_logging_option();
        
        if ($logging_enabled) {
           self::enable_schedule();
        }
    }


     /**
     * Deactivate scheduler on plugin deactivation
     */
    public static function deactivate(): void {
        self::disable_schedule();
    }


     private static function enable_schedule(): void {
        if (!wp_next_scheduled(self::HOOK_NAME)) {
            wp_schedule_event(time(), 'daily', self::HOOK_NAME);
        }
    }
    
    private static function disable_schedule(): void {
        if (wp_next_scheduled(self::HOOK_NAME)) {
            wp_clear_scheduled_hook(self::HOOK_NAME);
        }
    }
    
    /**
     * Run cleanup with setting checks
     */
    public static function run_cleanup(): void {
        
        // Double-check logging is still enabled
        if (!HPSP_Constants::get_enable_logging_option()) {
            return;
        }
        
        $retention_days = HPSP_Constants::get_log_retention_days_option();
        
        // Don't clean up if retention is effectively "forever"
        if ($retention_days >= 365) {
            return;
        }
        
        $logger = new HPSP_Logger();
        $deleted = $logger->cleanup_old_logs();
        // Log cleanup completed - $deleted records removed
    }
    

    
  
}