<?php
namespace Highpots\SpamProtection\Admin;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Represents a section of settings in the plugin settings page.
 *
 * Settings are organized into sections (e.g., Timing Settings, Rate Limiting)
 * with each section containing multiple setting fields.
 *
 * @package Highpots\SpamProtection\Admin
 */
class HPSP_Setting_Section {

    /** @var string Unique identifier for this section */
    public string $id;

    /** @var string Display title for the section */
    public string $title;

    /** @var string Description text displayed below the section title */
    public string $description;

    /** @var string Tooltip text displayed on hover for section title (optional) */
    public string $title_help_text;

    /** @var string Tooltip text displayed on hover for section description (optional) */
    public string $desc_help_text;

    /** @var array<string, HPSP_Setting_Field> Array of setting fields in this section, keyed by field ID */
    public array $fields;

    /**
     * Constructor for setting section.
     *
     * @param string $id Unique identifier for this section
     * @param string $title Display title for the section
     * @param string $description Description text displayed below the section title
     * @param array $fields Array of HPSP_Setting_Field objects to initialize the section with
     * @param string $title_help_text Tooltip text displayed on hover for section title (optional)
     * @param string $desc_help_text Tooltip text displayed on hover for section description (optional)
     */
    public function __construct(string $id, string $title, string $description = '', array $fields = [], string $title_help_text = '', string $desc_help_text = '') {
        $this->id = $id;
        $this->title = $title;
        $this->description = $description;
        $this->fields = $fields;
        $this->title_help_text = $title_help_text;
        $this->desc_help_text = $desc_help_text;
    }

    /**
     * Add a setting field to this section.
     *
     * @param HPSP_Setting_Field $field The setting field to add
     * @return void
     */
    public function add_field(HPSP_Setting_Field $field): void {
        $this->fields[$field->id] = $field;
    }
}