<?php

use Highpots\SpamProtection\HPSP_Scheduler;

/**
 * Plugin Name: HighPots Spam Protection
 * Plugin URI: https://highpots.com/wordpress-plugins/anti-spam-protection/
 * Description: Lightweight, GDPR-compliant spam protection for WordPress forms.
 * Version: 1.1.0
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * Author: HighPots GmbH
 * Author URI: https://www.highpots.com/
 * Text Domain: highpots-spam-protection
 * Domain Path: /languages
 * License: GPLv2
 * License URI: https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */


// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Define constants for plugin directory and URL
define( 'HPSP_PLUGIN_NAME', 'highpots-spam-protection' );
define( 'HPSP_PLUGIN_DISPLAY_NAME', 'HighPots Spam Protection' );
define( 'HPSP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'HPSP_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
define( 'HPSP_PLUGIN_LANG_DIR', dirname(plugin_basename( __FILE__ )) . '/languages' );
define( 'HPSP_PLUGIN_VERSION', '1.1.0' );
define( 'HPSP_PLUGIN_BASENAME', plugin_basename(__FILE__));



require_once HPSP_PLUGIN_DIR . 'autoloader.php';
\Highpots\SpamProtection\HPSP_Autoloader::register();



function hpsp_plugin_activate() {
    Highpots\SpamProtection\HPSP_Activator::activate();
}

function hpsp_plugin_deactivate() {
    HPSP_Scheduler::deactivate();
}


// Activation and Deactivation Hooks
register_activation_hook( __FILE__, 'hpsp_plugin_activate' );
register_deactivation_hook( __FILE__, 'hpsp_plugin_deactivate' );



\Highpots\SpamProtection\HPSP_Plugin::get_instance();