jQuery(document).ready(function($) {
        
    
    // For settings page
     $('.input-with-clear .clear-input').on('click', function() {
        const input = $(this).siblings('input');
        const defaultValue = input.data('default');
        input.val(defaultValue);
    });

 
    
    // Handle custom date range
    $('#time_range').on('change', function() {
        const isCustom = $(this).val() === 'custom';


        if (isCustom) {
            $('#custom_date_range').slideDown(200);
        } else {
            $('#custom_date_range').slideUp(200);
        }


        $('#from_date, #to_date').prop('required', isCustom);

        if (!isCustom) {
            $('#from_date, #to_date').val('');
        }

    }).trigger('change');

    // Handle detailed view checkbox - show/hide log type filter
    $('#detailed').on('change', function() {
        const isDetailed = $(this).is(':checked');

        if (isDetailed) {
            $('#log-type-filter').slideDown(200);
        } else {
            $('#log-type-filter').slideUp(200);
            $('#reason').val(''); // Reset filter when hiding
        }
    }).trigger('change');

    // Validate form
    function validateForm() {
        const time_range = $('#time_range').val();
        const from_date_input = $('#from_date');
        const to_date_input = $('#to_date');
        
        if (time_range === 'custom') {
            // Enable HTML5 validation
            from_date_input.prop('required', true);
            to_date_input.prop('required', true);
            
            // Check validity
            if (!from_date_input[0].checkValidity() || !to_date_input[0].checkValidity()) {
                // Trigger native browser validation UI
                if (!from_date_input[0].checkValidity()) {
                    from_date_input[0].reportValidity();
                } else {
                    to_date_input[0].reportValidity();
                }
                return false;
            }
        } else {
            // Disable required for other ranges
            from_date_input.prop('required', false);
            to_date_input.prop('required', false);
        }
        
        return true;
    }



    //=========================================
    function submitSpamLogFilterForm(page = 1, extraParams = null) {

       // Validate custom date range if selected
        if (!validateForm()) {
            return false;
        }



        // Collect form data

        let formData = $('#spam-log-filter-form').serializeArray(); // Get form data as an array of objects

        let params = {
            action: 'hpsp_get_spam_log_data',
            hpsp_filter_logs_nonce: hpsp_vars.hpsp_filter_logs_nonce,
            paged: page
        };

        // Convert formData array to a plain object
        let formObject = {};
        $.each(formData, function(i, field) {
            formObject[field.name] = field.value;
        });

        // Merge the form data object with the other parameters
        let data = $.param($.extend({}, formObject, params, (typeof extraParams === 'object' && extraParams !== null) ? extraParams : {}));


        // Show loading indicator
        $('#hpsp-loading').show();
        // Perform AJAX request
        $.ajax({
            url: hpsp_vars.ajaxurl,
            type: 'POST',
            data: data,
            dataType: 'json', // Expect JSON response
            beforeSend: function() {
                // Optional: Disable the submit button while loading
                $('#hpsp-apply-filters').prop('disabled', true);
               // $('#spam-log-table-container').html('<div class="loading-indicator">Loading...</div>');
            },
            success: function(response) {
                if (response.success) {
                    // Update table content
                    $('#spam-log-table-container').html(response.data.html);

                    // Optional: Handle pagination (if your response includes pagination data)
                    if (response.data.pagination) {
                       // $('#spam-log-table-container').after(response.data.pagination); // Add pagination controls
                    }
                } else {
                    // Display error message
                    $('#spam-log-table-container').html('<div class="error-message">' + response.data + '</div>');
                    console.error('AJAX Error:', response.data); // Log error to console
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                // Handle AJAX errors (network issues, server errors, etc.)
                $('#spam-log-table-container').html('<div class="error-message">' + hpsp_vars.i18n.export_error_generic + '</div>');
                console.error('AJAX Error:', textStatus, errorThrown);
            },
            complete: function() {
                // Re-enable the submit button
                $('#hpsp-apply-filters').prop('disabled', false);
                $('#hpsp-loading').hide();
            }
        });
    }


      $(document).on('click', '.wp-list-table th.sortable a, .wp-list-table th.sorted a', function(e) {
        
            e.preventDefault();

            const url = $(this).attr('href');
            const urlParams = new URLSearchParams(url.split('?')[1]);
            const orderby = urlParams.get('orderby') || '';
            const order = urlParams.get('order') || 'desc';

            const extraParams = {
                orderby,
                order
            }



            submitSpamLogFilterForm(1, extraParams);
      });



    // Form submission event handler
    $('#spam-log-filter-form').submit(function(event) {
        event.preventDefault(); // Prevent default form submission
        submitSpamLogFilterForm(); // Submit the form via AJAX
    });

    

    // Pagination
    $(document).on('click', '.tablenav-pages a', function(event) {
        event.preventDefault();
        const href = $(this).attr('href'); // Get the href attribute
        if (href) { // Check if href exists
            let page = 1;
            const match = href.match(/paged=(\d+)/);
            if (match !== null && match.length > 1) { // Check if match is not null and has the expected group
                page = match[1];
            } 
            
            submitSpamLogFilterForm(page);
            console.log('HREF: ', href);
        } else {
            console.error("Href attribute is missing.");
        }
    });



// Export CSV with explicit checkbox handling
$('#hpsp-export2csv-btn').on('click', function(event) {
    event.preventDefault();

    // Validate custom date range if selected
    if (!validateForm()) {
        return false;
    }

    console.log('=== Export CSV Started ===');

    const $button = $(this);
    const originalHtml = $button.html();

    // Get all form fields from the original form
    const originalForm = $('#spam-log-filter-form');

    // Prepare data
    const exportData = {
        action: 'hpsp_export_spam_log_csv',
        hpsp_export_csv_nonce: hpsp_vars.hpsp_export_csv_nonce,
        time_range: originalForm.find('[name="time_range"]').val(),
        from_date: originalForm.find('[name="from_date"]').val(),
        to_date: originalForm.find('[name="to_date"]').val(),
        reason: originalForm.find('[name="reason"]').val()
    };

    // Add detailed checkbox - EXPLICIT CHECK
    const detailedCheckbox = originalForm.find('input[name="detailed"]');
    if (detailedCheckbox.length > 0 && detailedCheckbox.is(':checked')) {
        exportData.detailed = '1';
        console.log('detailed: 1 (checkbox is checked)');
    }

    // Disable button and show loading state
    $button.prop('disabled', true).addClass('loading');
    $button.html('<span>' + hpsp_vars.i18n.exporting + '</span>');

    // First, check if there's data via AJAX
    $.ajax({
        url: hpsp_vars.ajaxurl,
        type: 'POST',
        data: $.extend({}, exportData, { check_only: true }),
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                // Data exists, proceed with form submission for download
                const form = $('<form>', {
                    method: 'POST',
                    action: hpsp_vars.ajaxurl
                });

                // Add all fields
                $.each(exportData, function(key, value) {
                    if (value) {
                        form.append($('<input>', {
                            type: 'hidden',
                            name: key,
                            value: value
                        }));
                    }
                });

                // Submit form for download
                form.appendTo('body').submit().remove();

                // Reset button after a short delay
                setTimeout(function() {
                    $button.prop('disabled', false).removeClass('loading');
                    $button.html(originalHtml);
                }, 1000);
            } else {
                // No data - show error notice
                showExportNotice(response.data.message || hpsp_vars.i18n.no_data_export, 'error');
                $button.prop('disabled', false).removeClass('loading');
                $button.html(originalHtml);
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            showExportNotice(hpsp_vars.i18n.export_error, 'error');
            console.error('Export Error:', textStatus, errorThrown);
            $button.prop('disabled', false).removeClass('loading');
            $button.html(originalHtml);
        }
    });
});

// Helper function to show export notices
function showExportNotice(message, type) {
    // Remove any existing export notices
    $('.hpsp-export-notice').remove();

    const noticeClass = type === 'error' ? 'notice-error' : 'notice-success';
    const notice = $('<div>', {
        class: 'notice hpsp-notice hpsp-export-notice ' + noticeClass + ' is-dismissible',
        html: '<p>' + message + '</p>' +
              '<button type="button" class="notice-dismiss">' +
              '<span class="screen-reader-text">' + hpsp_vars.i18n.dismiss_notice + '</span>' +
              '</button>'
    });

    // Insert notice before the filter form
    $('#spam-log-filter-form').before(notice);

    // Auto-dismiss after 5 seconds
    setTimeout(function() {
        notice.fadeOut(300, function() {
            $(this).remove();
        });
    }, 5000);
}



 // Form validation on settings page
    $('#hpsp-save-settings').on('click', function(e) {
        const minTime = parseInt($('#_hpsp_min_time').val());
        const maxTime = parseInt($('#_hpsp_max_time').val());

        if (minTime >= maxTime) {
            e.preventDefault();
            alert(hpsp_vars.error_messages.sett_min_max_error);
            return false;
        }
    });

    // Toggle rate limiting dependent fields
    function toggleRateLimitingFields() {
        const isEnabled = $('#_hpsp_enable_rate_limiting').is(':checked');
        const $rateLimitWindow = $('#_hpsp_rate_limit_window');
        const $rateLimitMax = $('#_hpsp_rate_limit_max');

        $rateLimitWindow.prop('disabled', !isEnabled);
        $rateLimitMax.prop('disabled', !isEnabled);

        if (!isEnabled) {
            $rateLimitWindow.closest('tr').addClass('hpsp-disabled-field');
            $rateLimitMax.closest('tr').addClass('hpsp-disabled-field');
        } else {
            $rateLimitWindow.closest('tr').removeClass('hpsp-disabled-field');
            $rateLimitMax.closest('tr').removeClass('hpsp-disabled-field');
        }
    }

    // Toggle logging dependent fields
    function toggleLoggingFields() {
        const isEnabled = $('#_hpsp_enable_logging').is(':checked');
        const $logRetention = $('#_hpsp_log_retention_days');

        $logRetention.prop('disabled', !isEnabled);

        if (!isEnabled) {
            $logRetention.closest('tr').addClass('hpsp-disabled-field');
        } else {
            $logRetention.closest('tr').removeClass('hpsp-disabled-field');
        }
    }

    // Initialize on page load
    toggleRateLimitingFields();
    toggleLoggingFields();

    // Toggle on checkbox change
    $('#_hpsp_enable_rate_limiting').on('change', toggleRateLimitingFields);
    $('#_hpsp_enable_logging').on('change', toggleLoggingFields);


});
