<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Register settings and add admin menu
 */
function htsk_register_settings() {
    register_setting('htsk_settings_group', 'htsk_options', 'htsk_sanitize_options');
}
add_action('admin_init', 'htsk_register_settings');

function htsk_sanitize_options($input) {
    $out = array();
    $out['enabled'] = isset($input['enabled']) ? (int) $input['enabled'] : 0;
    $out['text_color'] = isset($input['text_color']) ? sanitize_hex_color($input['text_color']) : '#000000';
    $out['bg_color'] = isset($input['bg_color']) ? sanitize_hex_color($input['bg_color']) : '#ffff00';
    return $out;
}

function htsk_add_admin_menu() {
    add_options_page(
        __('Highlight Search', 'highlight-search-keyword'),
        __('Highlight Search', 'highlight-search-keyword'),
        'manage_options',
        'htsk-settings',
        'htsk_render_settings_page'
    );
}
add_action('admin_menu', 'htsk_add_admin_menu');

function htsk_enqueue_admin_assets($hook) {
    if ($hook !== 'settings_page_htsk-settings') {
        return;
    }

    wp_enqueue_style('htsk-admin-style', plugin_dir_url(__FILE__) . 'admin/htsk-admin.css', array(), '1.0');
    wp_enqueue_script('htsk-admin-script', plugin_dir_url(__FILE__) . 'admin/htsk-admin.js', array('jquery'), '1.0', true);
    // WP color picker
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('wp-color-picker');
}
add_action('admin_enqueue_scripts', 'htsk_enqueue_admin_assets');

function htsk_render_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    $opts = wp_parse_args(get_option('htsk_options', array()), array(
        'enabled' => 1,
        'text_color' => '#000000',
        'bg_color' => '#ffff00',
    ));
    ?>
    <div class="wrap htsk-wrap">
        <h1><?php esc_html_e('Highlight Search Keyword', 'highlight-search-keyword'); ?></h1>
        <p><?php esc_html_e('Configure the settings for highlighting search keywords in your search results.', 'highlight-search-keyword'); ?></p>
        <div class="our-products">
            <p class="title">
                <?php esc_html_e('Check out our other products:', 'highlight-search-keyword'); ?>
            </p>
            <div class="products">
                <a href="https://gutslider.com" target="_blank" rel="noopener"><?php esc_html_e('GutSlider', 'highlight-search-keyword'); ?></a>
                <a href="https://accordion.gutenbergkits.com/" target="_blank" rel="noopener"><?php esc_html_e('Easy Accordion', 'highlight-search-keyword'); ?></a>
                <a href="https://gutenlayouts.com/" target="_blank" rel="noopener"><?php esc_html_e('GutenLayouts', 'highlight-search-keyword'); ?></a>
            </div>
        </div>
        <form method="post" action="options.php">
            <?php settings_fields('htsk_settings_group'); ?>
            <?php do_settings_sections('htsk_settings_group'); ?>

            <div class="htsk-card">
                <div class="htsk-row">
                    <label class="htsk-label"><?php esc_html_e('Enable Highlighting', 'highlight-search-keyword'); ?></label>
                    <div class="htsk-control">
                        <input type="hidden" name="htsk_options[enabled]" value="0">
                        <div class="htsk-toggle" data-for="htsk-enabled">
                            <input id="htsk-enabled" name="htsk_options[enabled]" type="checkbox" value="1" <?php checked(1, $opts['enabled']); ?> />
                            <span class="htsk-toggle-slider"></span>
                        </div>
                    </div>
                </div>

                <div class="htsk-row">
                    <label class="htsk-label"><?php esc_html_e('Highlight Text Color', 'highlight-search-keyword'); ?></label>
                    <div class="htsk-control">
                        <input class="htsk-color" type="text" name="htsk_options[text_color]" value="<?php echo esc_attr($opts['text_color']); ?>" />
                    </div>
                </div>

                <div class="htsk-row">
                    <label class="htsk-label"><?php esc_html_e('Highlight Background Color', 'highlight-search-keyword'); ?></label>
                    <div class="htsk-control">
                        <input class="htsk-color" type="text" name="htsk_options[bg_color]" value="<?php echo esc_attr($opts['bg_color']); ?>" />
                    </div>
                </div>

                <p class="description"><?php esc_html_e('Preview is below. Click Save Changes to persist.', 'highlight-search-keyword'); ?></p>

                <div class="htsk-preview">
                    <span class="htsk-preview-sample">This is a preview of the highlighted <span class="htsk-sample">keyword</span> in text.</span>
                </div>

                <p class="submit">
                    <button type="submit" class="button button-primary"><?php esc_html_e('Save Changes', 'highlight-search-keyword'); ?></button>
                </p>
            </div>
        </form>
    </div>

    <?php
}
