<?php
/**
 * Plugin Name: Highlight Search Keyword
 * Description: Highlights searched keywords in search results.
 * Version: 1.0.0
 * Requires at least: 5.6  
 * Requires PHP: 7.4
 * Author: Gkits
 * Author URI: https://gutenbergkits.com
 * Text Domain: highlight-search-keyword
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Include core functionality
require_once plugin_dir_path(__FILE__) . 'includes/highlight-functions.php';
require_once plugin_dir_path(__FILE__) . 'includes/settings.php';


// Load plugin textdomain for translations
function hsk_load_textdomain() {
    load_plugin_textdomain( 'highlight-search-keyword', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
}
add_action( 'plugins_loaded', 'hsk_load_textdomain' );

// safe redirect to settings page on plugin activation
function hsk_activate_plugin() {
    // Set a transient to trigger redirect on next admin page load
    set_transient( 'hsk_activation_redirect', true, 30 );
}
register_activation_hook( __FILE__, 'hsk_activate_plugin' );

// Handle the redirect after activation
function hsk_activation_redirect() {
    if ( get_transient( 'hsk_activation_redirect' ) ) {
        delete_transient( 'hsk_activation_redirect' );
        if ( current_user_can( 'manage_options' ) ) {
            wp_safe_redirect( esc_url( admin_url( 'admin.php?page=htsk-settings' ) ) );
            exit;
        }
    }
}
add_action( 'admin_init', 'hsk_activation_redirect' );