(function(){
    // Settings provided by PHP via wp_localize_script
    var S = window.ChatsAppWP_Settings || {};
    if (!S.phone) {
        return; // nothing to do
    }

    // Helper to build whatsapp link
    function buildWhatsAppUrl(text) {
        var base = S.is_mobile ? 'https://wa.me/' : 'https://web.whatsapp.com/send?phone=';
        var phone = encodeURIComponent(S.phone);
        var message = text ? text : (S.message || '');
        if (S.is_mobile) {
            return base + phone + (message ? '?text=' + message : '');
        } else {
            return base + phone + '&text=' + message;
        }
    }

    // Create container if not present (shortcode may have added it, but ensure fallback)
    var container = document.getElementById('chatsappwp-container');
    if (!container) {
        container = document.createElement('div');
        container.id = 'chatsappwp-container';
        container.className = 'chatsappwp-container chatsappwp-' + (S.position || 'right');
        document.body.appendChild(container);

        var btn = document.createElement('button');
        btn.id = 'chatsappwp-toggle';
        btn.className = 'chatsappwp-toggle';
        btn.setAttribute('aria-expanded','false');
        btn.innerHTML = '<span class=\"wp-wm-icon\">💬</span><span class=\"wp-wm-label\">' + (S.label || 'Let’s Chat') + '</span>';
        container.appendChild(btn);

        var popup = document.createElement('div');
        popup.id = 'chatsappwp-popup';
        popup.className = 'chatsappwp-popup';
        popup.setAttribute('role','dialog');
        popup.setAttribute('aria-hidden','true');
        popup.innerHTML = '<button id="chatsappwp-close" class="chatsappwp-close" aria-label="Close chat">&times;</button>' +
            '<div class="chatsappwp-content">' +
            '<div class="chatsappwp-greeting">'+ (S.greeting || 'Hi!') +'</div>' +
            '<div class="chatsappwp-sub">Write a message and we will reply as soon as possible.</div>' +
            '<div class="chatsappwp-inputs">' +
            '<textarea id="chatsappwp-user-msg" class="chatsappwp-user-msg" rows="3" placeholder="Type your message here..."></textarea>' +
            '<div class="chatsappwp-actions">' +
            '<button id="chatsappwp-send" class="chatsappwp-send">Send &#10148;</button>' +
            '</div>' +
            '</div>' +
            '</div>';
        container.appendChild(popup);
    }

    var toggle = document.getElementById('chatsappwp-toggle');
    var popup = document.getElementById('chatsappwp-popup');
    var closeBtn = document.getElementById('chatsappwp-close');
    var openBtn = document.getElementById('chatsappwp-send');
    var userMsg = document.getElementById('chatsappwp-user-msg');

    // set greeting text if present in settings
    var greetingEl = container.querySelector('.wp-wm-greeting');
    if (greetingEl && S.greeting) greetingEl.textContent = S.greeting;

    // Toggle functions
    function openPopup() {
        container.classList.add('open');
        container.classList.remove('showing');
        toggle.setAttribute('aria-expanded','true');
        popup.setAttribute('aria-hidden','false');
        if (userMsg) userMsg.focus();
    }
    function closePopup() {
        container.classList.remove('open');
        toggle.setAttribute('aria-expanded','false');
        popup.setAttribute('aria-hidden','true');
    }

    // Toggle click
    if (toggle) {
        toggle.addEventListener('click', function(e){
            if (container.classList.contains('open')) {
                closePopup();
            } else {
                openPopup();
            }
        });
    }

    // Close button
    if (closeBtn) {
        closeBtn.addEventListener('click', function(){
            closePopup();
            localStorage.setItem(storageKey, '1'); // prevent future auto popups
        });
    }

    // Close on ESC
    document.addEventListener('keydown', function(e){
        if (e.key === 'Escape' || e.keyCode === 27) {
            closePopup();
        }
    });

    // Close if click outside popup (but not on the toggle)
    document.addEventListener('click', function(e){
        if (!container.contains(e.target) && container.classList.contains('open')) {
            closePopup();
            localStorage.setItem(storageKey, '1');
        }
    });

    // Auto popup after configured seconds (only once per page load)
    var delay = parseInt(S.autopopup || 0, 10);
    var storageKey = 'chatsappwp-closed';
    if (delay > 0 && !localStorage.getItem(storageKey)) {
        container.classList.add('showing');
        setTimeout(function(){
            openPopup();
        }, delay * 1000);
    }

    // Send button behavior: combine greeting + user message + default message (admin configured)
    if (openBtn) {
        openBtn.addEventListener('click', function(e){
            e.preventDefault();
            var parts = [];
           // if (S.greeting) parts.push(S.greeting);
            var typed = userMsg ? userMsg.value.trim() : '';
            if (typed) parts.push(typed);
            //if (S.message) parts.push(S.message);
            var combined = parts.join('\\n');
            // URL encode
            var url = buildWhatsAppUrl(encodeURIComponent(combined));
            // Open in new tab
            window.open(url, '_blank', 'noopener');
        });
    }

    // small accessibility tweak: trap focus inside popup while open
    document.addEventListener('focus', function(event){
        if (!container.classList.contains('open')) return;
        if (!container.contains(event.target)) {
            event.stopPropagation();
            if (userMsg) userMsg.focus();
        }
    }, true);

})();