import { createRoot } from "react-dom/client";
import "./style.scss";
import Style from "./Components/Common/Style";
import HeroSection from "./Components/Common/HeroSection";

document.addEventListener("DOMContentLoaded", () => {
  const blockNameEls = document.querySelectorAll(
    ".wp-block-hero-section-hero-section"
  );
  blockNameEls.forEach((blockNameEl) => {
    const attributes = JSON.parse(blockNameEl.dataset.attributes);

    createRoot(blockNameEl).render(
      <>
        <Style attributes={attributes} id={blockNameEl.id} />

        <HeroSection attributes={attributes}/>
      </>
    );

    blockNameEl?.removeAttribute("data-attributes");
  });
});
