
import { __ } from "@wordpress/i18n";
import {
  PanelBody,
  ColorPicker,
} from "@wordpress/components";


const Style = ({ attributes, setAttributes }) => {
  const {styles } = attributes || {};
  const {title,des,btn}=styles ||{}


  return (
    <>
      <PanelBody
        className="bPlPanelBody"
        title={__("Hero section Content", "hero-section")}
        initialOpen={false}
      >
        <div style={{marginBottom:"15px"}}>{__("Title Color","hero-section")}</div>
     <ColorPicker  value={title} onChange={(v=>setAttributes({styles:{...styles,title:v}}))} />

     <div style={{marginBottom:"15px"}}>{__("Description Color","hero-section")}</div>
     <ColorPicker  value={des} onChange={(v=>setAttributes({styles:{...styles,des:v}}))} />
        
         <div style={{marginBottom:"15px"}}>{__("Button Color","hero-section")}</div>
     <ColorPicker  value={btn?.color}onChange={(v=>setAttributes({styles:{...styles,btn:{...btn,color:v}}}))} />

        <div style={{marginBottom:"15px"}}>{__("Button Background","hero-section")}</div>
     <ColorPicker  value={btn?.bg}onChange={(v=>setAttributes({styles:{...styles,btn:{...btn,bg:v}}}))} />
       
      </PanelBody>
    </>
  );
};

export default Style;
