import Layout from '../layout/Layout';

const endpoints = [
    {
        method: 'POST',
        path: '/headlesskey/v1/token',
        title: 'Create Token',
        description: 'Exchange username/password for a JWT token.',
        body: { username: 'user', password: 'pass' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/token/validate',
        title: 'Validate Token',
        description: 'Confirm signature and expiration.',
        body: { token: 'JWT_TOKEN' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/token/refresh',
        title: 'Refresh Token',
        description: 'Return a new token without credentials.',
        body: { token: 'JWT_TOKEN' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/token/revoke',
        title: 'Revoke Token',
        description: 'Logout or force logout sessions.',
        body: { token: 'JWT_TOKEN' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/register',
        title: 'Register',
        description: 'Create a user account.',
        body: { username: 'newuser', email: 'user@example.com', password: 'pass123', name: 'Name' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/login',
        title: 'Login',
        description: 'One-click alias that returns token + profile.',
        body: { username: 'user', password: 'pass' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/forgot-password',
        title: 'Forgot Password',
        description: 'Send reset link or OTP (delivery: link|otp).',
        body: { login: 'user@example.com', delivery: 'otp' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/reset-password',
        title: 'Reset Password',
        description: 'Complete the reset flow with token or OTP.',
        body: { login: 'user@example.com', password: 'newpass', token: 'RESET_KEY' },
    },
    {
        method: 'POST',
        path: '/headlesskey/v1/change-password',
        title: 'Change Password',
        description: 'Authenticated users can update their password.',
        headers: { Authorization: 'Bearer TOKEN' },
        body: { current_password: 'old', new_password: 'new' },
    },
];

const APIDocs = () => {
    return (
        <Layout>
            <div className="bg-white rounded p-6 space-y-6">
                <div>
                    <h2 className="text-3xl font-bold text-gray-900">API Documentation</h2>
                    <p className="text-gray-600 mt-2">
                        All endpoints live under the <code>/headlesskey/v1/</code> namespace. Send <code>Content-Type: application/json</code> and include
                        the <code>Authorization: Bearer &lt;token&gt;</code> header where noted.
                    </p>
                </div>

                <div className="grid gap-4">
                    {endpoints.map((endpoint) => (
                        <div key={endpoint.path} className="border border-gray-200 rounded-lg p-5">
                            <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-2">
                                <div>
                                    <p className="text-xs font-semibold tracking-wide uppercase text-gray-500">{endpoint.method}</p>
                                    <h3 className="text-xl font-semibold text-gray-900">{endpoint.title}</h3>
                                    <p className="text-sm text-gray-600">{endpoint.description}</p>
                                </div>
                                <code className="bg-gray-100 rounded px-3 py-1 text-sm text-gray-800">{endpoint.path}</code>
                            </div>
                            <div className="mt-4 grid gap-2">
                                {endpoint.headers && (
                                    <div>
                                        <p className="text-xs font-semibold text-gray-500">Headers</p>
                                        <pre className="bg-gray-50 rounded p-3 text-xs text-gray-800">{JSON.stringify(endpoint.headers, null, 2)}</pre>
                                    </div>
                                )}
                                {endpoint.body && (
                                    <div>
                                        <p className="text-xs font-semibold text-gray-500">Example Body</p>
                                        <pre className="bg-gray-50 rounded p-3 text-xs text-gray-800 whitespace-pre-wrap">{JSON.stringify(endpoint.body, null, 2)}</pre>
                                    </div>
                                )}
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </Layout>
    );
};

export default APIDocs;


