/**
 * External dependencies.
 */
import { Route, Routes } from 'react-router-dom';
import { HomeIcon } from '@heroicons/react/20/solid';

/**
 * Internal dependencies.
 */
import { Header, Footer, Content } from '../parts';

export default function SettingsLayout({ children }) {
    const navigation = [
        { name: 'General Settings', href: '/settings' },
        { name: 'Security Options', href: '/security' },
        { name: 'User Tools', href: '/user-tools' },
    ]

    const secondaryNav = [
        { name: 'Dashboard', href: '/dashboard', icon: HomeIcon },
        { name: 'Token Logs', href: '/token-logs', icon: false },
    ]

    return (
        <>
            <div className="min-h-full">
                <Header navigation={navigation} secondaryNav={secondaryNav} />
                <Content className="space-y-10">{children}</Content>
                <Footer />
            </div>
        </>
    )
}