/**
 * Internal dependencies.
 */
import { Header, Footer, Content } from '../parts';
import {Cog6ToothIcon} from "@heroicons/react/20/solid";

export default function Layout({ children }) {
    const navigation = [
        { name: 'Getting Started', href: '/getting-started' },
        { name: 'Dashboard', href: '/dashboard' },
        { name: 'Token Logs', href: '/token-logs' },
        { name: 'Activity Logs', href: '/activity-logs' },
        { name: 'Live Monitor', href: '/live-monitor' },
        { name: 'API Docs', href: '/api-docs' },
    ]

    const secondaryNav = [
        { name: 'Settings', href: '/settings', icon: Cog6ToothIcon },
        { name: 'Security', href: '/security', icon: false },
    ]

    return (
        <>
            <div className="min-h-full">
                <Header navigation={navigation} secondaryNav={secondaryNav}/>
                <Content>{children}</Content>
                <Footer />
            </div>
        </>
    )
}