/**
 * External dependencies.
 */
import { Route, Routes, Navigate } from 'react-router-dom';
import { Toaster } from 'react-hot-toast';

/**
 * Internal dependencies.
 */
import { Dashboard, Onboarding, TokenLogs, ActivityLogs, LiveMonitor, UserTools, SecurityOptions, APIDocs } from './pages';
import { GeneralSettings, BlockSettings } from './pages/settings';


const App = () => {
    return (
        <>
            <Toaster position="bottom-center" />
            <Routes>
                <Route path="/dashboard" element={<Dashboard />} />
                <Route path="/getting-started" element={<Onboarding />} />
                <Route path="/settings" element={<GeneralSettings />} />
                <Route path="/security" element={<SecurityOptions />} />
                <Route path="/token-logs" element={<TokenLogs />} />
                <Route path="/activity-logs" element={<ActivityLogs />} />
                <Route path="/live-monitor" element={<LiveMonitor />} />
                <Route path="/user-tools" element={<UserTools />} />
                <Route path="/api-docs" element={<APIDocs />} />
                <Route path="/block-settings" element={<BlockSettings />} />

                {/* When no routes match, it will redirect to this route path. Note that it should be registered above. */}
                <Route
                    path="*"
                    element={<Navigate to="/dashboard" replace />}
                />
            </Routes>
        </>
    )
}

export default App;