/**
 * External dependencies.
 */
import apiFetch from '@wordpress/api-fetch';

/**
 * Internal dependencies.
 */
const { apiRoute } = window.vajraPluginState;
import { addQueryArgs } from '@wordpress/url';
export async function getOption( key = false ) {
    const queryParams = key ? { key } : {};

	return await apiFetch( {
        path: addQueryArgs( `/${apiRoute}/options/get`, queryParams ),
    } ).then(
		response => response
	);
}

export async function setOptions( options ){
    const data = {
        options
    };

    return await apiFetch({
            path: `/${apiRoute}/options/set`,
            method: 'POST',
            data,
        } ).then(
            response => response
    );
}

export async function getTokenLogs( params = {} ) {
    const query = addQueryArgs( `/${apiRoute}/admin/logs/tokens`, params );
    return await apiFetch( { path: query } );
}

export async function clearTokenLogs() {
    return await apiFetch( {
        path: `/${apiRoute}/admin/logs/tokens/clear`,
        method: 'POST',
    } );
}

export async function getActivityLogs( params = {} ) {
    const query = addQueryArgs( `/${apiRoute}/admin/logs/activity`, params );
    return await apiFetch( { path: query } );
}

export async function exportSettings() {
    return await apiFetch( {
        path: `/${apiRoute}/admin/settings/export`,
    } );
}

export async function importSettings( settings ) {
    return await apiFetch( {
        path: `/${apiRoute}/admin/settings/import`,
        method: 'POST',
        data: { settings },
    } );
}

export async function adminRevokeToken( token_hash ) {
    return await apiFetch( {
        path: `/${apiRoute}/admin/tokens/revoke`,
        method: 'POST',
        data: { token_hash },
    } );
}

export async function getTokenSummary() {
    return await apiFetch( {
        path: `/${apiRoute}/admin/tokens/summary`,
    } );
}

export async function getAnalyticsOverview() {
    return await apiFetch( {
        path: `/${apiRoute}/admin/analytics/overview`,
    } );
}