<?php
/**
 * Simple role-based access control helper.
 *
 * @package headlesskey
 */

namespace headlesskey\Auth;

use headlesskey\Core\Settings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class RoleAccessManager
 */
class RoleAccessManager {
	/**
	 * Determine whether the request satisfies the rule for an endpoint.
	 *
	 * @param string   $endpoint Endpoint identifier.
	 * @param \WP_User $user Optional user instance.
	 *
	 * @return bool
	 */
	public function can_access( $endpoint, $user = null ) {
		$rules = Settings::get( 'rbac_rules', array() );

		if ( empty( $rules[ $endpoint ] ) ) {
			return true;
		}

		$rule = $rules[ $endpoint ];

		$mode = isset( $rule['mode'] ) ? $rule['mode'] : 'public';

		switch ( $mode ) {
			case 'public':
				return true;
			case 'authenticated':
				return ( $user instanceof \WP_User ) && $user->exists();
			case 'roles':
				$roles = isset( $rule['roles'] ) ? (array) $rule['roles'] : array();
				if ( empty( $roles ) ) {
					return true;
				}
				if ( ! ( $user instanceof \WP_User ) || ! $user->exists() ) {
					return false;
				}
				return (bool) array_intersect( $roles, (array) $user->roles );
			default:
				return true;
		}
	}
}


