<?php
/**
 * Admin Settings Page Template
 *
 * @package HDSofT\AISummary
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

    <?php settings_errors(); ?>

    <form method="post" action="options.php">
        <?php
        settings_fields( 'hdsoft_ai_summary_settings_group' );
        do_settings_sections( 'hd-soft-ai-summary' );
        ?>


        <?php submit_button(); ?>
    </form>

    <div class="hdsoft-ai-summary-info">
        <h2><?php esc_html_e( 'Usage Information', 'hd-soft-ai-summary' ); ?></h2>
        
        <div class="hdsoft-info-section">
            <h3><?php esc_html_e( 'Shortcode', 'hd-soft-ai-summary' ); ?></h3>
            <p><?php esc_html_e( 'Use the following shortcode to display summaries manually:', 'hd-soft-ai-summary' ); ?></p>
            <code>[hdsoft_ai_summary]</code>
            <p class="description">
                <?php esc_html_e( 'You can also specify a post ID:', 'hd-soft-ai-summary' ); ?> 
                <code>[hdsoft_ai_summary post_id="123"]</code>
            </p>
        </div>

        <div class="hdsoft-info-section">
            <h3><?php esc_html_e( 'Template Functions', 'hd-soft-ai-summary' ); ?></h3>
            <p><?php esc_html_e( 'For theme developers, you can use these functions:', 'hd-soft-ai-summary' ); ?></p>
            <pre><code><?php echo esc_html( '<?php
// Get summary for current post
$plugin = HDSofT\AISummary\Plugin::get_instance();
$summary = $plugin->get_summary( get_the_ID() );

// Check if post has summary
if ( $plugin->has_summary( get_the_ID() ) ) {
    echo wp_kses_post( $summary );
}
?>' ); ?></code></pre>
        </div>


        <div class="hdsoft-info-section">
            <h3><?php esc_html_e( 'Privacy Information', 'hd-soft-ai-summary' ); ?></h3>
            <p><?php esc_html_e( 'This plugin may send post content to OpenRouter API for AI summary generation. No personal data is stored by third-party services. API keys are stored locally and never transmitted to plugin developers.', 'hd-soft-ai-summary' ); ?></p>
        </div>

        <?php if ( ! defined( 'HDSUM_PRO' ) || ! HDSUM_PRO ) : ?>
        <div class="hdsoft-info-section hdsoft-upgrade-section">
            <h3><?php esc_html_e( 'Upgrade to Pro', 'hd-soft-ai-summary' ); ?></h3>
            <p><?php esc_html_e( 'Get more powerful features with the Pro version:', 'hd-soft-ai-summary' ); ?></p>
            <ul>
                <li><?php esc_html_e( '✓ Automatic Summary Generation on save/publish', 'hd-soft-ai-summary' ); ?></li>
                <li><?php esc_html_e( '✓ Additional Prompt Styles (Structured Bullets, Executive Brief)', 'hd-soft-ai-summary' ); ?></li>
                <li><?php esc_html_e( '✓ Custom Summary Titles', 'hd-soft-ai-summary' ); ?></li>
                <li><?php esc_html_e( '✓ Enhanced Automation', 'hd-soft-ai-summary' ); ?></li>
                <li><?php esc_html_e( '✓ Priority Support', 'hd-soft-ai-summary' ); ?></li>
            </ul>
            <p>
                <a href="https://hdsoft.fi/hdsoft-ai-summary-pro/" class="button button-primary" target="_blank">
                    <?php esc_html_e( 'Learn More About Pro', 'hd-soft-ai-summary' ); ?>
                </a>
            </p>
        </div>
        <?php endif; ?>

    </div>
</div>
