<?php
/**
 * Plugin Name:         Habibur Comment Blocker
 * Plugin URI:          https://habibur.net/plugins/habibur-comment-blocker
 * Description:         Completely disable comments across the website.
 * Version:             1.0.0
 * Author:              Habibur Rahman
 * Author URI:          https://habibur.net
 * License:             GPLv2 or later
 * License URI:         https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:         habibur-comment-blocker
 * Requires PHP:        7.4
 * Requires at least:   5.5
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class HCB_Comment_Blocker {

    public function __construct() {
        add_action( 'init', [ $this, 'remove_comments_support' ] );
        add_action( 'admin_menu', [ $this, 'remove_comments_menu' ] );
        add_action( 'wp_dashboard_setup', [ $this, 'remove_dashboard_comments' ] );
        add_action( 'load-edit-comments.php', [ $this, 'block_comments_page' ] );
        add_action( 'wp_before_admin_bar_render', [ $this, 'remove_admin_bar_comments' ] );

        add_filter( 'comments_open', '__return_false', 20, 2 );
        add_filter( 'pings_open', '__return_false', 20, 2 );
        add_filter( 'comments_array', '__return_empty_array', 10, 2 );
    }

    /**
     * Redirect comments page safely
     */
    public function block_comments_page() {
        wp_safe_redirect( admin_url() );
        exit;
    }

    /**
     * Remove comment & trackback support from all post types
     */
    public function remove_comments_support() {
        foreach ( get_post_types() as $post_type ) {
            if ( post_type_supports( $post_type, 'comments' ) ) {
                remove_post_type_support( $post_type, 'comments' );
                remove_post_type_support( $post_type, 'trackbacks' );
            }
        }
    }

    /**
     * Remove comments menu from admin sidebar
     */
    public function remove_comments_menu() {
        remove_menu_page( 'edit-comments.php' );
    }

    /**
     * Remove recent comments dashboard widget
     */
    public function remove_dashboard_comments() {
        remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
    }

    /**
     * Remove comments from admin bar
     */
    public function remove_admin_bar_comments() {
        global $wp_admin_bar;
        if ( is_object( $wp_admin_bar ) ) {
            $wp_admin_bar->remove_node( 'comments' );
        }
    }
}

function hcb_init_plugin() {
    new HCB_Comment_Blocker();
}
add_action( 'plugins_loaded', 'hcb_init_plugin' );
