<?php

/** 
 * Plugin name: GVSoft jCarouselLite
 * Description: Wrapper over js plugin jCarouselLite. Надстройка над js плагином jCarouselLite.
 * Plugin URI: http://gvsoft.ru/development/wordpress-plugins/jcarousellite
 * Author: Ganeshji Marwaha, Vladimir Giryavyy
 * Author URI: http://gvsoft.ru/
 * Version: 1.0
 */

if( ! defined('ABSPATH') ) exit; // no direct access

if( defined('WP_INSTALLING') && WP_INSTALLING ) return;

$data = get_file_data( __FILE__, array('Version'=>'Version', 'Domain Path'=>'Domain Path') );

define('GVJCL_VER',  $data['Version'] );

define('GVJCL_PATH', plugin_dir_path(__FILE__) );
define('GVJCL_URL',  plugin_dir_url(__FILE__) );
define('GVJCL_NAME', basename(GVJCL_PATH) );

// Настройки по умолчанию
$gvjcl_def_params['gvjcl_custom_css'] = '';
$gvjcl_def_params['gvjcl_content_separ'] = '/!';

// Подключаем файл перевода
add_action( 'plugins_loaded', function(){
    load_plugin_textdomain( 'gvs-jcarousellite', false, GVJCL_NAME . '/languages' ); 
});
if ( is_admin() ) { // Если мы в адм. интерфейсе
    require_once GVJCL_PATH . 'admin.php';
    return;
}

// Подключаем скрипты и css стили
add_action('wp_enqueue_scripts', function(){
    global $gvjcl_def_params;
    $my_css = get_option('gvjcl_custom_css',$gvjcl_def_params['gvjcl_custom_css']);
    if ( empty($my_css) ) {
        if ( file_exists(GVJCL_PATH.'style.min.css') )
            wp_enqueue_style('gvjcl-css', GVJCL_URL.'style.min.css');
        else
            wp_enqueue_style('gvjcl-css', GVJCL_URL.'style.css');
    } 
    else 
        wp_enqueue_style('gvjcl-css', GVJCL_URL.$my_css);
    
    if ( file_exists(GVJCL_PATH.'jCarouselLite.min.js') )
        wp_enqueue_script('gvjcl', GVJCL_URL.'jCarouselLite.min.js', array('jquery'));
    else
        wp_enqueue_script('gvjcl', GVJCL_URL.'jCarouselLite.js', array('jquery'));
    
    if ( file_exists(GVJCL_PATH.'jquery.mousewheel.min.js') )
        wp_register_script('jqmousewheel', GVJCL_URL.'jquery.mousewheel.min.js', array('jquery'));
    
    if ( file_exists(GVJCL_PATH.'jquery.easing.min.js') )
        wp_register_script('jqeasing', GVJCL_URL.'jquery.easing.min.js', array('jquery'));
    
});

/**
 * Добавляет шорткод карусели
 */
add_shortcode('gvjcl', 'gvjcl_shortcode');
function gvjcl_shortcode($args = [], $content = '') {
    global $gvjcl_def_params;
    // --------------------Глобальные настройки плагина из базы-----------------
    $separ = get_option('gvjcl_content_separ',$gvjcl_def_params['gvjcl_content_separ']);
    // ---------------конец глобальные настройки плагина из базы----------------
    $defaults = [
        // php настройки
        'class' => 'carousel',
        'id' => '', //уникальный идентификатор разметки
        'width'=>'',
        'height'=>'',
        'del_br'=>true,
	'before' => '', //html до шорткода
	'after' => '', //html после шорткода
        // настройки js плагина
        'btn_prev'=> 'null',
        'btn_next'=> 'null',
        'btn_go'=> 'null',
        'mouse_wheel'=> 'false',
        'auto'=> 'null',
        'speed'=> 200,
        'easing'=> 'null',
        'vertical'=> 'false',
        'circular'=> 'true',
        'visible'=> 3,
        'start'=> 0,
        'scroll'=> 1,
        'before_start'=> 'null',
        'after_end'=> 'null'
    ];
    $opt = shortcode_atts( $defaults, $args );
    extract( $opt );
    // Подключение скрипта по требованию
    if ($mouse_wheel === 'true') wp_enqueue_script('jqmousewheel');
    if ($easing !== 'null') wp_enqueue_script('jqeasing');

    $html = $style = '';
    if ($width !== '' || $height !== '') 
        $style = "style=\"overflow: hidden; width: $width; height: $height;\"";
    if ($del_br) $content = str_replace(['<br />','<br>'], ['',''], $content);
    $items = explode($separ, $content);
    foreach( $items as $item ) {
        $html .= "<li $style>$item</li>";
    }
    //---------------------- Подключаем связанный js код -----------------------
    $script = 'jQuery("%id%%class%").jCarouselLite({';
    if ($btn_prev !== 'null') $script .= 'btnPrev: "%btnPrev%",';
    if ($btn_next !== 'null') $script .= 'btnNext: "%btnNext%",';
    if ($btn_go !== 'null') {
        $btn_go = "[$btn_go]";
        $script .= 'btnGo: %btnGo%,';
    }
    if ($mouse_wheel !== 'false') $script .= 'mouseWheel: %mouseWheel%,';
    if ($auto !== 'null') $script .= 'auto: %auto%,';
    if ($speed !== 200) $script .= 'speed: %speed%,';
    if ($easing !== 'null') $script .= 'easing: "%easing%",';
    if ($vertical !== 'false') $script .= 'vertical: %vertical%,';
    if ($circular !== 'true') $script .= 'circular: %circular%,';
    if ($visible !== 3) $script .= 'visible: %visible%,';
    if ($start !== 0) $script .= 'start: %start%,';
    if ($scroll !== 1) $script .= 'scroll: %scroll%,';
    if ($before_start !== 'null') $script .= 'beforeStart: %beforeStart%,';
    if ($after_end !== 'null') $script .= 'afterEnd: %afterEnd%';
    $script .= '});';
    global $gvjcl_jss;
    $idm = $classm = '';
    if ($class !== '') { esc_html($class); $classm = ".$class"; }
    if ($id !== '') { esc_html($id); $idm = "#$id"; $classm = ""; }
    // заменяем плейсхолдеры в шаблоне js
    $gvjcl_jss[] = str_replace(
        [
            "%id%","%class%",
            "%btnPrev%","%btnNext%","%btnGo%","%mouseWheel%",
            "%auto%","%speed%","%easing%","%vertical%","%circular%",
            "%visible%","%start%","%scroll%","%beforeStart%","%afterEnd%",
        ],
        [
            $idm,$classm,
            $btn_prev,$btn_next,$btn_go,$mouse_wheel,
            $auto,$speed,$easing,$vertical,$circular,$visible,
            $start,$scroll,$before_start,$after_end,
        ],
        $script
    );
    //--------------------- Закончили конфигурацию js кода ---------------------
    $class = "class='$class'";
    if ($id !== '') $id = "id='$id'";
       
    return "$before<div $id $class><ul>$html</ul></div>$after";
}

$gvjcl_jss = [];

add_action('wp_footer', function(){
    global $gvjcl_jss;
    if (count($gvjcl_jss) === 0 ) return;
    echo '<script type="text/javascript">jQuery(document).ready(function($){';
    foreach ($gvjcl_jss as $item){
        echo $item;
    }
    echo '});</script>';
});
