<?php
/**
 * Создаем страницу настроек плагина
 */
add_action('admin_menu', function(){
    add_options_page( 'GVSoft jCarouselLite'.' v'.GVJCL_VER, 'GVSoft jCarouselLite', 'manage_options', 
        'GVSjCarouselLite', 'gvjcl_options_page_output' );
});

function gvjcl_options_page_output(){
    global $gvjcl_def_params;
    $msg = '';
    $my_css = get_option('gvjcl_custom_css',$gvjcl_def_params['gvjcl_custom_css']);
    if ( !empty($my_css) && !file_exists(GVJCL_PATH.$my_css) ) 
        $msg = '<span style="color:red">File not exists!</span>';
?>
<div class="wrap">
    <h2><?php echo get_admin_page_title()?></h2>
    <p><?php _e('More information and updates can be found at:','gvs-jcarousellite')?>
    <a href="http://gvsoft.ru/development/wordpress-plugins/jcarousellite">
        http://gvsoft.ru/development/wordpress-plugins/jcarousellite
    </a>
    </p>
<form method="post" action="options.php">
    <?php settings_fields( 'gvjcl-settings' );?>
    <table class="form-table">
        <tr>
            <th scope="row"><?= __('Custom css','gvs-jcarousellite')?></th>
            <td>
                <input type="text" name="gvjcl_custom_css" size="20" 
                title="<?=__('If this field is empty, the default style file is loaded','gvs-jcarousellite')?>"
                value="<?=esc_attr($my_css);?>"><?php echo $msg;?>
                <p class="description"><?php _e('Enter a filename if you want to use your own styles','gvs-jcarousellite')?></p>
            </td>            
        </tr>
        <tr>
            <th scope="row"><?= __('Content delimiter','gvs-jcarousellite')?></th>
            <td>
                <input type="text" name="gvjcl_content_separ" size="4" required="" 
                title="<?=__('You can specify your own content separator','gvs-jcarousellite')?>"
                value="<?=esc_attr(get_option('gvjcl_content_separ',$gvjcl_def_params['gvjcl_content_separ']));?>">
            </td>            
        </tr>        
    </table>
    <input type="submit" class="button-primary" name="save_options" 
        value="<?php _e('Save Changes','gvs-jcarousellite');?>">
</form>
<br>
<b><?php _e('Donation to the author','gvs-jcarousellite')?></b>
<a class="button button-secondary" href="https://www.paypal.me/gvsoft">«PayPal.Me»</a>
<a class="button button-secondary" href="https://yasobe.ru/na/wpplugin">«Я.Соберу»</a>    
</div>
<?php
}

/**
 * Регистрируем настройки.
 */
add_action( 'admin_init', function(){
    register_setting( 'gvjcl-settings', 'gvjcl_custom_css' );
    register_setting( 'gvjcl-settings', 'gvjcl_content_separ' );
});

