<?php
/**
 * Fonts class
 *
 * @author Jegstudio
 * @since 1.0.0
 * @package gutenverse-framework
 */

namespace Gutenverse\Framework;

/**
 * Class Fonts
 *
 * @package gutenverse-framework
 */
class Fonts {

	/**
	 * System font
	 */
	const SYSTEM_FONT = 'system';

	/**
	 * Google Font
	 */
	const GOOGLE_FONT = 'google';

	/**
	 * Custom Font
	 */
	const CUSTOM_FONT = 'custom_font_pro';

	/**
	 * Fonts constructor.
	 */
	public function __construct() {
	}

	/**
	 * Font Groups
	 */
	public function get_font_groups() {
		$groups = array(
			self::CUSTOM_FONT => __( 'Custom Font', 'gutenverse-form' ),
			self::SYSTEM_FONT => __( 'System', 'gutenverse-form' ),
			self::GOOGLE_FONT => __( 'Google', 'gutenverse-form' ),
		);

		return apply_filters( 'gutenverse_font_groups', $groups );
	}

	/**
	 * Get Custom fonts
	 */
	public function get_custom_fonts() {
		$fonts = array();
		return apply_filters( 'gutenverse_custom_fonts', $fonts );
	}
	/**
	 * Get fonts
	 */
	public function get_fonts() {

		$fonts = array(
			// System fonts.
			'Arial'                            => self::SYSTEM_FONT,
			'Tahoma'                           => self::SYSTEM_FONT,
			'Verdana'                          => self::SYSTEM_FONT,
			'Helvetica'                        => self::SYSTEM_FONT,
			'Times New Roman'                  => self::SYSTEM_FONT,
			'Trebuchet MS'                     => self::SYSTEM_FONT,
			'Georgia'                          => self::SYSTEM_FONT,

			// Google Fonts (last update: 20/12/2024).
			'ABeeZee'                          => self::GOOGLE_FONT,
			'ADLaM Display'                    => self::GOOGLE_FONT,
			'AR One Sans'                      => self::GOOGLE_FONT,
			'Abel'                             => self::GOOGLE_FONT,
			'Abhaya Libre'                     => self::GOOGLE_FONT,
			'Aboreto'                          => self::GOOGLE_FONT,
			'Abril Fatface'                    => self::GOOGLE_FONT,
			'Abyssinica SIL'                   => self::GOOGLE_FONT,
			'Aclonica'                         => self::GOOGLE_FONT,
			'Acme'                             => self::GOOGLE_FONT,
			'Actor'                            => self::GOOGLE_FONT,
			'Adamina'                          => self::GOOGLE_FONT,
			'Advent Pro'                       => self::GOOGLE_FONT,
			'Afacad'                           => self::GOOGLE_FONT,
			'Afacad Flux'                      => self::GOOGLE_FONT,
			'Agbalumo'                         => self::GOOGLE_FONT,
			'Agdasima'                         => self::GOOGLE_FONT,
			'Agu Display'                      => self::GOOGLE_FONT,
			'Aguafina Script'                  => self::GOOGLE_FONT,
			'Akatab'                           => self::GOOGLE_FONT,
			'Akaya Kanadaka'                   => self::GOOGLE_FONT,
			'Akaya Telivigala'                 => self::GOOGLE_FONT,
			'Akronim'                          => self::GOOGLE_FONT,
			'Akshar'                           => self::GOOGLE_FONT,
			'Aladin'                           => self::GOOGLE_FONT,
			'Alata'                            => self::GOOGLE_FONT,
			'Alatsi'                           => self::GOOGLE_FONT,
			'Albert Sans'                      => self::GOOGLE_FONT,
			'Aldrich'                          => self::GOOGLE_FONT,
			'Alef'                             => self::GOOGLE_FONT,
			'Alegreya'                         => self::GOOGLE_FONT,
			'Alegreya SC'                      => self::GOOGLE_FONT,
			'Alegreya Sans'                    => self::GOOGLE_FONT,
			'Alegreya Sans SC'                 => self::GOOGLE_FONT,
			'Aleo'                             => self::GOOGLE_FONT,
			'Alex Brush'                       => self::GOOGLE_FONT,
			'Alexandria'                       => self::GOOGLE_FONT,
			'Alfa Slab One'                    => self::GOOGLE_FONT,
			'Alice'                            => self::GOOGLE_FONT,
			'Alike'                            => self::GOOGLE_FONT,
			'Alike Angular'                    => self::GOOGLE_FONT,
			'Alkalami'                         => self::GOOGLE_FONT,
			'Alkatra'                          => self::GOOGLE_FONT,
			'Allan'                            => self::GOOGLE_FONT,
			'Allerta'                          => self::GOOGLE_FONT,
			'Allerta Stencil'                  => self::GOOGLE_FONT,
			'Allison'                          => self::GOOGLE_FONT,
			'Allura'                           => self::GOOGLE_FONT,
			'Almarai'                          => self::GOOGLE_FONT,
			'Almendra'                         => self::GOOGLE_FONT,
			'Almendra Display'                 => self::GOOGLE_FONT,
			'Almendra SC'                      => self::GOOGLE_FONT,
			'Alumni Sans'                      => self::GOOGLE_FONT,
			'Alumni Sans Collegiate One'       => self::GOOGLE_FONT,
			'Alumni Sans Inline One'           => self::GOOGLE_FONT,
			'Alumni Sans Pinstripe'            => self::GOOGLE_FONT,
			'Amarante'                         => self::GOOGLE_FONT,
			'Amaranth'                         => self::GOOGLE_FONT,
			'Amatic SC'                        => self::GOOGLE_FONT,
			'Amethysta'                        => self::GOOGLE_FONT,
			'Amiko'                            => self::GOOGLE_FONT,
			'Amiri'                            => self::GOOGLE_FONT,
			'Amiri Quran'                      => self::GOOGLE_FONT,
			'Amita'                            => self::GOOGLE_FONT,
			'Anaheim'                          => self::GOOGLE_FONT,
			'Andada'                           => self::GOOGLE_FONT,
			'Andada Pro'                       => self::GOOGLE_FONT,
			'Andika'                           => self::GOOGLE_FONT,
			'Anek Bangla'                      => self::GOOGLE_FONT,
			'Anek Devanagari'                  => self::GOOGLE_FONT,
			'Anek Gujarati'                    => self::GOOGLE_FONT,
			'Anek Gurmukhi'                    => self::GOOGLE_FONT,
			'Anek Kannada'                     => self::GOOGLE_FONT,
			'Anek Latin'                       => self::GOOGLE_FONT,
			'Anek Malayalam'                   => self::GOOGLE_FONT,
			'Anek Odia'                        => self::GOOGLE_FONT,
			'Anek Tamil'                       => self::GOOGLE_FONT,
			'Anek Telugu'                      => self::GOOGLE_FONT,
			'Angkor'                           => self::GOOGLE_FONT,
			'Annapurna SIL'                    => self::GOOGLE_FONT,
			'Annie Use Your Telescope'         => self::GOOGLE_FONT,
			'Anonymous Pro'                    => self::GOOGLE_FONT,
			'Anta'                             => self::GOOGLE_FONT,
			'Antic'                            => self::GOOGLE_FONT,
			'Antic Didone'                     => self::GOOGLE_FONT,
			'Antic Slab'                       => self::GOOGLE_FONT,
			'Anton'                            => self::GOOGLE_FONT,
			'Anton SC'                         => self::GOOGLE_FONT,
			'Antonio'                          => self::GOOGLE_FONT,
			'Anuphan'                          => self::GOOGLE_FONT,
			'Anybody'                          => self::GOOGLE_FONT,
			'Aoboshi One'                      => self::GOOGLE_FONT,
			'Arapey'                           => self::GOOGLE_FONT,
			'Arbutus'                          => self::GOOGLE_FONT,
			'Arbutus Slab'                     => self::GOOGLE_FONT,
			'Architects Daughter'              => self::GOOGLE_FONT,
			'Archivo'                          => self::GOOGLE_FONT,
			'Archivo Black'                    => self::GOOGLE_FONT,
			'Archivo Narrow'                   => self::GOOGLE_FONT,
			'Are You Serious'                  => self::GOOGLE_FONT,
			'Aref Ruqaa'                       => self::GOOGLE_FONT,
			'Aref Ruqaa Ink'                   => self::GOOGLE_FONT,
			'Arima'                            => self::GOOGLE_FONT,
			'Arima Madurai'                    => self::GOOGLE_FONT,
			'Arimo'                            => self::GOOGLE_FONT,
			'Arizonia'                         => self::GOOGLE_FONT,
			'Armata'                           => self::GOOGLE_FONT,
			'Arsenal'                          => self::GOOGLE_FONT,
			'Arsenal SC'                       => self::GOOGLE_FONT,
			'Artifika'                         => self::GOOGLE_FONT,
			'Arvo'                             => self::GOOGLE_FONT,
			'Arya'                             => self::GOOGLE_FONT,
			'Asap'                             => self::GOOGLE_FONT,
			'Asap Condensed'                   => self::GOOGLE_FONT,
			'Asar'                             => self::GOOGLE_FONT,
			'Asset'                            => self::GOOGLE_FONT,
			'Assistant'                        => self::GOOGLE_FONT,
			'Astloch'                          => self::GOOGLE_FONT,
			'Asul'                             => self::GOOGLE_FONT,
			'Athiti'                           => self::GOOGLE_FONT,
			'Atkinson Hyperlegible'            => self::GOOGLE_FONT,
			'Atma'                             => self::GOOGLE_FONT,
			'Atomic Age'                       => self::GOOGLE_FONT,
			'Aubrey'                           => self::GOOGLE_FONT,
			'Audiowide'                        => self::GOOGLE_FONT,
			'Autour One'                       => self::GOOGLE_FONT,
			'Average'                          => self::GOOGLE_FONT,
			'Average Sans'                     => self::GOOGLE_FONT,
			'Averia Gruesa Libre'              => self::GOOGLE_FONT,
			'Averia Libre'                     => self::GOOGLE_FONT,
			'Averia Sans Libre'                => self::GOOGLE_FONT,
			'Averia Serif Libre'               => self::GOOGLE_FONT,
			'Azeret Mono'                      => self::GOOGLE_FONT,
			'B612'                             => self::GOOGLE_FONT,
			'B612 Mono'                        => self::GOOGLE_FONT,
			'BIZ UDGothic'                     => self::GOOGLE_FONT,
			'BIZ UDMincho'                     => self::GOOGLE_FONT,
			'BIZ UDPGothic'                    => self::GOOGLE_FONT,
			'BIZ UDPMincho'                    => self::GOOGLE_FONT,
			'Babylonica'                       => self::GOOGLE_FONT,
			'Bacasime Antique'                 => self::GOOGLE_FONT,
			'Bad Script'                       => self::GOOGLE_FONT,
			'Badeen Display'                   => self::GOOGLE_FONT,
			'Bagel Fat One'                    => self::GOOGLE_FONT,
			'Bahiana'                          => self::GOOGLE_FONT,
			'Bahianita'                        => self::GOOGLE_FONT,
			'Bai Jamjuree'                     => self::GOOGLE_FONT,
			'Bakbak One'                       => self::GOOGLE_FONT,
			'Ballet'                           => self::GOOGLE_FONT,
			'Baloo'                            => self::GOOGLE_FONT,
			'Baloo 2'                          => self::GOOGLE_FONT,
			'Baloo Bhai'                       => self::GOOGLE_FONT,
			'Baloo Bhai 2'                     => self::GOOGLE_FONT,
			'Baloo Bhaijaan'                   => self::GOOGLE_FONT,
			'Baloo Bhaijaan 2'                 => self::GOOGLE_FONT,
			'Baloo Bhaina'                     => self::GOOGLE_FONT,
			'Baloo Bhaina 2'                   => self::GOOGLE_FONT,
			'Baloo Chettan'                    => self::GOOGLE_FONT,
			'Baloo Chettan 2'                  => self::GOOGLE_FONT,
			'Baloo Da'                         => self::GOOGLE_FONT,
			'Baloo Da 2'                       => self::GOOGLE_FONT,
			'Baloo Paaji'                      => self::GOOGLE_FONT,
			'Baloo Paaji 2'                    => self::GOOGLE_FONT,
			'Baloo Tamma'                      => self::GOOGLE_FONT,
			'Baloo Tamma 2'                    => self::GOOGLE_FONT,
			'Baloo Tammudu'                    => self::GOOGLE_FONT,
			'Baloo Tammudu 2'                  => self::GOOGLE_FONT,
			'Baloo Thambi'                     => self::GOOGLE_FONT,
			'Baloo Thambi 2'                   => self::GOOGLE_FONT,
			'Balsamiq Sans'                    => self::GOOGLE_FONT,
			'Balthazar'                        => self::GOOGLE_FONT,
			'Bangers'                          => self::GOOGLE_FONT,
			'Barlow'                           => self::GOOGLE_FONT,
			'Barlow Condensed'                 => self::GOOGLE_FONT,
			'Barlow Semi Condensed'            => self::GOOGLE_FONT,
			'Barriecito'                       => self::GOOGLE_FONT,
			'Barrio'                           => self::GOOGLE_FONT,
			'Basic'                            => self::GOOGLE_FONT,
			'Baskervville'                     => self::GOOGLE_FONT,
			'Baskervville SC'                  => self::GOOGLE_FONT,
			'Battambang'                       => self::GOOGLE_FONT,
			'Baumans'                          => self::GOOGLE_FONT,
			'Bayon'                            => self::GOOGLE_FONT,
			'Be Vietnam Pro'                   => self::GOOGLE_FONT,
			'Beau Rivage'                      => self::GOOGLE_FONT,
			'Bebas Neue'                       => self::GOOGLE_FONT,
			'Beiruti'                          => self::GOOGLE_FONT,
			'Belanosima'                       => self::GOOGLE_FONT,
			'Belgrano'                         => self::GOOGLE_FONT,
			'Bellefair'                        => self::GOOGLE_FONT,
			'Belleza'                          => self::GOOGLE_FONT,
			'Bellota'                          => self::GOOGLE_FONT,
			'Bellota Text'                     => self::GOOGLE_FONT,
			'BenchNine'                        => self::GOOGLE_FONT,
			'Benne'                            => self::GOOGLE_FONT,
			'Bentham'                          => self::GOOGLE_FONT,
			'Berkshire Swash'                  => self::GOOGLE_FONT,
			'Besley'                           => self::GOOGLE_FONT,
			'Beth Ellen'                       => self::GOOGLE_FONT,
			'Bevan'                            => self::GOOGLE_FONT,
			'BhuTuka Expanded One'             => self::GOOGLE_FONT,
			'Big Shoulders Display'            => self::GOOGLE_FONT,
			'Big Shoulders Inline Display'     => self::GOOGLE_FONT,
			'Big Shoulders Inline Text'        => self::GOOGLE_FONT,
			'Big Shoulders Stencil Display'    => self::GOOGLE_FONT,
			'Big Shoulders Stencil Text'       => self::GOOGLE_FONT,
			'Big Shoulders Text'               => self::GOOGLE_FONT,
			'Bigelow Rules'                    => self::GOOGLE_FONT,
			'Bigshot One'                      => self::GOOGLE_FONT,
			'Bilbo'                            => self::GOOGLE_FONT,
			'Bilbo Swash Caps'                 => self::GOOGLE_FONT,
			'BioRhyme'                         => self::GOOGLE_FONT,
			'BioRhyme Expanded'                => self::GOOGLE_FONT,
			'Birthstone'                       => self::GOOGLE_FONT,
			'Birthstone Bounce'                => self::GOOGLE_FONT,
			'Biryani'                          => self::GOOGLE_FONT,
			'Bitter'                           => self::GOOGLE_FONT,
			'Black And White Picture'          => self::GOOGLE_FONT,
			'Black Han Sans'                   => self::GOOGLE_FONT,
			'Black Ops One'                    => self::GOOGLE_FONT,
			'Blaka'                            => self::GOOGLE_FONT,
			'Blaka Hollow'                     => self::GOOGLE_FONT,
			'Blaka Ink'                        => self::GOOGLE_FONT,
			'Blinker'                          => self::GOOGLE_FONT,
			'Bodoni Moda'                      => self::GOOGLE_FONT,
			'Bodoni Moda SC'                   => self::GOOGLE_FONT,
			'Bokor'                            => self::GOOGLE_FONT,
			'Bona Nova'                        => self::GOOGLE_FONT,
			'Bona Nova SC'                     => self::GOOGLE_FONT,
			'Bonbon'                           => self::GOOGLE_FONT,
			'Bonheur Royale'                   => self::GOOGLE_FONT,
			'Boogaloo'                         => self::GOOGLE_FONT,
			'Borel'                            => self::GOOGLE_FONT,
			'Bowlby One'                       => self::GOOGLE_FONT,
			'Bowlby One SC'                    => self::GOOGLE_FONT,
			'Braah One'                        => self::GOOGLE_FONT,
			'Brawler'                          => self::GOOGLE_FONT,
			'Bree Serif'                       => self::GOOGLE_FONT,
			'Bricolage Grotesque'              => self::GOOGLE_FONT,
			'Bruno Ace'                        => self::GOOGLE_FONT,
			'Bruno Ace SC'                     => self::GOOGLE_FONT,
			'Brygada 1918'                     => self::GOOGLE_FONT,
			'Bubblegum Sans'                   => self::GOOGLE_FONT,
			'Bubbler One'                      => self::GOOGLE_FONT,
			'Buda'                             => self::GOOGLE_FONT,
			'Buenard'                          => self::GOOGLE_FONT,
			'Bungee'                           => self::GOOGLE_FONT,
			'Bungee Hairline'                  => self::GOOGLE_FONT,
			'Bungee Inline'                    => self::GOOGLE_FONT,
			'Bungee Outline'                   => self::GOOGLE_FONT,
			'Bungee Shade'                     => self::GOOGLE_FONT,
			'Bungee Spice'                     => self::GOOGLE_FONT,
			'Bungee Tint'                      => self::GOOGLE_FONT,
			'Butcherman'                       => self::GOOGLE_FONT,
			'Butterfly Kids'                   => self::GOOGLE_FONT,
			'Cabin'                            => self::GOOGLE_FONT,
			'Cabin Condensed'                  => self::GOOGLE_FONT,
			'Cabin Sketch'                     => self::GOOGLE_FONT,
			'Cactus Classical Serif'           => self::GOOGLE_FONT,
			'Caesar Dressing'                  => self::GOOGLE_FONT,
			'Cagliostro'                       => self::GOOGLE_FONT,
			'Cairo'                            => self::GOOGLE_FONT,
			'Cairo Play'                       => self::GOOGLE_FONT,
			'Caladea'                          => self::GOOGLE_FONT,
			'Calistoga'                        => self::GOOGLE_FONT,
			'Calligraffitti'                   => self::GOOGLE_FONT,
			'Cambay'                           => self::GOOGLE_FONT,
			'Cambo'                            => self::GOOGLE_FONT,
			'Candal'                           => self::GOOGLE_FONT,
			'Cantarell'                        => self::GOOGLE_FONT,
			'Cantata One'                      => self::GOOGLE_FONT,
			'Cantora One'                      => self::GOOGLE_FONT,
			'Caprasimo'                        => self::GOOGLE_FONT,
			'Capriola'                         => self::GOOGLE_FONT,
			'Caramel'                          => self::GOOGLE_FONT,
			'Carattere'                        => self::GOOGLE_FONT,
			'Cardo'                            => self::GOOGLE_FONT,
			'Carlito'                          => self::GOOGLE_FONT,
			'Carme'                            => self::GOOGLE_FONT,
			'Carrois Gothic'                   => self::GOOGLE_FONT,
			'Carrois Gothic SC'                => self::GOOGLE_FONT,
			'Carter One'                       => self::GOOGLE_FONT,
			'Castoro'                          => self::GOOGLE_FONT,
			'Castoro Titling'                  => self::GOOGLE_FONT,
			'Catamaran'                        => self::GOOGLE_FONT,
			'Caudex'                           => self::GOOGLE_FONT,
			'Caveat'                           => self::GOOGLE_FONT,
			'Caveat Brush'                     => self::GOOGLE_FONT,
			'Cedarville Cursive'               => self::GOOGLE_FONT,
			'Ceviche One'                      => self::GOOGLE_FONT,
			'Chakra Petch'                     => self::GOOGLE_FONT,
			'Changa'                           => self::GOOGLE_FONT,
			'Changa One'                       => self::GOOGLE_FONT,
			'Chango'                           => self::GOOGLE_FONT,
			'Charis SIL'                       => self::GOOGLE_FONT,
			'Charm'                            => self::GOOGLE_FONT,
			'Charmonman'                       => self::GOOGLE_FONT,
			'Chathura'                         => self::GOOGLE_FONT,
			'Chau Philomene One'               => self::GOOGLE_FONT,
			'Chela One'                        => self::GOOGLE_FONT,
			'Chelsea Market'                   => self::GOOGLE_FONT,
			'Chenla'                           => self::GOOGLE_FONT,
			'Cherish'                          => self::GOOGLE_FONT,
			'Cherry Bomb One'                  => self::GOOGLE_FONT,
			'Cherry Cream Soda'                => self::GOOGLE_FONT,
			'Cherry Swash'                     => self::GOOGLE_FONT,
			'Chewy'                            => self::GOOGLE_FONT,
			'Chicle'                           => self::GOOGLE_FONT,
			'Chilanka'                         => self::GOOGLE_FONT,
			'Chivo'                            => self::GOOGLE_FONT,
			'Chivo Mono'                       => self::GOOGLE_FONT,
			'Chocolate Classical Sans'         => self::GOOGLE_FONT,
			'Chokokutai'                       => self::GOOGLE_FONT,
			'Chonburi'                         => self::GOOGLE_FONT,
			'Cinzel'                           => self::GOOGLE_FONT,
			'Cinzel Decorative'                => self::GOOGLE_FONT,
			'Clicker Script'                   => self::GOOGLE_FONT,
			'Climate Crisis'                   => self::GOOGLE_FONT,
			'Coda'                             => self::GOOGLE_FONT,
			'Coda Caption'                     => self::GOOGLE_FONT,
			'Codystar'                         => self::GOOGLE_FONT,
			'Coiny'                            => self::GOOGLE_FONT,
			'Combo'                            => self::GOOGLE_FONT,
			'Comfortaa'                        => self::GOOGLE_FONT,
			'Comforter'                        => self::GOOGLE_FONT,
			'Comforter Brush'                  => self::GOOGLE_FONT,
			'Comic Neue'                       => self::GOOGLE_FONT,
			'Coming Soon'                      => self::GOOGLE_FONT,
			'Comme'                            => self::GOOGLE_FONT,
			'Commissioner'                     => self::GOOGLE_FONT,
			'Concert One'                      => self::GOOGLE_FONT,
			'Condiment'                        => self::GOOGLE_FONT,
			'Content'                          => self::GOOGLE_FONT,
			'Contrail One'                     => self::GOOGLE_FONT,
			'Convergence'                      => self::GOOGLE_FONT,
			'Cookie'                           => self::GOOGLE_FONT,
			'Copse'                            => self::GOOGLE_FONT,
			'Corben'                           => self::GOOGLE_FONT,
			'Corinthia'                        => self::GOOGLE_FONT,
			'Cormorant'                        => self::GOOGLE_FONT,
			'Cormorant Garamond'               => self::GOOGLE_FONT,
			'Cormorant Infant'                 => self::GOOGLE_FONT,
			'Cormorant SC'                     => self::GOOGLE_FONT,
			'Cormorant Unicase'                => self::GOOGLE_FONT,
			'Cormorant Upright'                => self::GOOGLE_FONT,
			'Courgette'                        => self::GOOGLE_FONT,
			'Courier Prime'                    => self::GOOGLE_FONT,
			'Cousine'                          => self::GOOGLE_FONT,
			'Coustard'                         => self::GOOGLE_FONT,
			'Covered By Your Grace'            => self::GOOGLE_FONT,
			'Crafty Girls'                     => self::GOOGLE_FONT,
			'Creepster'                        => self::GOOGLE_FONT,
			'Crete Round'                      => self::GOOGLE_FONT,
			'Crimson Pro'                      => self::GOOGLE_FONT,
			'Crimson Text'                     => self::GOOGLE_FONT,
			'Croissant One'                    => self::GOOGLE_FONT,
			'Crushed'                          => self::GOOGLE_FONT,
			'Cuprum'                           => self::GOOGLE_FONT,
			'Cute Font'                        => self::GOOGLE_FONT,
			'Cutive'                           => self::GOOGLE_FONT,
			'Cutive Mono'                      => self::GOOGLE_FONT,
			'DM Mono'                          => self::GOOGLE_FONT,
			'DM Sans'                          => self::GOOGLE_FONT,
			'DM Serif Display'                 => self::GOOGLE_FONT,
			'DM Serif Text'                    => self::GOOGLE_FONT,
			'Dai Banna SIL'                    => self::GOOGLE_FONT,
			'Damion'                           => self::GOOGLE_FONT,
			'Dancing Script'                   => self::GOOGLE_FONT,
			'Danfo'                            => self::GOOGLE_FONT,
			'Dangrek'                          => self::GOOGLE_FONT,
			'Darker Grotesque'                 => self::GOOGLE_FONT,
			'Darumadrop One'                   => self::GOOGLE_FONT,
			'David Libre'                      => self::GOOGLE_FONT,
			'Dawning of a New Day'             => self::GOOGLE_FONT,
			'Days One'                         => self::GOOGLE_FONT,
			'Dekko'                            => self::GOOGLE_FONT,
			'Dela Gothic One'                  => self::GOOGLE_FONT,
			'Delicious Handrawn'               => self::GOOGLE_FONT,
			'Delius'                           => self::GOOGLE_FONT,
			'Delius Swash Caps'                => self::GOOGLE_FONT,
			'Delius Unicase'                   => self::GOOGLE_FONT,
			'Della Respira'                    => self::GOOGLE_FONT,
			'Denk One'                         => self::GOOGLE_FONT,
			'Devonshire'                       => self::GOOGLE_FONT,
			'Dhurjati'                         => self::GOOGLE_FONT,
			'Didact Gothic'                    => self::GOOGLE_FONT,
			'Diphylleia'                       => self::GOOGLE_FONT,
			'Diplomata'                        => self::GOOGLE_FONT,
			'Diplomata SC'                     => self::GOOGLE_FONT,
			'Do Hyeon'                         => self::GOOGLE_FONT,
			'Dokdo'                            => self::GOOGLE_FONT,
			'Domine'                           => self::GOOGLE_FONT,
			'Donegal One'                      => self::GOOGLE_FONT,
			'Dongle'                           => self::GOOGLE_FONT,
			'Doppio One'                       => self::GOOGLE_FONT,
			'Dorsa'                            => self::GOOGLE_FONT,
			'Dosis'                            => self::GOOGLE_FONT,
			'DotGothic16'                      => self::GOOGLE_FONT,
			'Doto'                             => self::GOOGLE_FONT,
			'Dr Sugiyama'                      => self::GOOGLE_FONT,
			'Duru Sans'                        => self::GOOGLE_FONT,
			'DynaPuff'                         => self::GOOGLE_FONT,
			'Dynalight'                        => self::GOOGLE_FONT,
			'EB Garamond'                      => self::GOOGLE_FONT,
			'Eagle Lake'                       => self::GOOGLE_FONT,
			'East Sea Dokdo'                   => self::GOOGLE_FONT,
			'Eater'                            => self::GOOGLE_FONT,
			'Economica'                        => self::GOOGLE_FONT,
			'Eczar'                            => self::GOOGLE_FONT,
			'Edu AU VIC WA NT Arrows'          => self::GOOGLE_FONT,
			'Edu AU VIC WA NT Dots'            => self::GOOGLE_FONT,
			'Edu AU VIC WA NT Guides'          => self::GOOGLE_FONT,
			'Edu AU VIC WA NT Hand'            => self::GOOGLE_FONT,
			'Edu AU VIC WA NT Pre'             => self::GOOGLE_FONT,
			'Edu NSW ACT Foundation'           => self::GOOGLE_FONT,
			'Edu QLD Beginner'                 => self::GOOGLE_FONT,
			'Edu SA Beginner'                  => self::GOOGLE_FONT,
			'Edu TAS Beginner'                 => self::GOOGLE_FONT,
			'Edu VIC WA NT Beginner'           => self::GOOGLE_FONT,
			'El Messiri'                       => self::GOOGLE_FONT,
			'Electrolize'                      => self::GOOGLE_FONT,
			'Elsie'                            => self::GOOGLE_FONT,
			'Elsie Swash Caps'                 => self::GOOGLE_FONT,
			'Emblema One'                      => self::GOOGLE_FONT,
			'Emilys Candy'                     => self::GOOGLE_FONT,
			'Encode Sans'                      => self::GOOGLE_FONT,
			'Encode Sans Condensed'            => self::GOOGLE_FONT,
			'Encode Sans Expanded'             => self::GOOGLE_FONT,
			'Encode Sans SC'                   => self::GOOGLE_FONT,
			'Encode Sans Semi Condensed'       => self::GOOGLE_FONT,
			'Encode Sans Semi Expanded'        => self::GOOGLE_FONT,
			'Engagement'                       => self::GOOGLE_FONT,
			'Englebert'                        => self::GOOGLE_FONT,
			'Enriqueta'                        => self::GOOGLE_FONT,
			'Ephesis'                          => self::GOOGLE_FONT,
			'Epilogue'                         => self::GOOGLE_FONT,
			'Erica One'                        => self::GOOGLE_FONT,
			'Esteban'                          => self::GOOGLE_FONT,
			'Estonia'                          => self::GOOGLE_FONT,
			'Euphoria Script'                  => self::GOOGLE_FONT,
			'Ewert'                            => self::GOOGLE_FONT,
			'Exo'                              => self::GOOGLE_FONT,
			'Exo 2'                            => self::GOOGLE_FONT,
			'Expletus Sans'                    => self::GOOGLE_FONT,
			'Explora'                          => self::GOOGLE_FONT,
			'Faculty Glyphic'                  => self::GOOGLE_FONT,
			'Fahkwang'                         => self::GOOGLE_FONT,
			'Familjen Grotesk'                 => self::GOOGLE_FONT,
			'Fanwood Text'                     => self::GOOGLE_FONT,
			'Farro'                            => self::GOOGLE_FONT,
			'Farsan'                           => self::GOOGLE_FONT,
			'Fascinate'                        => self::GOOGLE_FONT,
			'Fascinate Inline'                 => self::GOOGLE_FONT,
			'Faster One'                       => self::GOOGLE_FONT,
			'Fasthand'                         => self::GOOGLE_FONT,
			'Fauna One'                        => self::GOOGLE_FONT,
			'Faustina'                         => self::GOOGLE_FONT,
			'Federant'                         => self::GOOGLE_FONT,
			'Federo'                           => self::GOOGLE_FONT,
			'Felipa'                           => self::GOOGLE_FONT,
			'Fenix'                            => self::GOOGLE_FONT,
			'Festive'                          => self::GOOGLE_FONT,
			'Figtree'                          => self::GOOGLE_FONT,
			'Finger Paint'                     => self::GOOGLE_FONT,
			'Finlandica'                       => self::GOOGLE_FONT,
			'Fira Code'                        => self::GOOGLE_FONT,
			'Fira Mono'                        => self::GOOGLE_FONT,
			'Fira Sans'                        => self::GOOGLE_FONT,
			'Fira Sans Condensed'              => self::GOOGLE_FONT,
			'Fira Sans Extra Condensed'        => self::GOOGLE_FONT,
			'Fjalla One'                       => self::GOOGLE_FONT,
			'Fjord One'                        => self::GOOGLE_FONT,
			'Flamenco'                         => self::GOOGLE_FONT,
			'Flavors'                          => self::GOOGLE_FONT,
			'Fleur De Leah'                    => self::GOOGLE_FONT,
			'Flow Block'                       => self::GOOGLE_FONT,
			'Flow Circular'                    => self::GOOGLE_FONT,
			'Flow Rounded'                     => self::GOOGLE_FONT,
			'Foldit'                           => self::GOOGLE_FONT,
			'Fondamento'                       => self::GOOGLE_FONT,
			'Fontdiner Swanky'                 => self::GOOGLE_FONT,
			'Forum'                            => self::GOOGLE_FONT,
			'Fragment Mono'                    => self::GOOGLE_FONT,
			'Francois One'                     => self::GOOGLE_FONT,
			'Frank Ruhl Libre'                 => self::GOOGLE_FONT,
			'Fraunces'                         => self::GOOGLE_FONT,
			'Freckle Face'                     => self::GOOGLE_FONT,
			'Fredericka the Great'             => self::GOOGLE_FONT,
			'Fredoka'                          => self::GOOGLE_FONT,
			'Fredoka One'                      => self::GOOGLE_FONT,
			'Freehand'                         => self::GOOGLE_FONT,
			'Freeman'                          => self::GOOGLE_FONT,
			'Fresca'                           => self::GOOGLE_FONT,
			'Frijole'                          => self::GOOGLE_FONT,
			'Fruktur'                          => self::GOOGLE_FONT,
			'Fugaz One'                        => self::GOOGLE_FONT,
			'Fuggles'                          => self::GOOGLE_FONT,
			'Funnel Display'                   => self::GOOGLE_FONT,
			'Funnel Sans'                      => self::GOOGLE_FONT,
			'Fustat'                           => self::GOOGLE_FONT,
			'Fuzzy Bubbles'                    => self::GOOGLE_FONT,
			'GFS Didot'                        => self::GOOGLE_FONT,
			'GFS Neohellenic'                  => self::GOOGLE_FONT,
			'Ga Maamli'                        => self::GOOGLE_FONT,
			'Gabarito'                         => self::GOOGLE_FONT,
			'Gabriela'                         => self::GOOGLE_FONT,
			'Gaegu'                            => self::GOOGLE_FONT,
			'Gafata'                           => self::GOOGLE_FONT,
			'Gajraj One'                       => self::GOOGLE_FONT,
			'Galada'                           => self::GOOGLE_FONT,
			'Galdeano'                         => self::GOOGLE_FONT,
			'Galindo'                          => self::GOOGLE_FONT,
			'Gamja Flower'                     => self::GOOGLE_FONT,
			'Gantari'                          => self::GOOGLE_FONT,
			'Gasoek One'                       => self::GOOGLE_FONT,
			'Gayathri'                         => self::GOOGLE_FONT,
			'Geist'                            => self::GOOGLE_FONT,
			'Geist Mono'                       => self::GOOGLE_FONT,
			'Gelasio'                          => self::GOOGLE_FONT,
			'Gemunu Libre'                     => self::GOOGLE_FONT,
			'Genos'                            => self::GOOGLE_FONT,
			'Gentium Basic'                    => self::GOOGLE_FONT,
			'Gentium Book Basic'               => self::GOOGLE_FONT,
			'Gentium Book Plus'                => self::GOOGLE_FONT,
			'Gentium Plus'                     => self::GOOGLE_FONT,
			'Geo'                              => self::GOOGLE_FONT,
			'Geologica'                        => self::GOOGLE_FONT,
			'Georama'                          => self::GOOGLE_FONT,
			'Geostar'                          => self::GOOGLE_FONT,
			'Geostar Fill'                     => self::GOOGLE_FONT,
			'Germania One'                     => self::GOOGLE_FONT,
			'Gideon Roman'                     => self::GOOGLE_FONT,
			'Gidugu'                           => self::GOOGLE_FONT,
			'Gilda Display'                    => self::GOOGLE_FONT,
			'Girassol'                         => self::GOOGLE_FONT,
			'Give You Glory'                   => self::GOOGLE_FONT,
			'Glass Antiqua'                    => self::GOOGLE_FONT,
			'Glegoo'                           => self::GOOGLE_FONT,
			'Gloock'                           => self::GOOGLE_FONT,
			'Gloria Hallelujah'                => self::GOOGLE_FONT,
			'Glory'                            => self::GOOGLE_FONT,
			'Gluten'                           => self::GOOGLE_FONT,
			'Goblin One'                       => self::GOOGLE_FONT,
			'Gochi Hand'                       => self::GOOGLE_FONT,
			'Goldman'                          => self::GOOGLE_FONT,
			'Golos Text'                       => self::GOOGLE_FONT,
			'Gorditas'                         => self::GOOGLE_FONT,
			'Gothic A1'                        => self::GOOGLE_FONT,
			'Gotu'                             => self::GOOGLE_FONT,
			'Goudy Bookletter 1911'            => self::GOOGLE_FONT,
			'Gowun Batang'                     => self::GOOGLE_FONT,
			'Gowun Dodum'                      => self::GOOGLE_FONT,
			'Graduate'                         => self::GOOGLE_FONT,
			'Grand Hotel'                      => self::GOOGLE_FONT,
			'Grandiflora One'                  => self::GOOGLE_FONT,
			'Grandstander'                     => self::GOOGLE_FONT,
			'Grape Nuts'                       => self::GOOGLE_FONT,
			'Gravitas One'                     => self::GOOGLE_FONT,
			'Great Vibes'                      => self::GOOGLE_FONT,
			'Grechen Fuemen'                   => self::GOOGLE_FONT,
			'Grenze'                           => self::GOOGLE_FONT,
			'Grenze Gotisch'                   => self::GOOGLE_FONT,
			'Grey Qo'                          => self::GOOGLE_FONT,
			'Griffy'                           => self::GOOGLE_FONT,
			'Gruppo'                           => self::GOOGLE_FONT,
			'Gudea'                            => self::GOOGLE_FONT,
			'Gugi'                             => self::GOOGLE_FONT,
			'Gulzar'                           => self::GOOGLE_FONT,
			'Gupter'                           => self::GOOGLE_FONT,
			'Gurajada'                         => self::GOOGLE_FONT,
			'Gwendolyn'                        => self::GOOGLE_FONT,
			'Habibi'                           => self::GOOGLE_FONT,
			'Hachi Maru Pop'                   => self::GOOGLE_FONT,
			'Hahmlet'                          => self::GOOGLE_FONT,
			'Halant'                           => self::GOOGLE_FONT,
			'Hammersmith One'                  => self::GOOGLE_FONT,
			'Hanalei'                          => self::GOOGLE_FONT,
			'Hanalei Fill'                     => self::GOOGLE_FONT,
			'Handjet'                          => self::GOOGLE_FONT,
			'Handlee'                          => self::GOOGLE_FONT,
			'Hanken Grotesk'                   => self::GOOGLE_FONT,
			'Hanuman'                          => self::GOOGLE_FONT,
			'Happy Monkey'                     => self::GOOGLE_FONT,
			'Harmattan'                        => self::GOOGLE_FONT,
			'Headland One'                     => self::GOOGLE_FONT,
			'Hedvig Letters Sans'              => self::GOOGLE_FONT,
			'Hedvig Letters Serif'             => self::GOOGLE_FONT,
			'Heebo'                            => self::GOOGLE_FONT,
			'Henny Penny'                      => self::GOOGLE_FONT,
			'Hepta Slab'                       => self::GOOGLE_FONT,
			'Herr Von Muellerhoff'             => self::GOOGLE_FONT,
			'Hi Melody'                        => self::GOOGLE_FONT,
			'Hina Mincho'                      => self::GOOGLE_FONT,
			'Hind'                             => self::GOOGLE_FONT,
			'Hind Guntur'                      => self::GOOGLE_FONT,
			'Hind Madurai'                     => self::GOOGLE_FONT,
			'Hind Mysuru'                      => self::GOOGLE_FONT,
			'Hind Siliguri'                    => self::GOOGLE_FONT,
			'Hind Vadodara'                    => self::GOOGLE_FONT,
			'Holtwood One SC'                  => self::GOOGLE_FONT,
			'Homemade Apple'                   => self::GOOGLE_FONT,
			'Homenaje'                         => self::GOOGLE_FONT,
			'Honk'                             => self::GOOGLE_FONT,
			'Host Grotesk'                     => self::GOOGLE_FONT,
			'Hubballi'                         => self::GOOGLE_FONT,
			'Hubot Sans'                       => self::GOOGLE_FONT,
			'Hurricane'                        => self::GOOGLE_FONT,
			'IBM Plex Mono'                    => self::GOOGLE_FONT,
			'IBM Plex Sans'                    => self::GOOGLE_FONT,
			'IBM Plex Sans Arabic'             => self::GOOGLE_FONT,
			'IBM Plex Sans Condensed'          => self::GOOGLE_FONT,
			'IBM Plex Sans Devanagari'         => self::GOOGLE_FONT,
			'IBM Plex Sans Hebrew'             => self::GOOGLE_FONT,
			'IBM Plex Sans JP'                 => self::GOOGLE_FONT,
			'IBM Plex Sans KR'                 => self::GOOGLE_FONT,
			'IBM Plex Sans Thai'               => self::GOOGLE_FONT,
			'IBM Plex Sans Thai Looped'        => self::GOOGLE_FONT,
			'IBM Plex Serif'                   => self::GOOGLE_FONT,
			'IM Fell DW Pica'                  => self::GOOGLE_FONT,
			'IM Fell DW Pica SC'               => self::GOOGLE_FONT,
			'IM Fell Double Pica'              => self::GOOGLE_FONT,
			'IM Fell Double Pica SC'           => self::GOOGLE_FONT,
			'IM Fell English'                  => self::GOOGLE_FONT,
			'IM Fell English SC'               => self::GOOGLE_FONT,
			'IM Fell French Canon'             => self::GOOGLE_FONT,
			'IM Fell French Canon SC'          => self::GOOGLE_FONT,
			'IM Fell Great Primer'             => self::GOOGLE_FONT,
			'IM Fell Great Primer SC'          => self::GOOGLE_FONT,
			'Ibarra Real Nova'                 => self::GOOGLE_FONT,
			'Iceberg'                          => self::GOOGLE_FONT,
			'Iceland'                          => self::GOOGLE_FONT,
			'Imbue'                            => self::GOOGLE_FONT,
			'Imperial Script'                  => self::GOOGLE_FONT,
			'Imprima'                          => self::GOOGLE_FONT,
			'Inclusive Sans'                   => self::GOOGLE_FONT,
			'Inconsolata'                      => self::GOOGLE_FONT,
			'Inder'                            => self::GOOGLE_FONT,
			'Indie Flower'                     => self::GOOGLE_FONT,
			'Ingrid Darling'                   => self::GOOGLE_FONT,
			'Inika'                            => self::GOOGLE_FONT,
			'Inknut Antiqua'                   => self::GOOGLE_FONT,
			'Inria Sans'                       => self::GOOGLE_FONT,
			'Inria Serif'                      => self::GOOGLE_FONT,
			'Inspiration'                      => self::GOOGLE_FONT,
			'Instrument Sans'                  => self::GOOGLE_FONT,
			'Instrument Serif'                 => self::GOOGLE_FONT,
			'Inter'                            => self::GOOGLE_FONT,
			'Inter Tight'                      => self::GOOGLE_FONT,
			'Irish Grover'                     => self::GOOGLE_FONT,
			'Island Moments'                   => self::GOOGLE_FONT,
			'Istok Web'                        => self::GOOGLE_FONT,
			'Italiana'                         => self::GOOGLE_FONT,
			'Italianno'                        => self::GOOGLE_FONT,
			'Itim'                             => self::GOOGLE_FONT,
			'Jacquard 12'                      => self::GOOGLE_FONT,
			'Jacquard 12 Charted'              => self::GOOGLE_FONT,
			'Jacquard 24'                      => self::GOOGLE_FONT,
			'Jacquard 24 Charted'              => self::GOOGLE_FONT,
			'Jacquarda Bastarda 9'             => self::GOOGLE_FONT,
			'Jacquarda Bastarda 9 Charted'     => self::GOOGLE_FONT,
			'Jacques Francois'                 => self::GOOGLE_FONT,
			'Jacques Francois Shadow'          => self::GOOGLE_FONT,
			'Jaini'                            => self::GOOGLE_FONT,
			'Jaini Purva'                      => self::GOOGLE_FONT,
			'Jaldi'                            => self::GOOGLE_FONT,
			'Jaro'                             => self::GOOGLE_FONT,
			'Jersey 10'                        => self::GOOGLE_FONT,
			'Jersey 10 Charted'                => self::GOOGLE_FONT,
			'Jersey 15'                        => self::GOOGLE_FONT,
			'Jersey 15 Charted'                => self::GOOGLE_FONT,
			'Jersey 20'                        => self::GOOGLE_FONT,
			'Jersey 20 Charted'                => self::GOOGLE_FONT,
			'Jersey 25'                        => self::GOOGLE_FONT,
			'Jersey 25 Charted'                => self::GOOGLE_FONT,
			'JetBrains Mono'                   => self::GOOGLE_FONT,
			'Jim Nightshade'                   => self::GOOGLE_FONT,
			'Joan'                             => self::GOOGLE_FONT,
			'Jockey One'                       => self::GOOGLE_FONT,
			'Jolly Lodger'                     => self::GOOGLE_FONT,
			'Jomhuria'                         => self::GOOGLE_FONT,
			'Jomolhari'                        => self::GOOGLE_FONT,
			'Josefin Sans'                     => self::GOOGLE_FONT,
			'Josefin Slab'                     => self::GOOGLE_FONT,
			'Jost'                             => self::GOOGLE_FONT,
			'Joti One'                         => self::GOOGLE_FONT,
			'Jua'                              => self::GOOGLE_FONT,
			'Judson'                           => self::GOOGLE_FONT,
			'Julee'                            => self::GOOGLE_FONT,
			'Julius Sans One'                  => self::GOOGLE_FONT,
			'Junge'                            => self::GOOGLE_FONT,
			'Jura'                             => self::GOOGLE_FONT,
			'Just Another Hand'                => self::GOOGLE_FONT,
			'Just Me Again Down Here'          => self::GOOGLE_FONT,
			'K2D'                              => self::GOOGLE_FONT,
			'Kablammo'                         => self::GOOGLE_FONT,
			'Kadwa'                            => self::GOOGLE_FONT,
			'Kaisei Decol'                     => self::GOOGLE_FONT,
			'Kaisei HarunoUmi'                 => self::GOOGLE_FONT,
			'Kaisei Opti'                      => self::GOOGLE_FONT,
			'Kaisei Tokumin'                   => self::GOOGLE_FONT,
			'Kalam'                            => self::GOOGLE_FONT,
			'Kalnia'                           => self::GOOGLE_FONT,
			'Kalnia Glaze'                     => self::GOOGLE_FONT,
			'Kameron'                          => self::GOOGLE_FONT,
			'Kanit'                            => self::GOOGLE_FONT,
			'Kantumruy'                        => self::GOOGLE_FONT,
			'Kantumruy Pro'                    => self::GOOGLE_FONT,
			'Karantina'                        => self::GOOGLE_FONT,
			'Karla'                            => self::GOOGLE_FONT,
			'Karla Tamil Inclined'             => self::GOOGLE_FONT,
			'Karla Tamil Upright'              => self::GOOGLE_FONT,
			'Karma'                            => self::GOOGLE_FONT,
			'Katibeh'                          => self::GOOGLE_FONT,
			'Kaushan Script'                   => self::GOOGLE_FONT,
			'Kavivanar'                        => self::GOOGLE_FONT,
			'Kavoon'                           => self::GOOGLE_FONT,
			'Kdam Thmor'                       => self::GOOGLE_FONT,
			'Kdam Thmor Pro'                   => self::GOOGLE_FONT,
			'Keania One'                       => self::GOOGLE_FONT,
			'Kelly Slab'                       => self::GOOGLE_FONT,
			'Kenia'                            => self::GOOGLE_FONT,
			'Khand'                            => self::GOOGLE_FONT,
			'Khmer'                            => self::GOOGLE_FONT,
			'Khula'                            => self::GOOGLE_FONT,
			'Kings'                            => self::GOOGLE_FONT,
			'Kirang Haerang'                   => self::GOOGLE_FONT,
			'Kite One'                         => self::GOOGLE_FONT,
			'Kiwi Maru'                        => self::GOOGLE_FONT,
			'Klee One'                         => self::GOOGLE_FONT,
			'Knewave'                          => self::GOOGLE_FONT,
			'KoHo'                             => self::GOOGLE_FONT,
			'Kodchasan'                        => self::GOOGLE_FONT,
			'Kode Mono'                        => self::GOOGLE_FONT,
			'Koh Santepheap'                   => self::GOOGLE_FONT,
			'Kolker Brush'                     => self::GOOGLE_FONT,
			'Konkhmer Sleokchher'              => self::GOOGLE_FONT,
			'Kosugi'                           => self::GOOGLE_FONT,
			'Kosugi Maru'                      => self::GOOGLE_FONT,
			'Kotta One'                        => self::GOOGLE_FONT,
			'Koulen'                           => self::GOOGLE_FONT,
			'Kranky'                           => self::GOOGLE_FONT,
			'Kreon'                            => self::GOOGLE_FONT,
			'Kristi'                           => self::GOOGLE_FONT,
			'Krona One'                        => self::GOOGLE_FONT,
			'Krub'                             => self::GOOGLE_FONT,
			'Kufam'                            => self::GOOGLE_FONT,
			'Kulim Park'                       => self::GOOGLE_FONT,
			'Kumar One'                        => self::GOOGLE_FONT,
			'Kumar One Outline'                => self::GOOGLE_FONT,
			'Kumbh Sans'                       => self::GOOGLE_FONT,
			'Kurale'                           => self::GOOGLE_FONT,
			'LXGW WenKai Mono TC'              => self::GOOGLE_FONT,
			'LXGW WenKai TC'                   => self::GOOGLE_FONT,
			'La Belle Aurore'                  => self::GOOGLE_FONT,
			'Labrada'                          => self::GOOGLE_FONT,
			'Lacquer'                          => self::GOOGLE_FONT,
			'Laila'                            => self::GOOGLE_FONT,
			'Lakki Reddy'                      => self::GOOGLE_FONT,
			'Lalezar'                          => self::GOOGLE_FONT,
			'Lancelot'                         => self::GOOGLE_FONT,
			'Langar'                           => self::GOOGLE_FONT,
			'Lateef'                           => self::GOOGLE_FONT,
			'Lato'                             => self::GOOGLE_FONT,
			'Lavishly Yours'                   => self::GOOGLE_FONT,
			'League Gothic'                    => self::GOOGLE_FONT,
			'League Script'                    => self::GOOGLE_FONT,
			'League Spartan'                   => self::GOOGLE_FONT,
			'Leckerli One'                     => self::GOOGLE_FONT,
			'Ledger'                           => self::GOOGLE_FONT,
			'Lekton'                           => self::GOOGLE_FONT,
			'Lemon'                            => self::GOOGLE_FONT,
			'Lemonada'                         => self::GOOGLE_FONT,
			'Lexend'                           => self::GOOGLE_FONT,
			'Lexend Deca'                      => self::GOOGLE_FONT,
			'Lexend Exa'                       => self::GOOGLE_FONT,
			'Lexend Giga'                      => self::GOOGLE_FONT,
			'Lexend Mega'                      => self::GOOGLE_FONT,
			'Lexend Peta'                      => self::GOOGLE_FONT,
			'Lexend Tera'                      => self::GOOGLE_FONT,
			'Lexend Zetta'                     => self::GOOGLE_FONT,
			'Libre Barcode 128'                => self::GOOGLE_FONT,
			'Libre Barcode 128 Text'           => self::GOOGLE_FONT,
			'Libre Barcode 39'                 => self::GOOGLE_FONT,
			'Libre Barcode 39 Extended'        => self::GOOGLE_FONT,
			'Libre Barcode 39 Extended Text'   => self::GOOGLE_FONT,
			'Libre Barcode 39 Text'            => self::GOOGLE_FONT,
			'Libre Barcode EAN13 Text'         => self::GOOGLE_FONT,
			'Libre Baskerville'                => self::GOOGLE_FONT,
			'Libre Bodoni'                     => self::GOOGLE_FONT,
			'Libre Caslon Display'             => self::GOOGLE_FONT,
			'Libre Caslon Text'                => self::GOOGLE_FONT,
			'Libre Franklin'                   => self::GOOGLE_FONT,
			'Licorice'                         => self::GOOGLE_FONT,
			'Life Savers'                      => self::GOOGLE_FONT,
			'Lilita One'                       => self::GOOGLE_FONT,
			'Lily Script One'                  => self::GOOGLE_FONT,
			'Limelight'                        => self::GOOGLE_FONT,
			'Linden Hill'                      => self::GOOGLE_FONT,
			'Linefont'                         => self::GOOGLE_FONT,
			'Lisu Bosa'                        => self::GOOGLE_FONT,
			'Literata'                         => self::GOOGLE_FONT,
			'Liu Jian Mao Cao'                 => self::GOOGLE_FONT,
			'Livvic'                           => self::GOOGLE_FONT,
			'Lobster'                          => self::GOOGLE_FONT,
			'Lobster Two'                      => self::GOOGLE_FONT,
			'Londrina Outline'                 => self::GOOGLE_FONT,
			'Londrina Shadow'                  => self::GOOGLE_FONT,
			'Londrina Sketch'                  => self::GOOGLE_FONT,
			'Londrina Solid'                   => self::GOOGLE_FONT,
			'Long Cang'                        => self::GOOGLE_FONT,
			'Lora'                             => self::GOOGLE_FONT,
			'Love Light'                       => self::GOOGLE_FONT,
			'Love Ya Like A Sister'            => self::GOOGLE_FONT,
			'Loved by the King'                => self::GOOGLE_FONT,
			'Lovers Quarrel'                   => self::GOOGLE_FONT,
			'Luckiest Guy'                     => self::GOOGLE_FONT,
			'Lugrasimo'                        => self::GOOGLE_FONT,
			'Lumanosimo'                       => self::GOOGLE_FONT,
			'Lunasima'                         => self::GOOGLE_FONT,
			'Lusitana'                         => self::GOOGLE_FONT,
			'Lustria'                          => self::GOOGLE_FONT,
			'Luxurious Roman'                  => self::GOOGLE_FONT,
			'Luxurious Script'                 => self::GOOGLE_FONT,
			'M PLUS 1'                         => self::GOOGLE_FONT,
			'M PLUS 1 Code'                    => self::GOOGLE_FONT,
			'M PLUS 1p'                        => self::GOOGLE_FONT,
			'M PLUS 2'                         => self::GOOGLE_FONT,
			'M PLUS Code Latin'                => self::GOOGLE_FONT,
			'M PLUS Rounded 1c'                => self::GOOGLE_FONT,
			'Ma Shan Zheng'                    => self::GOOGLE_FONT,
			'Macondo'                          => self::GOOGLE_FONT,
			'Macondo Swash Caps'               => self::GOOGLE_FONT,
			'Mada'                             => self::GOOGLE_FONT,
			'Madimi One'                       => self::GOOGLE_FONT,
			'Magra'                            => self::GOOGLE_FONT,
			'Maiden Orange'                    => self::GOOGLE_FONT,
			'Maitree'                          => self::GOOGLE_FONT,
			'Major Mono Display'               => self::GOOGLE_FONT,
			'Mako'                             => self::GOOGLE_FONT,
			'Mali'                             => self::GOOGLE_FONT,
			'Mallanna'                         => self::GOOGLE_FONT,
			'Maname'                           => self::GOOGLE_FONT,
			'Mandali'                          => self::GOOGLE_FONT,
			'Manjari'                          => self::GOOGLE_FONT,
			'Manrope'                          => self::GOOGLE_FONT,
			'Mansalva'                         => self::GOOGLE_FONT,
			'Manuale'                          => self::GOOGLE_FONT,
			'Marcellus'                        => self::GOOGLE_FONT,
			'Marcellus SC'                     => self::GOOGLE_FONT,
			'Marck Script'                     => self::GOOGLE_FONT,
			'Margarine'                        => self::GOOGLE_FONT,
			'Marhey'                           => self::GOOGLE_FONT,
			'Markazi Text'                     => self::GOOGLE_FONT,
			'Marko One'                        => self::GOOGLE_FONT,
			'Marmelad'                         => self::GOOGLE_FONT,
			'Martel'                           => self::GOOGLE_FONT,
			'Martel Sans'                      => self::GOOGLE_FONT,
			'Martian Mono'                     => self::GOOGLE_FONT,
			'Marvel'                           => self::GOOGLE_FONT,
			'Mate'                             => self::GOOGLE_FONT,
			'Mate SC'                          => self::GOOGLE_FONT,
			'Matemasie'                        => self::GOOGLE_FONT,
			'Material Icons'                   => self::GOOGLE_FONT,
			'Material Icons Outlined'          => self::GOOGLE_FONT,
			'Material Icons Round'             => self::GOOGLE_FONT,
			'Material Icons Sharp'             => self::GOOGLE_FONT,
			'Material Icons Two Tone'          => self::GOOGLE_FONT,
			'Material Symbols Outlined'        => self::GOOGLE_FONT,
			'Material Symbols Rounded'         => self::GOOGLE_FONT,
			'Material Symbols Sharp'           => self::GOOGLE_FONT,
			'Maven Pro'                        => self::GOOGLE_FONT,
			'McLaren'                          => self::GOOGLE_FONT,
			'Mea Culpa'                        => self::GOOGLE_FONT,
			'Meddon'                           => self::GOOGLE_FONT,
			'MedievalSharp'                    => self::GOOGLE_FONT,
			'Medula One'                       => self::GOOGLE_FONT,
			'Meera Inimai'                     => self::GOOGLE_FONT,
			'Megrim'                           => self::GOOGLE_FONT,
			'Meie Script'                      => self::GOOGLE_FONT,
			'Meow Script'                      => self::GOOGLE_FONT,
			'Merienda'                         => self::GOOGLE_FONT,
			'Merienda One'                     => self::GOOGLE_FONT,
			'Merriweather'                     => self::GOOGLE_FONT,
			'Merriweather Sans'                => self::GOOGLE_FONT,
			'Metal'                            => self::GOOGLE_FONT,
			'Metal Mania'                      => self::GOOGLE_FONT,
			'Metamorphous'                     => self::GOOGLE_FONT,
			'Metrophobic'                      => self::GOOGLE_FONT,
			'Michroma'                         => self::GOOGLE_FONT,
			'Micro 5'                          => self::GOOGLE_FONT,
			'Micro 5 Charted'                  => self::GOOGLE_FONT,
			'Milonga'                          => self::GOOGLE_FONT,
			'Miltonian'                        => self::GOOGLE_FONT,
			'Miltonian Tattoo'                 => self::GOOGLE_FONT,
			'Mina'                             => self::GOOGLE_FONT,
			'Mingzat'                          => self::GOOGLE_FONT,
			'Miniver'                          => self::GOOGLE_FONT,
			'Miriam Libre'                     => self::GOOGLE_FONT,
			'Mirza'                            => self::GOOGLE_FONT,
			'Miss Fajardose'                   => self::GOOGLE_FONT,
			'Mitr'                             => self::GOOGLE_FONT,
			'Mochiy Pop One'                   => self::GOOGLE_FONT,
			'Mochiy Pop P One'                 => self::GOOGLE_FONT,
			'Modak'                            => self::GOOGLE_FONT,
			'Modern Antiqua'                   => self::GOOGLE_FONT,
			'Moderustic'                       => self::GOOGLE_FONT,
			'Mogra'                            => self::GOOGLE_FONT,
			'Mohave'                           => self::GOOGLE_FONT,
			'Moirai One'                       => self::GOOGLE_FONT,
			'Molengo'                          => self::GOOGLE_FONT,
			'Molle'                            => self::GOOGLE_FONT,
			'Mona Sans'                        => self::GOOGLE_FONT,
			'Monda'                            => self::GOOGLE_FONT,
			'Monofett'                         => self::GOOGLE_FONT,
			'Monomaniac One'                   => self::GOOGLE_FONT,
			'Monoton'                          => self::GOOGLE_FONT,
			'Monsieur La Doulaise'             => self::GOOGLE_FONT,
			'Montaga'                          => self::GOOGLE_FONT,
			'Montagu Slab'                     => self::GOOGLE_FONT,
			'MonteCarlo'                       => self::GOOGLE_FONT,
			'Montez'                           => self::GOOGLE_FONT,
			'Montserrat'                       => self::GOOGLE_FONT,
			'Montserrat Alternates'            => self::GOOGLE_FONT,
			'Montserrat Subrayada'             => self::GOOGLE_FONT,
			'Montserrat Underline'             => self::GOOGLE_FONT,
			'Moo Lah Lah'                      => self::GOOGLE_FONT,
			'Mooli'                            => self::GOOGLE_FONT,
			'Moon Dance'                       => self::GOOGLE_FONT,
			'Moul'                             => self::GOOGLE_FONT,
			'Moulpali'                         => self::GOOGLE_FONT,
			'Mountains of Christmas'           => self::GOOGLE_FONT,
			'Mouse Memoirs'                    => self::GOOGLE_FONT,
			'Mr Bedfort'                       => self::GOOGLE_FONT,
			'Mr Dafoe'                         => self::GOOGLE_FONT,
			'Mr De Haviland'                   => self::GOOGLE_FONT,
			'Mrs Saint Delafield'              => self::GOOGLE_FONT,
			'Mrs Sheppards'                    => self::GOOGLE_FONT,
			'Ms Madi'                          => self::GOOGLE_FONT,
			'Mukta'                            => self::GOOGLE_FONT,
			'Mukta Mahee'                      => self::GOOGLE_FONT,
			'Mukta Malar'                      => self::GOOGLE_FONT,
			'Mukta Vaani'                      => self::GOOGLE_FONT,
			'Muli'                             => self::GOOGLE_FONT,
			'Mulish'                           => self::GOOGLE_FONT,
			'Murecho'                          => self::GOOGLE_FONT,
			'MuseoModerno'                     => self::GOOGLE_FONT,
			'My Soul'                          => self::GOOGLE_FONT,
			'Mynerve'                          => self::GOOGLE_FONT,
			'Mystery Quest'                    => self::GOOGLE_FONT,
			'NTR'                              => self::GOOGLE_FONT,
			'Nabla'                            => self::GOOGLE_FONT,
			'Namdhinggo'                       => self::GOOGLE_FONT,
			'Nanum Brush Script'               => self::GOOGLE_FONT,
			'Nanum Gothic'                     => self::GOOGLE_FONT,
			'Nanum Gothic Coding'              => self::GOOGLE_FONT,
			'Nanum Myeongjo'                   => self::GOOGLE_FONT,
			'Nanum Pen Script'                 => self::GOOGLE_FONT,
			'Narnoor'                          => self::GOOGLE_FONT,
			'Neonderthaw'                      => self::GOOGLE_FONT,
			'Nerko One'                        => self::GOOGLE_FONT,
			'Neucha'                           => self::GOOGLE_FONT,
			'Neuton'                           => self::GOOGLE_FONT,
			'New Amsterdam'                    => self::GOOGLE_FONT,
			'New Rocker'                       => self::GOOGLE_FONT,
			'New Tegomin'                      => self::GOOGLE_FONT,
			'News Cycle'                       => self::GOOGLE_FONT,
			'Newsreader'                       => self::GOOGLE_FONT,
			'Niconne'                          => self::GOOGLE_FONT,
			'Niramit'                          => self::GOOGLE_FONT,
			'Nixie One'                        => self::GOOGLE_FONT,
			'Nobile'                           => self::GOOGLE_FONT,
			'Nokora'                           => self::GOOGLE_FONT,
			'Norican'                          => self::GOOGLE_FONT,
			'Nosifer'                          => self::GOOGLE_FONT,
			'Notable'                          => self::GOOGLE_FONT,
			'Nothing You Could Do'             => self::GOOGLE_FONT,
			'Noticia Text'                     => self::GOOGLE_FONT,
			'Noto Color Emoji'                 => self::GOOGLE_FONT,
			'Noto Emoji'                       => self::GOOGLE_FONT,
			'Noto Kufi Arabic'                 => self::GOOGLE_FONT,
			'Noto Music'                       => self::GOOGLE_FONT,
			'Noto Naskh Arabic'                => self::GOOGLE_FONT,
			'Noto Nastaliq Urdu'               => self::GOOGLE_FONT,
			'Noto Rashi Hebrew'                => self::GOOGLE_FONT,
			'Noto Sans'                        => self::GOOGLE_FONT,
			'Noto Sans Adlam'                  => self::GOOGLE_FONT,
			'Noto Sans Adlam Unjoined'         => self::GOOGLE_FONT,
			'Noto Sans Anatolian Hieroglyphs'  => self::GOOGLE_FONT,
			'Noto Sans Arabic'                 => self::GOOGLE_FONT,
			'Noto Sans Armenian'               => self::GOOGLE_FONT,
			'Noto Sans Avestan'                => self::GOOGLE_FONT,
			'Noto Sans Balinese'               => self::GOOGLE_FONT,
			'Noto Sans Bamum'                  => self::GOOGLE_FONT,
			'Noto Sans Bassa Vah'              => self::GOOGLE_FONT,
			'Noto Sans Batak'                  => self::GOOGLE_FONT,
			'Noto Sans Bengali'                => self::GOOGLE_FONT,
			'Noto Sans Bhaiksuki'              => self::GOOGLE_FONT,
			'Noto Sans Brahmi'                 => self::GOOGLE_FONT,
			'Noto Sans Buginese'               => self::GOOGLE_FONT,
			'Noto Sans Buhid'                  => self::GOOGLE_FONT,
			'Noto Sans Canadian Aboriginal'    => self::GOOGLE_FONT,
			'Noto Sans Carian'                 => self::GOOGLE_FONT,
			'Noto Sans Caucasian Albanian'     => self::GOOGLE_FONT,
			'Noto Sans Chakma'                 => self::GOOGLE_FONT,
			'Noto Sans Cham'                   => self::GOOGLE_FONT,
			'Noto Sans Cherokee'               => self::GOOGLE_FONT,
			'Noto Sans Chorasmian'             => self::GOOGLE_FONT,
			'Noto Sans Coptic'                 => self::GOOGLE_FONT,
			'Noto Sans Cuneiform'              => self::GOOGLE_FONT,
			'Noto Sans Cypriot'                => self::GOOGLE_FONT,
			'Noto Sans Cypro Minoan'           => self::GOOGLE_FONT,
			'Noto Sans Deseret'                => self::GOOGLE_FONT,
			'Noto Sans Devanagari'             => self::GOOGLE_FONT,
			'Noto Sans Display'                => self::GOOGLE_FONT,
			'Noto Sans Duployan'               => self::GOOGLE_FONT,
			'Noto Sans Egyptian Hieroglyphs'   => self::GOOGLE_FONT,
			'Noto Sans Elbasan'                => self::GOOGLE_FONT,
			'Noto Sans Elymaic'                => self::GOOGLE_FONT,
			'Noto Sans Ethiopic'               => self::GOOGLE_FONT,
			'Noto Sans Georgian'               => self::GOOGLE_FONT,
			'Noto Sans Glagolitic'             => self::GOOGLE_FONT,
			'Noto Sans Gothic'                 => self::GOOGLE_FONT,
			'Noto Sans Grantha'                => self::GOOGLE_FONT,
			'Noto Sans Gujarati'               => self::GOOGLE_FONT,
			'Noto Sans Gunjala Gondi'          => self::GOOGLE_FONT,
			'Noto Sans Gurmukhi'               => self::GOOGLE_FONT,
			'Noto Sans HK'                     => self::GOOGLE_FONT,
			'Noto Sans Hanifi Rohingya'        => self::GOOGLE_FONT,
			'Noto Sans Hanunoo'                => self::GOOGLE_FONT,
			'Noto Sans Hatran'                 => self::GOOGLE_FONT,
			'Noto Sans Hebrew'                 => self::GOOGLE_FONT,
			'Noto Sans Imperial Aramaic'       => self::GOOGLE_FONT,
			'Noto Sans Indic Siyaq Numbers'    => self::GOOGLE_FONT,
			'Noto Sans Inscriptional Pahlavi'  => self::GOOGLE_FONT,
			'Noto Sans Inscriptional Parthian' => self::GOOGLE_FONT,
			'Noto Sans JP'                     => self::GOOGLE_FONT,
			'Noto Sans Javanese'               => self::GOOGLE_FONT,
			'Noto Sans KR'                     => self::GOOGLE_FONT,
			'Noto Sans Kaithi'                 => self::GOOGLE_FONT,
			'Noto Sans Kannada'                => self::GOOGLE_FONT,
			'Noto Sans Kawi'                   => self::GOOGLE_FONT,
			'Noto Sans Kayah Li'               => self::GOOGLE_FONT,
			'Noto Sans Kharoshthi'             => self::GOOGLE_FONT,
			'Noto Sans Khmer'                  => self::GOOGLE_FONT,
			'Noto Sans Khojki'                 => self::GOOGLE_FONT,
			'Noto Sans Khudawadi'              => self::GOOGLE_FONT,
			'Noto Sans Lao'                    => self::GOOGLE_FONT,
			'Noto Sans Lao Looped'             => self::GOOGLE_FONT,
			'Noto Sans Lepcha'                 => self::GOOGLE_FONT,
			'Noto Sans Limbu'                  => self::GOOGLE_FONT,
			'Noto Sans Linear A'               => self::GOOGLE_FONT,
			'Noto Sans Linear B'               => self::GOOGLE_FONT,
			'Noto Sans Lisu'                   => self::GOOGLE_FONT,
			'Noto Sans Lycian'                 => self::GOOGLE_FONT,
			'Noto Sans Lydian'                 => self::GOOGLE_FONT,
			'Noto Sans Mahajani'               => self::GOOGLE_FONT,
			'Noto Sans Malayalam'              => self::GOOGLE_FONT,
			'Noto Sans Mandaic'                => self::GOOGLE_FONT,
			'Noto Sans Manichaean'             => self::GOOGLE_FONT,
			'Noto Sans Marchen'                => self::GOOGLE_FONT,
			'Noto Sans Masaram Gondi'          => self::GOOGLE_FONT,
			'Noto Sans Math'                   => self::GOOGLE_FONT,
			'Noto Sans Mayan Numerals'         => self::GOOGLE_FONT,
			'Noto Sans Medefaidrin'            => self::GOOGLE_FONT,
			'Noto Sans Meetei Mayek'           => self::GOOGLE_FONT,
			'Noto Sans Mende Kikakui'          => self::GOOGLE_FONT,
			'Noto Sans Meroitic'               => self::GOOGLE_FONT,
			'Noto Sans Miao'                   => self::GOOGLE_FONT,
			'Noto Sans Modi'                   => self::GOOGLE_FONT,
			'Noto Sans Mongolian'              => self::GOOGLE_FONT,
			'Noto Sans Mono'                   => self::GOOGLE_FONT,
			'Noto Sans Mro'                    => self::GOOGLE_FONT,
			'Noto Sans Multani'                => self::GOOGLE_FONT,
			'Noto Sans Myanmar'                => self::GOOGLE_FONT,
			'Noto Sans NKo'                    => self::GOOGLE_FONT,
			'Noto Sans NKo Unjoined'           => self::GOOGLE_FONT,
			'Noto Sans Nabataean'              => self::GOOGLE_FONT,
			'Noto Sans Nag Mundari'            => self::GOOGLE_FONT,
			'Noto Sans Nandinagari'            => self::GOOGLE_FONT,
			'Noto Sans New Tai Lue'            => self::GOOGLE_FONT,
			'Noto Sans Newa'                   => self::GOOGLE_FONT,
			'Noto Sans Nushu'                  => self::GOOGLE_FONT,
			'Noto Sans Ogham'                  => self::GOOGLE_FONT,
			'Noto Sans Ol Chiki'               => self::GOOGLE_FONT,
			'Noto Sans Old Hungarian'          => self::GOOGLE_FONT,
			'Noto Sans Old Italic'             => self::GOOGLE_FONT,
			'Noto Sans Old North Arabian'      => self::GOOGLE_FONT,
			'Noto Sans Old Permic'             => self::GOOGLE_FONT,
			'Noto Sans Old Persian'            => self::GOOGLE_FONT,
			'Noto Sans Old Sogdian'            => self::GOOGLE_FONT,
			'Noto Sans Old South Arabian'      => self::GOOGLE_FONT,
			'Noto Sans Old Turkic'             => self::GOOGLE_FONT,
			'Noto Sans Oriya'                  => self::GOOGLE_FONT,
			'Noto Sans Osage'                  => self::GOOGLE_FONT,
			'Noto Sans Osmanya'                => self::GOOGLE_FONT,
			'Noto Sans Pahawh Hmong'           => self::GOOGLE_FONT,
			'Noto Sans Palmyrene'              => self::GOOGLE_FONT,
			'Noto Sans Pau Cin Hau'            => self::GOOGLE_FONT,
			'Noto Sans Phags Pa'               => self::GOOGLE_FONT,
			'Noto Sans Phoenician'             => self::GOOGLE_FONT,
			'Noto Sans Psalter Pahlavi'        => self::GOOGLE_FONT,
			'Noto Sans Rejang'                 => self::GOOGLE_FONT,
			'Noto Sans Runic'                  => self::GOOGLE_FONT,
			'Noto Sans SC'                     => self::GOOGLE_FONT,
			'Noto Sans Samaritan'              => self::GOOGLE_FONT,
			'Noto Sans Saurashtra'             => self::GOOGLE_FONT,
			'Noto Sans Sharada'                => self::GOOGLE_FONT,
			'Noto Sans Shavian'                => self::GOOGLE_FONT,
			'Noto Sans Siddham'                => self::GOOGLE_FONT,
			'Noto Sans SignWriting'            => self::GOOGLE_FONT,
			'Noto Sans Sinhala'                => self::GOOGLE_FONT,
			'Noto Sans Sogdian'                => self::GOOGLE_FONT,
			'Noto Sans Sora Sompeng'           => self::GOOGLE_FONT,
			'Noto Sans Soyombo'                => self::GOOGLE_FONT,
			'Noto Sans Sundanese'              => self::GOOGLE_FONT,
			'Noto Sans Syloti Nagri'           => self::GOOGLE_FONT,
			'Noto Sans Symbols'                => self::GOOGLE_FONT,
			'Noto Sans Symbols 2'              => self::GOOGLE_FONT,
			'Noto Sans Syriac'                 => self::GOOGLE_FONT,
			'Noto Sans Syriac Eastern'         => self::GOOGLE_FONT,
			'Noto Sans TC'                     => self::GOOGLE_FONT,
			'Noto Sans Tagalog'                => self::GOOGLE_FONT,
			'Noto Sans Tagbanwa'               => self::GOOGLE_FONT,
			'Noto Sans Tai Le'                 => self::GOOGLE_FONT,
			'Noto Sans Tai Tham'               => self::GOOGLE_FONT,
			'Noto Sans Tai Viet'               => self::GOOGLE_FONT,
			'Noto Sans Takri'                  => self::GOOGLE_FONT,
			'Noto Sans Tamil'                  => self::GOOGLE_FONT,
			'Noto Sans Tamil Supplement'       => self::GOOGLE_FONT,
			'Noto Sans Tangsa'                 => self::GOOGLE_FONT,
			'Noto Sans Telugu'                 => self::GOOGLE_FONT,
			'Noto Sans Thaana'                 => self::GOOGLE_FONT,
			'Noto Sans Thai'                   => self::GOOGLE_FONT,
			'Noto Sans Thai Looped'            => self::GOOGLE_FONT,
			'Noto Sans Tifinagh'               => self::GOOGLE_FONT,
			'Noto Sans Tirhuta'                => self::GOOGLE_FONT,
			'Noto Sans Ugaritic'               => self::GOOGLE_FONT,
			'Noto Sans Vai'                    => self::GOOGLE_FONT,
			'Noto Sans Vithkuqi'               => self::GOOGLE_FONT,
			'Noto Sans Wancho'                 => self::GOOGLE_FONT,
			'Noto Sans Warang Citi'            => self::GOOGLE_FONT,
			'Noto Sans Yi'                     => self::GOOGLE_FONT,
			'Noto Sans Zanabazar Square'       => self::GOOGLE_FONT,
			'Noto Serif'                       => self::GOOGLE_FONT,
			'Noto Serif Ahom'                  => self::GOOGLE_FONT,
			'Noto Serif Armenian'              => self::GOOGLE_FONT,
			'Noto Serif Balinese'              => self::GOOGLE_FONT,
			'Noto Serif Bengali'               => self::GOOGLE_FONT,
			'Noto Serif Devanagari'            => self::GOOGLE_FONT,
			'Noto Serif Display'               => self::GOOGLE_FONT,
			'Noto Serif Dogra'                 => self::GOOGLE_FONT,
			'Noto Serif Ethiopic'              => self::GOOGLE_FONT,
			'Noto Serif Georgian'              => self::GOOGLE_FONT,
			'Noto Serif Grantha'               => self::GOOGLE_FONT,
			'Noto Serif Gujarati'              => self::GOOGLE_FONT,
			'Noto Serif Gurmukhi'              => self::GOOGLE_FONT,
			'Noto Serif HK'                    => self::GOOGLE_FONT,
			'Noto Serif Hebrew'                => self::GOOGLE_FONT,
			'Noto Serif JP'                    => self::GOOGLE_FONT,
			'Noto Serif KR'                    => self::GOOGLE_FONT,
			'Noto Serif Kannada'               => self::GOOGLE_FONT,
			'Noto Serif Khitan Small Script'   => self::GOOGLE_FONT,
			'Noto Serif Khmer'                 => self::GOOGLE_FONT,
			'Noto Serif Khojki'                => self::GOOGLE_FONT,
			'Noto Serif Lao'                   => self::GOOGLE_FONT,
			'Noto Serif Makasar'               => self::GOOGLE_FONT,
			'Noto Serif Malayalam'             => self::GOOGLE_FONT,
			'Noto Serif Myanmar'               => self::GOOGLE_FONT,
			'Noto Serif NP Hmong'              => self::GOOGLE_FONT,
			'Noto Serif Old Uyghur'            => self::GOOGLE_FONT,
			'Noto Serif Oriya'                 => self::GOOGLE_FONT,
			'Noto Serif Ottoman Siyaq'         => self::GOOGLE_FONT,
			'Noto Serif SC'                    => self::GOOGLE_FONT,
			'Noto Serif Sinhala'               => self::GOOGLE_FONT,
			'Noto Serif TC'                    => self::GOOGLE_FONT,
			'Noto Serif Tamil'                 => self::GOOGLE_FONT,
			'Noto Serif Tangut'                => self::GOOGLE_FONT,
			'Noto Serif Telugu'                => self::GOOGLE_FONT,
			'Noto Serif Thai'                  => self::GOOGLE_FONT,
			'Noto Serif Tibetan'               => self::GOOGLE_FONT,
			'Noto Serif Toto'                  => self::GOOGLE_FONT,
			'Noto Serif Vithkuqi'              => self::GOOGLE_FONT,
			'Noto Serif Yezidi'                => self::GOOGLE_FONT,
			'Noto Traditional Nushu'           => self::GOOGLE_FONT,
			'Noto Znamenny Musical Notation'   => self::GOOGLE_FONT,
			'Nova Cut'                         => self::GOOGLE_FONT,
			'Nova Flat'                        => self::GOOGLE_FONT,
			'Nova Mono'                        => self::GOOGLE_FONT,
			'Nova Oval'                        => self::GOOGLE_FONT,
			'Nova Round'                       => self::GOOGLE_FONT,
			'Nova Script'                      => self::GOOGLE_FONT,
			'Nova Slim'                        => self::GOOGLE_FONT,
			'Nova Square'                      => self::GOOGLE_FONT,
			'Numans'                           => self::GOOGLE_FONT,
			'Nunito'                           => self::GOOGLE_FONT,
			'Nunito Sans'                      => self::GOOGLE_FONT,
			'Nuosu SIL'                        => self::GOOGLE_FONT,
			'Odibee Sans'                      => self::GOOGLE_FONT,
			'Odor Mean Chey'                   => self::GOOGLE_FONT,
			'Offside'                          => self::GOOGLE_FONT,
			'Oi'                               => self::GOOGLE_FONT,
			'Ojuju'                            => self::GOOGLE_FONT,
			'Old Standard TT'                  => self::GOOGLE_FONT,
			'Oldenburg'                        => self::GOOGLE_FONT,
			'Ole'                              => self::GOOGLE_FONT,
			'Oleo Script'                      => self::GOOGLE_FONT,
			'Oleo Script Swash Caps'           => self::GOOGLE_FONT,
			'Onest'                            => self::GOOGLE_FONT,
			'Oooh Baby'                        => self::GOOGLE_FONT,
			'Open Sans'                        => self::GOOGLE_FONT,
			'Open Sans Condensed'              => self::GOOGLE_FONT,
			'Oranienbaum'                      => self::GOOGLE_FONT,
			'Orbit'                            => self::GOOGLE_FONT,
			'Orbitron'                         => self::GOOGLE_FONT,
			'Oregano'                          => self::GOOGLE_FONT,
			'Orelega One'                      => self::GOOGLE_FONT,
			'Orienta'                          => self::GOOGLE_FONT,
			'Original Surfer'                  => self::GOOGLE_FONT,
			'Oswald'                           => self::GOOGLE_FONT,
			'Outfit'                           => self::GOOGLE_FONT,
			'Over the Rainbow'                 => self::GOOGLE_FONT,
			'Overlock'                         => self::GOOGLE_FONT,
			'Overlock SC'                      => self::GOOGLE_FONT,
			'Overpass'                         => self::GOOGLE_FONT,
			'Overpass Mono'                    => self::GOOGLE_FONT,
			'Ovo'                              => self::GOOGLE_FONT,
			'Oxanium'                          => self::GOOGLE_FONT,
			'Oxygen'                           => self::GOOGLE_FONT,
			'Oxygen Mono'                      => self::GOOGLE_FONT,
			'PT Mono'                          => self::GOOGLE_FONT,
			'PT Sans'                          => self::GOOGLE_FONT,
			'PT Sans Caption'                  => self::GOOGLE_FONT,
			'PT Sans Narrow'                   => self::GOOGLE_FONT,
			'PT Serif'                         => self::GOOGLE_FONT,
			'PT Serif Caption'                 => self::GOOGLE_FONT,
			'Pacifico'                         => self::GOOGLE_FONT,
			'Padauk'                           => self::GOOGLE_FONT,
			'Padyakke Expanded One'            => self::GOOGLE_FONT,
			'Palanquin'                        => self::GOOGLE_FONT,
			'Palanquin Dark'                   => self::GOOGLE_FONT,
			'Palette Mosaic'                   => self::GOOGLE_FONT,
			'Pangolin'                         => self::GOOGLE_FONT,
			'Paprika'                          => self::GOOGLE_FONT,
			'Parisienne'                       => self::GOOGLE_FONT,
			'Parkinsans'                       => self::GOOGLE_FONT,
			'Passero One'                      => self::GOOGLE_FONT,
			'Passion One'                      => self::GOOGLE_FONT,
			'Passions Conflict'                => self::GOOGLE_FONT,
			'Pathway Extreme'                  => self::GOOGLE_FONT,
			'Pathway Gothic One'               => self::GOOGLE_FONT,
			'Patrick Hand'                     => self::GOOGLE_FONT,
			'Patrick Hand SC'                  => self::GOOGLE_FONT,
			'Pattaya'                          => self::GOOGLE_FONT,
			'Patua One'                        => self::GOOGLE_FONT,
			'Pavanam'                          => self::GOOGLE_FONT,
			'Paytone One'                      => self::GOOGLE_FONT,
			'Peddana'                          => self::GOOGLE_FONT,
			'Peralta'                          => self::GOOGLE_FONT,
			'Permanent Marker'                 => self::GOOGLE_FONT,
			'Petemoss'                         => self::GOOGLE_FONT,
			'Petit Formal Script'              => self::GOOGLE_FONT,
			'Petrona'                          => self::GOOGLE_FONT,
			'Phetsarath'                       => self::GOOGLE_FONT,
			'Philosopher'                      => self::GOOGLE_FONT,
			'Phudu'                            => self::GOOGLE_FONT,
			'Piazzolla'                        => self::GOOGLE_FONT,
			'Piedra'                           => self::GOOGLE_FONT,
			'Pinyon Script'                    => self::GOOGLE_FONT,
			'Pirata One'                       => self::GOOGLE_FONT,
			'Pixelify Sans'                    => self::GOOGLE_FONT,
			'Plaster'                          => self::GOOGLE_FONT,
			'Platypi'                          => self::GOOGLE_FONT,
			'Play'                             => self::GOOGLE_FONT,
			'Playball'                         => self::GOOGLE_FONT,
			'Playfair'                         => self::GOOGLE_FONT,
			'Playfair Display'                 => self::GOOGLE_FONT,
			'Playfair Display SC'              => self::GOOGLE_FONT,
			'Playpen Sans'                     => self::GOOGLE_FONT,
			'Playwrite AR'                     => self::GOOGLE_FONT,
			'Playwrite AR Guides'              => self::GOOGLE_FONT,
			'Playwrite AT'                     => self::GOOGLE_FONT,
			'Playwrite AT Guides'              => self::GOOGLE_FONT,
			'Playwrite AU NSW'                 => self::GOOGLE_FONT,
			'Playwrite AU NSW Guides'          => self::GOOGLE_FONT,
			'Playwrite AU QLD'                 => self::GOOGLE_FONT,
			'Playwrite AU QLD Guides'          => self::GOOGLE_FONT,
			'Playwrite AU SA'                  => self::GOOGLE_FONT,
			'Playwrite AU SA Guides'           => self::GOOGLE_FONT,
			'Playwrite AU TAS'                 => self::GOOGLE_FONT,
			'Playwrite AU TAS Guides'          => self::GOOGLE_FONT,
			'Playwrite AU VIC'                 => self::GOOGLE_FONT,
			'Playwrite AU VIC Guides'          => self::GOOGLE_FONT,
			'Playwrite BE VLG'                 => self::GOOGLE_FONT,
			'Playwrite BE VLG Guides'          => self::GOOGLE_FONT,
			'Playwrite BE WAL'                 => self::GOOGLE_FONT,
			'Playwrite BE WAL Guides'          => self::GOOGLE_FONT,
			'Playwrite BR'                     => self::GOOGLE_FONT,
			'Playwrite BR Guides'              => self::GOOGLE_FONT,
			'Playwrite CA'                     => self::GOOGLE_FONT,
			'Playwrite CA Guides'              => self::GOOGLE_FONT,
			'Playwrite CL'                     => self::GOOGLE_FONT,
			'Playwrite CL Guides'              => self::GOOGLE_FONT,
			'Playwrite CO'                     => self::GOOGLE_FONT,
			'Playwrite CO Guides'              => self::GOOGLE_FONT,
			'Playwrite CU'                     => self::GOOGLE_FONT,
			'Playwrite CU Guides'              => self::GOOGLE_FONT,
			'Playwrite CZ'                     => self::GOOGLE_FONT,
			'Playwrite CZ Guides'              => self::GOOGLE_FONT,
			'Playwrite DE Grund'               => self::GOOGLE_FONT,
			'Playwrite DE Grund Guides'        => self::GOOGLE_FONT,
			'Playwrite DE LA'                  => self::GOOGLE_FONT,
			'Playwrite DE LA Guides'           => self::GOOGLE_FONT,
			'Playwrite DE SAS'                 => self::GOOGLE_FONT,
			'Playwrite DE SAS Guides'          => self::GOOGLE_FONT,
			'Playwrite DE VA'                  => self::GOOGLE_FONT,
			'Playwrite DE VA Guides'           => self::GOOGLE_FONT,
			'Playwrite DK Loopet'              => self::GOOGLE_FONT,
			'Playwrite DK Loopet Guides'       => self::GOOGLE_FONT,
			'Playwrite DK Uloopet'             => self::GOOGLE_FONT,
			'Playwrite DK Uloopet Guides'      => self::GOOGLE_FONT,
			'Playwrite ES'                     => self::GOOGLE_FONT,
			'Playwrite ES Deco'                => self::GOOGLE_FONT,
			'Playwrite ES Deco Guides'         => self::GOOGLE_FONT,
			'Playwrite ES Guides'              => self::GOOGLE_FONT,
			'Playwrite FR Moderne'             => self::GOOGLE_FONT,
			'Playwrite FR Moderne Guides'      => self::GOOGLE_FONT,
			'Playwrite FR Trad'                => self::GOOGLE_FONT,
			'Playwrite FR Trad Guides'         => self::GOOGLE_FONT,
			'Playwrite GB J'                   => self::GOOGLE_FONT,
			'Playwrite GB J Guides'            => self::GOOGLE_FONT,
			'Playwrite GB S'                   => self::GOOGLE_FONT,
			'Playwrite GB S Guides'            => self::GOOGLE_FONT,
			'Playwrite HR'                     => self::GOOGLE_FONT,
			'Playwrite HR Guides'              => self::GOOGLE_FONT,
			'Playwrite HR Lijeva'              => self::GOOGLE_FONT,
			'Playwrite HR Lijeva Guides'       => self::GOOGLE_FONT,
			'Playwrite HU'                     => self::GOOGLE_FONT,
			'Playwrite HU Guides'              => self::GOOGLE_FONT,
			'Playwrite ID'                     => self::GOOGLE_FONT,
			'Playwrite ID Guides'              => self::GOOGLE_FONT,
			'Playwrite IE'                     => self::GOOGLE_FONT,
			'Playwrite IE Guides'              => self::GOOGLE_FONT,
			'Playwrite IN'                     => self::GOOGLE_FONT,
			'Playwrite IN Guides'              => self::GOOGLE_FONT,
			'Playwrite IS'                     => self::GOOGLE_FONT,
			'Playwrite IS Guides'              => self::GOOGLE_FONT,
			'Playwrite IT Moderna'             => self::GOOGLE_FONT,
			'Playwrite IT Moderna Guides'      => self::GOOGLE_FONT,
			'Playwrite IT Trad'                => self::GOOGLE_FONT,
			'Playwrite IT Trad Guides'         => self::GOOGLE_FONT,
			'Playwrite MX'                     => self::GOOGLE_FONT,
			'Playwrite MX Guides'              => self::GOOGLE_FONT,
			'Playwrite NG Modern'              => self::GOOGLE_FONT,
			'Playwrite NG Modern Guides'       => self::GOOGLE_FONT,
			'Playwrite NL'                     => self::GOOGLE_FONT,
			'Playwrite NL Guides'              => self::GOOGLE_FONT,
			'Playwrite NO'                     => self::GOOGLE_FONT,
			'Playwrite NO Guides'              => self::GOOGLE_FONT,
			'Playwrite NZ'                     => self::GOOGLE_FONT,
			'Playwrite NZ Guides'              => self::GOOGLE_FONT,
			'Playwrite PE'                     => self::GOOGLE_FONT,
			'Playwrite PE Guides'              => self::GOOGLE_FONT,
			'Playwrite PL'                     => self::GOOGLE_FONT,
			'Playwrite PL Guides'              => self::GOOGLE_FONT,
			'Playwrite PT'                     => self::GOOGLE_FONT,
			'Playwrite PT Guides'              => self::GOOGLE_FONT,
			'Playwrite RO'                     => self::GOOGLE_FONT,
			'Playwrite RO Guides'              => self::GOOGLE_FONT,
			'Playwrite SK'                     => self::GOOGLE_FONT,
			'Playwrite SK Guides'              => self::GOOGLE_FONT,
			'Playwrite TZ'                     => self::GOOGLE_FONT,
			'Playwrite TZ Guides'              => self::GOOGLE_FONT,
			'Playwrite US Modern'              => self::GOOGLE_FONT,
			'Playwrite US Modern Guides'       => self::GOOGLE_FONT,
			'Playwrite US Trad'                => self::GOOGLE_FONT,
			'Playwrite US Trad Guides'         => self::GOOGLE_FONT,
			'Playwrite VN'                     => self::GOOGLE_FONT,
			'Playwrite VN Guides'              => self::GOOGLE_FONT,
			'Playwrite ZA'                     => self::GOOGLE_FONT,
			'Playwrite ZA Guides'              => self::GOOGLE_FONT,
			'Plus Jakarta Sans'                => self::GOOGLE_FONT,
			'Podkova'                          => self::GOOGLE_FONT,
			'Poetsen One'                      => self::GOOGLE_FONT,
			'Poiret One'                       => self::GOOGLE_FONT,
			'Poller One'                       => self::GOOGLE_FONT,
			'Poltawski Nowy'                   => self::GOOGLE_FONT,
			'Poly'                             => self::GOOGLE_FONT,
			'Pompiere'                         => self::GOOGLE_FONT,
			'Ponnala'                          => self::GOOGLE_FONT,
			'Pontano Sans'                     => self::GOOGLE_FONT,
			'Poor Story'                       => self::GOOGLE_FONT,
			'Poppins'                          => self::GOOGLE_FONT,
			'Port Lligat Sans'                 => self::GOOGLE_FONT,
			'Port Lligat Slab'                 => self::GOOGLE_FONT,
			'Potta One'                        => self::GOOGLE_FONT,
			'Pragati Narrow'                   => self::GOOGLE_FONT,
			'Praise'                           => self::GOOGLE_FONT,
			'Prata'                            => self::GOOGLE_FONT,
			'Preahvihear'                      => self::GOOGLE_FONT,
			'Press Start 2P'                   => self::GOOGLE_FONT,
			'Pridi'                            => self::GOOGLE_FONT,
			'Princess Sofia'                   => self::GOOGLE_FONT,
			'Prociono'                         => self::GOOGLE_FONT,
			'Prompt'                           => self::GOOGLE_FONT,
			'Prosto One'                       => self::GOOGLE_FONT,
			'Protest Guerrilla'                => self::GOOGLE_FONT,
			'Protest Revolution'               => self::GOOGLE_FONT,
			'Protest Riot'                     => self::GOOGLE_FONT,
			'Protest Strike'                   => self::GOOGLE_FONT,
			'Proza Libre'                      => self::GOOGLE_FONT,
			'Public Sans'                      => self::GOOGLE_FONT,
			'Puppies Play'                     => self::GOOGLE_FONT,
			'Puritan'                          => self::GOOGLE_FONT,
			'Purple Purse'                     => self::GOOGLE_FONT,
			'Qahiri'                           => self::GOOGLE_FONT,
			'Quando'                           => self::GOOGLE_FONT,
			'Quantico'                         => self::GOOGLE_FONT,
			'Quattrocento'                     => self::GOOGLE_FONT,
			'Quattrocento Sans'                => self::GOOGLE_FONT,
			'Questrial'                        => self::GOOGLE_FONT,
			'Quicksand'                        => self::GOOGLE_FONT,
			'Quintessential'                   => self::GOOGLE_FONT,
			'Qwigley'                          => self::GOOGLE_FONT,
			'Qwitcher Grypen'                  => self::GOOGLE_FONT,
			'REM'                              => self::GOOGLE_FONT,
			'Racing Sans One'                  => self::GOOGLE_FONT,
			'Radio Canada'                     => self::GOOGLE_FONT,
			'Radio Canada Big'                 => self::GOOGLE_FONT,
			'Radley'                           => self::GOOGLE_FONT,
			'Rajdhani'                         => self::GOOGLE_FONT,
			'Rakkas'                           => self::GOOGLE_FONT,
			'Raleway'                          => self::GOOGLE_FONT,
			'Raleway Dots'                     => self::GOOGLE_FONT,
			'Ramabhadra'                       => self::GOOGLE_FONT,
			'Ramaraja'                         => self::GOOGLE_FONT,
			'Rambla'                           => self::GOOGLE_FONT,
			'Rammetto One'                     => self::GOOGLE_FONT,
			'Rampart One'                      => self::GOOGLE_FONT,
			'Ranchers'                         => self::GOOGLE_FONT,
			'Rancho'                           => self::GOOGLE_FONT,
			'Ranga'                            => self::GOOGLE_FONT,
			'Rasa'                             => self::GOOGLE_FONT,
			'Rationale'                        => self::GOOGLE_FONT,
			'Ravi Prakash'                     => self::GOOGLE_FONT,
			'Readex Pro'                       => self::GOOGLE_FONT,
			'Recursive'                        => self::GOOGLE_FONT,
			'Red Hat Display'                  => self::GOOGLE_FONT,
			'Red Hat Mono'                     => self::GOOGLE_FONT,
			'Red Hat Text'                     => self::GOOGLE_FONT,
			'Red Rose'                         => self::GOOGLE_FONT,
			'Redacted'                         => self::GOOGLE_FONT,
			'Redacted Script'                  => self::GOOGLE_FONT,
			'Reddit Mono'                      => self::GOOGLE_FONT,
			'Reddit Sans'                      => self::GOOGLE_FONT,
			'Reddit Sans Condensed'            => self::GOOGLE_FONT,
			'Redressed'                        => self::GOOGLE_FONT,
			'Reem Kufi'                        => self::GOOGLE_FONT,
			'Reem Kufi Fun'                    => self::GOOGLE_FONT,
			'Reem Kufi Ink'                    => self::GOOGLE_FONT,
			'Reenie Beanie'                    => self::GOOGLE_FONT,
			'Reggae One'                       => self::GOOGLE_FONT,
			'Rethink Sans'                     => self::GOOGLE_FONT,
			'Revalia'                          => self::GOOGLE_FONT,
			'Rhodium Libre'                    => self::GOOGLE_FONT,
			'Ribeye'                           => self::GOOGLE_FONT,
			'Ribeye Marrow'                    => self::GOOGLE_FONT,
			'Righteous'                        => self::GOOGLE_FONT,
			'Risque'                           => self::GOOGLE_FONT,
			'Road Rage'                        => self::GOOGLE_FONT,
			'Roboto'                           => self::GOOGLE_FONT,
			'Roboto Condensed'                 => self::GOOGLE_FONT,
			'Roboto Flex'                      => self::GOOGLE_FONT,
			'Roboto Mono'                      => self::GOOGLE_FONT,
			'Roboto Serif'                     => self::GOOGLE_FONT,
			'Roboto Slab'                      => self::GOOGLE_FONT,
			'Rochester'                        => self::GOOGLE_FONT,
			'Rock 3D'                          => self::GOOGLE_FONT,
			'Rock Salt'                        => self::GOOGLE_FONT,
			'RocknRoll One'                    => self::GOOGLE_FONT,
			'Rokkitt'                          => self::GOOGLE_FONT,
			'Romanesco'                        => self::GOOGLE_FONT,
			'Ropa Sans'                        => self::GOOGLE_FONT,
			'Rosario'                          => self::GOOGLE_FONT,
			'Rosarivo'                         => self::GOOGLE_FONT,
			'Rouge Script'                     => self::GOOGLE_FONT,
			'Rowdies'                          => self::GOOGLE_FONT,
			'Rozha One'                        => self::GOOGLE_FONT,
			'Rubik'                            => self::GOOGLE_FONT,
			'Rubik 80s Fade'                   => self::GOOGLE_FONT,
			'Rubik Beastly'                    => self::GOOGLE_FONT,
			'Rubik Broken Fax'                 => self::GOOGLE_FONT,
			'Rubik Bubbles'                    => self::GOOGLE_FONT,
			'Rubik Burned'                     => self::GOOGLE_FONT,
			'Rubik Dirt'                       => self::GOOGLE_FONT,
			'Rubik Distressed'                 => self::GOOGLE_FONT,
			'Rubik Doodle Shadow'              => self::GOOGLE_FONT,
			'Rubik Doodle Triangles'           => self::GOOGLE_FONT,
			'Rubik Gemstones'                  => self::GOOGLE_FONT,
			'Rubik Glitch'                     => self::GOOGLE_FONT,
			'Rubik Glitch Pop'                 => self::GOOGLE_FONT,
			'Rubik Iso'                        => self::GOOGLE_FONT,
			'Rubik Lines'                      => self::GOOGLE_FONT,
			'Rubik Maps'                       => self::GOOGLE_FONT,
			'Rubik Marker Hatch'               => self::GOOGLE_FONT,
			'Rubik Maze'                       => self::GOOGLE_FONT,
			'Rubik Microbe'                    => self::GOOGLE_FONT,
			'Rubik Mono One'                   => self::GOOGLE_FONT,
			'Rubik Moonrocks'                  => self::GOOGLE_FONT,
			'Rubik Pixels'                     => self::GOOGLE_FONT,
			'Rubik Puddles'                    => self::GOOGLE_FONT,
			'Rubik Scribble'                   => self::GOOGLE_FONT,
			'Rubik Spray Paint'                => self::GOOGLE_FONT,
			'Rubik Storm'                      => self::GOOGLE_FONT,
			'Rubik Vinyl'                      => self::GOOGLE_FONT,
			'Rubik Wet Paint'                  => self::GOOGLE_FONT,
			'Ruda'                             => self::GOOGLE_FONT,
			'Rufina'                           => self::GOOGLE_FONT,
			'Ruge Boogie'                      => self::GOOGLE_FONT,
			'Ruluko'                           => self::GOOGLE_FONT,
			'Rum Raisin'                       => self::GOOGLE_FONT,
			'Ruslan Display'                   => self::GOOGLE_FONT,
			'Russo One'                        => self::GOOGLE_FONT,
			'Ruthie'                           => self::GOOGLE_FONT,
			'Ruwudu'                           => self::GOOGLE_FONT,
			'Rye'                              => self::GOOGLE_FONT,
			'STIX Two Text'                    => self::GOOGLE_FONT,
			'SUSE'                             => self::GOOGLE_FONT,
			'Sacramento'                       => self::GOOGLE_FONT,
			'Sahitya'                          => self::GOOGLE_FONT,
			'Sail'                             => self::GOOGLE_FONT,
			'Saira'                            => self::GOOGLE_FONT,
			'Saira Condensed'                  => self::GOOGLE_FONT,
			'Saira Extra Condensed'            => self::GOOGLE_FONT,
			'Saira Semi Condensed'             => self::GOOGLE_FONT,
			'Saira Stencil One'                => self::GOOGLE_FONT,
			'Salsa'                            => self::GOOGLE_FONT,
			'Sanchez'                          => self::GOOGLE_FONT,
			'Sancreek'                         => self::GOOGLE_FONT,
			'Sankofa Display'                  => self::GOOGLE_FONT,
			'Sansita'                          => self::GOOGLE_FONT,
			'Sansita Swashed'                  => self::GOOGLE_FONT,
			'Sarabun'                          => self::GOOGLE_FONT,
			'Sarala'                           => self::GOOGLE_FONT,
			'Sarina'                           => self::GOOGLE_FONT,
			'Sarpanch'                         => self::GOOGLE_FONT,
			'Sassy Frass'                      => self::GOOGLE_FONT,
			'Satisfy'                          => self::GOOGLE_FONT,
			'Sawarabi Gothic'                  => self::GOOGLE_FONT,
			'Sawarabi Mincho'                  => self::GOOGLE_FONT,
			'Scada'                            => self::GOOGLE_FONT,
			'Scheherazade'                     => self::GOOGLE_FONT,
			'Scheherazade New'                 => self::GOOGLE_FONT,
			'Schibsted Grotesk'                => self::GOOGLE_FONT,
			'Schoolbell'                       => self::GOOGLE_FONT,
			'Scope One'                        => self::GOOGLE_FONT,
			'Seaweed Script'                   => self::GOOGLE_FONT,
			'Secular One'                      => self::GOOGLE_FONT,
			'Sedan'                            => self::GOOGLE_FONT,
			'Sedan SC'                         => self::GOOGLE_FONT,
			'Sedgwick Ave'                     => self::GOOGLE_FONT,
			'Sedgwick Ave Display'             => self::GOOGLE_FONT,
			'Sen'                              => self::GOOGLE_FONT,
			'Send Flowers'                     => self::GOOGLE_FONT,
			'Sevillana'                        => self::GOOGLE_FONT,
			'Seymour One'                      => self::GOOGLE_FONT,
			'Shadows Into Light'               => self::GOOGLE_FONT,
			'Shadows Into Light Two'           => self::GOOGLE_FONT,
			'Shalimar'                         => self::GOOGLE_FONT,
			'Shantell Sans'                    => self::GOOGLE_FONT,
			'Shanti'                           => self::GOOGLE_FONT,
			'Share'                            => self::GOOGLE_FONT,
			'Share Tech'                       => self::GOOGLE_FONT,
			'Share Tech Mono'                  => self::GOOGLE_FONT,
			'Shippori Antique'                 => self::GOOGLE_FONT,
			'Shippori Antique B1'              => self::GOOGLE_FONT,
			'Shippori Mincho'                  => self::GOOGLE_FONT,
			'Shippori Mincho B1'               => self::GOOGLE_FONT,
			'Shizuru'                          => self::GOOGLE_FONT,
			'Shojumaru'                        => self::GOOGLE_FONT,
			'Short Stack'                      => self::GOOGLE_FONT,
			'Shrikhand'                        => self::GOOGLE_FONT,
			'Siemreap'                         => self::GOOGLE_FONT,
			'Sigmar'                           => self::GOOGLE_FONT,
			'Sigmar One'                       => self::GOOGLE_FONT,
			'Signika'                          => self::GOOGLE_FONT,
			'Signika Negative'                 => self::GOOGLE_FONT,
			'Silkscreen'                       => self::GOOGLE_FONT,
			'Simonetta'                        => self::GOOGLE_FONT,
			'Single Day'                       => self::GOOGLE_FONT,
			'Sintony'                          => self::GOOGLE_FONT,
			'Sirin Stencil'                    => self::GOOGLE_FONT,
			'Six Caps'                         => self::GOOGLE_FONT,
			'Sixtyfour'                        => self::GOOGLE_FONT,
			'Sixtyfour Convergence'            => self::GOOGLE_FONT,
			'Skranji'                          => self::GOOGLE_FONT,
			'Slabo 13px'                       => self::GOOGLE_FONT,
			'Slabo 27px'                       => self::GOOGLE_FONT,
			'Slackey'                          => self::GOOGLE_FONT,
			'Slackside One'                    => self::GOOGLE_FONT,
			'Smokum'                           => self::GOOGLE_FONT,
			'Smooch'                           => self::GOOGLE_FONT,
			'Smooch Sans'                      => self::GOOGLE_FONT,
			'Smythe'                           => self::GOOGLE_FONT,
			'Sniglet'                          => self::GOOGLE_FONT,
			'Snippet'                          => self::GOOGLE_FONT,
			'Snowburst One'                    => self::GOOGLE_FONT,
			'Sofadi One'                       => self::GOOGLE_FONT,
			'Sofia'                            => self::GOOGLE_FONT,
			'Sofia Sans'                       => self::GOOGLE_FONT,
			'Sofia Sans Condensed'             => self::GOOGLE_FONT,
			'Sofia Sans Extra Condensed'       => self::GOOGLE_FONT,
			'Sofia Sans Semi Condensed'        => self::GOOGLE_FONT,
			'Solitreo'                         => self::GOOGLE_FONT,
			'Solway'                           => self::GOOGLE_FONT,
			'Sometype Mono'                    => self::GOOGLE_FONT,
			'Song Myung'                       => self::GOOGLE_FONT,
			'Sono'                             => self::GOOGLE_FONT,
			'Sonsie One'                       => self::GOOGLE_FONT,
			'Sora'                             => self::GOOGLE_FONT,
			'Sorts Mill Goudy'                 => self::GOOGLE_FONT,
			'Sour Gummy'                       => self::GOOGLE_FONT,
			'Source Code Pro'                  => self::GOOGLE_FONT,
			'Source Sans 3'                    => self::GOOGLE_FONT,
			'Source Sans Pro'                  => self::GOOGLE_FONT,
			'Source Serif 4'                   => self::GOOGLE_FONT,
			'Source Serif Pro'                 => self::GOOGLE_FONT,
			'Space Grotesk'                    => self::GOOGLE_FONT,
			'Space Mono'                       => self::GOOGLE_FONT,
			'Special Elite'                    => self::GOOGLE_FONT,
			'Spectral'                         => self::GOOGLE_FONT,
			'Spectral SC'                      => self::GOOGLE_FONT,
			'Spicy Rice'                       => self::GOOGLE_FONT,
			'Spinnaker'                        => self::GOOGLE_FONT,
			'Spirax'                           => self::GOOGLE_FONT,
			'Splash'                           => self::GOOGLE_FONT,
			'Spline Sans'                      => self::GOOGLE_FONT,
			'Spline Sans Mono'                 => self::GOOGLE_FONT,
			'Squada One'                       => self::GOOGLE_FONT,
			'Square Peg'                       => self::GOOGLE_FONT,
			'Sree Krushnadevaraya'             => self::GOOGLE_FONT,
			'Sriracha'                         => self::GOOGLE_FONT,
			'Srisakdi'                         => self::GOOGLE_FONT,
			'Staatliches'                      => self::GOOGLE_FONT,
			'Stalemate'                        => self::GOOGLE_FONT,
			'Stalinist One'                    => self::GOOGLE_FONT,
			'Stardos Stencil'                  => self::GOOGLE_FONT,
			'Stick'                            => self::GOOGLE_FONT,
			'Stick No Bills'                   => self::GOOGLE_FONT,
			'Stint Ultra Condensed'            => self::GOOGLE_FONT,
			'Stint Ultra Expanded'             => self::GOOGLE_FONT,
			'Stoke'                            => self::GOOGLE_FONT,
			'Strait'                           => self::GOOGLE_FONT,
			'Style Script'                     => self::GOOGLE_FONT,
			'Stylish'                          => self::GOOGLE_FONT,
			'Sue Ellen Francisco'              => self::GOOGLE_FONT,
			'Suez One'                         => self::GOOGLE_FONT,
			'Sulphur Point'                    => self::GOOGLE_FONT,
			'Sumana'                           => self::GOOGLE_FONT,
			'Sunflower'                        => self::GOOGLE_FONT,
			'Sunshiney'                        => self::GOOGLE_FONT,
			'Supermercado One'                 => self::GOOGLE_FONT,
			'Sura'                             => self::GOOGLE_FONT,
			'Suranna'                          => self::GOOGLE_FONT,
			'Suravaram'                        => self::GOOGLE_FONT,
			'Suwannaphum'                      => self::GOOGLE_FONT,
			'Swanky and Moo Moo'               => self::GOOGLE_FONT,
			'Syncopate'                        => self::GOOGLE_FONT,
			'Syne'                             => self::GOOGLE_FONT,
			'Syne Mono'                        => self::GOOGLE_FONT,
			'Syne Tactile'                     => self::GOOGLE_FONT,
			'Tac One'                          => self::GOOGLE_FONT,
			'Tai Heritage Pro'                 => self::GOOGLE_FONT,
			'Tajawal'                          => self::GOOGLE_FONT,
			'Tangerine'                        => self::GOOGLE_FONT,
			'Tapestry'                         => self::GOOGLE_FONT,
			'Taprom'                           => self::GOOGLE_FONT,
			'Tauri'                            => self::GOOGLE_FONT,
			'Taviraj'                          => self::GOOGLE_FONT,
			'Teachers'                         => self::GOOGLE_FONT,
			'Teko'                             => self::GOOGLE_FONT,
			'Tektur'                           => self::GOOGLE_FONT,
			'Telex'                            => self::GOOGLE_FONT,
			'Tenali Ramakrishna'               => self::GOOGLE_FONT,
			'Tenor Sans'                       => self::GOOGLE_FONT,
			'Text Me One'                      => self::GOOGLE_FONT,
			'Texturina'                        => self::GOOGLE_FONT,
			'Thasadith'                        => self::GOOGLE_FONT,
			'The Girl Next Door'               => self::GOOGLE_FONT,
			'The Nautigal'                     => self::GOOGLE_FONT,
			'Tienne'                           => self::GOOGLE_FONT,
			'Tillana'                          => self::GOOGLE_FONT,
			'Tilt Neon'                        => self::GOOGLE_FONT,
			'Tilt Prism'                       => self::GOOGLE_FONT,
			'Tilt Warp'                        => self::GOOGLE_FONT,
			'Timmana'                          => self::GOOGLE_FONT,
			'Tinos'                            => self::GOOGLE_FONT,
			'Tiny5'                            => self::GOOGLE_FONT,
			'Tiro Bangla'                      => self::GOOGLE_FONT,
			'Tiro Devanagari Hindi'            => self::GOOGLE_FONT,
			'Tiro Devanagari Marathi'          => self::GOOGLE_FONT,
			'Tiro Devanagari Sanskrit'         => self::GOOGLE_FONT,
			'Tiro Gurmukhi'                    => self::GOOGLE_FONT,
			'Tiro Kannada'                     => self::GOOGLE_FONT,
			'Tiro Tamil'                       => self::GOOGLE_FONT,
			'Tiro Telugu'                      => self::GOOGLE_FONT,
			'Titan One'                        => self::GOOGLE_FONT,
			'Titillium Web'                    => self::GOOGLE_FONT,
			'Tomorrow'                         => self::GOOGLE_FONT,
			'Tourney'                          => self::GOOGLE_FONT,
			'Trade Winds'                      => self::GOOGLE_FONT,
			'Train One'                        => self::GOOGLE_FONT,
			'Trirong'                          => self::GOOGLE_FONT,
			'Trispace'                         => self::GOOGLE_FONT,
			'Trocchi'                          => self::GOOGLE_FONT,
			'Trochut'                          => self::GOOGLE_FONT,
			'Truculenta'                       => self::GOOGLE_FONT,
			'Trykker'                          => self::GOOGLE_FONT,
			'Tsukimi Rounded'                  => self::GOOGLE_FONT,
			'Tulpen One'                       => self::GOOGLE_FONT,
			'Turret Road'                      => self::GOOGLE_FONT,
			'Twinkle Star'                     => self::GOOGLE_FONT,
			'Ubuntu'                           => self::GOOGLE_FONT,
			'Ubuntu Condensed'                 => self::GOOGLE_FONT,
			'Ubuntu Mono'                      => self::GOOGLE_FONT,
			'Ubuntu Sans'                      => self::GOOGLE_FONT,
			'Ubuntu Sans Mono'                 => self::GOOGLE_FONT,
			'Uchen'                            => self::GOOGLE_FONT,
			'Ultra'                            => self::GOOGLE_FONT,
			'Unbounded'                        => self::GOOGLE_FONT,
			'Uncial Antiqua'                   => self::GOOGLE_FONT,
			'Underdog'                         => self::GOOGLE_FONT,
			'Unica One'                        => self::GOOGLE_FONT,
			'UnifrakturCook'                   => self::GOOGLE_FONT,
			'UnifrakturMaguntia'               => self::GOOGLE_FONT,
			'Unkempt'                          => self::GOOGLE_FONT,
			'Unlock'                           => self::GOOGLE_FONT,
			'Unna'                             => self::GOOGLE_FONT,
			'Updock'                           => self::GOOGLE_FONT,
			'Urbanist'                         => self::GOOGLE_FONT,
			'VT323'                            => self::GOOGLE_FONT,
			'Vampiro One'                      => self::GOOGLE_FONT,
			'Varela'                           => self::GOOGLE_FONT,
			'Varela Round'                     => self::GOOGLE_FONT,
			'Varta'                            => self::GOOGLE_FONT,
			'Vast Shadow'                      => self::GOOGLE_FONT,
			'Vazirmatn'                        => self::GOOGLE_FONT,
			'Vesper Libre'                     => self::GOOGLE_FONT,
			'Viaoda Libre'                     => self::GOOGLE_FONT,
			'Vibes'                            => self::GOOGLE_FONT,
			'Vibur'                            => self::GOOGLE_FONT,
			'Victor Mono'                      => self::GOOGLE_FONT,
			'Vidaloka'                         => self::GOOGLE_FONT,
			'Viga'                             => self::GOOGLE_FONT,
			'Vina Sans'                        => self::GOOGLE_FONT,
			'Voces'                            => self::GOOGLE_FONT,
			'Volkhov'                          => self::GOOGLE_FONT,
			'Vollkorn'                         => self::GOOGLE_FONT,
			'Vollkorn SC'                      => self::GOOGLE_FONT,
			'Voltaire'                         => self::GOOGLE_FONT,
			'Vujahday Script'                  => self::GOOGLE_FONT,
			'Waiting for the Sunrise'          => self::GOOGLE_FONT,
			'Wallpoet'                         => self::GOOGLE_FONT,
			'Walter Turncoat'                  => self::GOOGLE_FONT,
			'Warnes'                           => self::GOOGLE_FONT,
			'Water Brush'                      => self::GOOGLE_FONT,
			'Waterfall'                        => self::GOOGLE_FONT,
			'Wavefont'                         => self::GOOGLE_FONT,
			'Wellfleet'                        => self::GOOGLE_FONT,
			'Wendy One'                        => self::GOOGLE_FONT,
			'Whisper'                          => self::GOOGLE_FONT,
			'WindSong'                         => self::GOOGLE_FONT,
			'Wire One'                         => self::GOOGLE_FONT,
			'Wittgenstein'                     => self::GOOGLE_FONT,
			'Wix Madefor Display'              => self::GOOGLE_FONT,
			'Wix Madefor Text'                 => self::GOOGLE_FONT,
			'Work Sans'                        => self::GOOGLE_FONT,
			'Workbench'                        => self::GOOGLE_FONT,
			'Xanh Mono'                        => self::GOOGLE_FONT,
			'Yaldevi'                          => self::GOOGLE_FONT,
			'Yanone Kaffeesatz'                => self::GOOGLE_FONT,
			'Yantramanav'                      => self::GOOGLE_FONT,
			'Yarndings 12'                     => self::GOOGLE_FONT,
			'Yarndings 12 Charted'             => self::GOOGLE_FONT,
			'Yarndings 20'                     => self::GOOGLE_FONT,
			'Yarndings 20 Charted'             => self::GOOGLE_FONT,
			'Yatra One'                        => self::GOOGLE_FONT,
			'Yellowtail'                       => self::GOOGLE_FONT,
			'Yeon Sung'                        => self::GOOGLE_FONT,
			'Yeseva One'                       => self::GOOGLE_FONT,
			'Yesteryear'                       => self::GOOGLE_FONT,
			'Yomogi'                           => self::GOOGLE_FONT,
			'Young Serif'                      => self::GOOGLE_FONT,
			'Yrsa'                             => self::GOOGLE_FONT,
			'Ysabeau'                          => self::GOOGLE_FONT,
			'Ysabeau Infant'                   => self::GOOGLE_FONT,
			'Ysabeau Office'                   => self::GOOGLE_FONT,
			'Ysabeau SC'                       => self::GOOGLE_FONT,
			'Yuji Boku'                        => self::GOOGLE_FONT,
			'Yuji Hentaigana Akari'            => self::GOOGLE_FONT,
			'Yuji Hentaigana Akebono'          => self::GOOGLE_FONT,
			'Yuji Mai'                         => self::GOOGLE_FONT,
			'Yuji Syuku'                       => self::GOOGLE_FONT,
			'Yusei Magic'                      => self::GOOGLE_FONT,
			'ZCOOL KuaiLe'                     => self::GOOGLE_FONT,
			'ZCOOL QingKe HuangYou'            => self::GOOGLE_FONT,
			'ZCOOL XiaoWei'                    => self::GOOGLE_FONT,
			'Zain'                             => self::GOOGLE_FONT,
			'Zen Antique'                      => self::GOOGLE_FONT,
			'Zen Antique Soft'                 => self::GOOGLE_FONT,
			'Zen Dots'                         => self::GOOGLE_FONT,
			'Zen Kaku Gothic Antique'          => self::GOOGLE_FONT,
			'Zen Kaku Gothic New'              => self::GOOGLE_FONT,
			'Zen Kurenaido'                    => self::GOOGLE_FONT,
			'Zen Loop'                         => self::GOOGLE_FONT,
			'Zen Maru Gothic'                  => self::GOOGLE_FONT,
			'Zen Old Mincho'                   => self::GOOGLE_FONT,
			'Zen Tokyo Zoo'                    => self::GOOGLE_FONT,
			'Zeyada'                           => self::GOOGLE_FONT,
			'Zhi Mang Xing'                    => self::GOOGLE_FONT,
			'Zilla Slab'                       => self::GOOGLE_FONT,
			'Zilla Slab Highlight'             => self::GOOGLE_FONT,
		);
		return apply_filters( 'gutenverse_fonts', $fonts );
	}

	/**
	 * Get font weights
	 *
	 * @return mixed
	 */
	public function get_font_weights() {
		$weights = array(
			'normal' => esc_html__( 'Normal', 'gutenverse-form' ),
			'bold'   => esc_html__( 'Bold', 'gutenverse-form' ),
			'100'    => '100',
			'200'    => '200',
			'300'    => '300',
			'400'    => '400',
			'500'    => '500',
			'600'    => '600',
			'700'    => '700',
			'800'    => '800',
			'900'    => '900',
		);

		return apply_filters( 'gutenverse_font_weight', $weights );
	}

	/**
	 * Get Font Settings
	 *
	 * @return mixed
	 */
	public function get_font_styles() {
		$styles = array(
			'normal' => esc_html__( 'Normal', 'gutenverse-form' ),
			'italic' => esc_html__( 'Italic', 'gutenverse-form' ),
		);

		return apply_filters( 'gutenverse_font_styles', $styles );
	}

	/**
	 * Get Font Settings
	 *
	 * @return mixed
	 */
	public function get_font_transform() {
		$styles = array(
			'uppercase'  => esc_html__( 'Uppercase', 'gutenverse-form' ),
			'capitalize' => esc_html__( 'Capitalize', 'gutenverse-form' ),
			'lowercase'  => esc_html__( 'Lowercase', 'gutenverse-form' ),
			'none'       => esc_html__( 'None', 'gutenverse-form' ),
		);

		return apply_filters( 'gutenverse_font_transform', $styles );
	}

	/**
	 * Get Font Settings
	 *
	 * @return array
	 */
	public function get_font_settings() {
		$data              = array();
		$data['fonts']     = array();
		$data['groups']    = array();
		$data['weights']   = $this->get_font_weights();
		$data['styles']    = $this->get_font_styles();
		$data['transform'] = $this->get_font_transform();

		$fonts = $this->get_fonts();
		if ( isset( $fonts ) ) {
			foreach ( $fonts as $font => $group ) {
				$data['fonts'][] = array(
					'class' => $group,
					'value' => $font,
					'name'  => $font,
				);
			}
		}

		$groups = $this->get_font_groups();
		foreach ( $groups as $id => $group ) {
			$data['groups'][] = array(
				'value' => $id,
				'label' => $group,
			);
		}
		return $data;
	}
	/**
	 * Get Custom Font Settings
	 *
	 * @return array
	 */
	public function get_custom_font_settings() {
		$data              = array();
		$data['fonts']     = array();
		$data['groups']    = array();
		$data['weights']   = $this->get_font_weights();
		$data['styles']    = $this->get_font_styles();
		$data['transform'] = $this->get_font_transform();

		$fonts = $this->get_custom_fonts();

		if ( isset( $fonts ) ) {
			foreach ( $fonts as $font => $group ) {
				$data['fonts'][] = array(
					'class' => $group,
					'value' => $font,
					'name'  => $font,
				);
			}
		}

		$groups = $this->get_font_groups();
		foreach ( $groups as $id => $group ) {
			$data['groups'][] = array(
				'value' => $id,
				'label' => $group,
			);
		}

		return $data;
	}
}
