<?php
/**
 * Script module registration - Auto-generated by build process.
 * Do not edit this file manually.
 *
 * @package gutenberg
 */

if ( ! function_exists( 'gutenberg_register_script_modules' ) ) {
	/**
	 * Register all script modules.
	 */
	function gutenberg_register_script_modules() {
		// Load build constants
		$build_constants = require __DIR__ . '/constants.php';
		$modules_dir     = __DIR__ . '/modules';
		$modules_file    = $modules_dir . '/registry.php';

		if ( ! file_exists( $modules_file ) ) {
			return;
		}

		$modules = require $modules_file;
		$base_url = $build_constants['build_url'] . 'modules/';
		$extension = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '.js' : '.min.js';

		foreach ( $modules as $module ) {
			$asset_path = $modules_dir . '/' . $module['asset'];
			$asset = file_exists( $asset_path ) ? require $asset_path : array();

			wp_register_script_module(
				$module['id'],
				$base_url . $module['path'] . $extension,
				$asset['module_dependencies'] ?? array(),
				$asset['version'] ?? false,
				array(
					'fetchpriority' => 'low',
					'in_footer'     => true,
				)
			);
		}
	}

	add_action( 'wp_default_scripts', 'gutenberg_register_script_modules' );
	remove_action( 'wp_default_scripts', 'wp_default_script_modules' );
}
