/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/slick-slider/block.json":
/*!*************************************!*\
  !*** ./src/slick-slider/block.json ***!
  \*************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":2,"name":"gb-for-slick-slider/slick-slider","version":"1.0.0","title":"Slick Slider","category":"widgets","icon":"admin-page","description":"Slick Slider Block wrapper.","supports":{"html":false,"align":true,"spacing":{"padding":true,"margin":true}},"providesContext":{"gb-for-slick-slider/slidesToShow":"slidesToShow","gb-for-slick-slider/slideMargin":"slideMargin"},"attributes":{"dots":{"type":"boolean","default":false},"arrows":{"type":"boolean","default":true},"infinite":{"type":"boolean","default":false},"centerMode":{"type":"boolean","default":false},"adaptiveHeight":{"type":"boolean","default":false},"autoplay":{"type":"boolean","default":false},"autoplaySpeed":{"type":"number","default":1500},"fade":{"type":"boolean","default":false},"slidesToShow":{"type":"number","default":2},"slideSpeed":{"type":"number","default":1000},"slidesToScroll":{"type":"number","default":1},"slideMargin":{"type":"number","default":0},"arrowStyle":{"type":"string","default":"chevron"},"arrowBorderStyle":{"type":"string","default":"circle"},"arrowBackgroundColor":{"type":"string","default":"#ffffff00"},"arrowColor":{"type":"string","default":"#d3d1d1"},"arrowPosition":{"type":"string","default":"sides"},"arrowFontSize":{"type":"number","default":20},"arrowHeight":{"type":"number","default":40},"responsive":{"type":"array","default":[{"breakpoint":1024,"settings":{"slidesToShow":1,"slidesToScroll":1,"arrows":true,"dots":true}},{"breakpoint":768,"settings":{"slidesToShow":1,"slidesToScroll":1,"arrows":false,"dots":true}},{"breakpoint":600,"settings":{"slidesToShow":1,"slidesToScroll":1,"arrows":false,"dots":true}},{"breakpoint":480,"settings":{"slidesToShow":1,"slidesToScroll":1,"arrows":false,"dots":true}}]}},"textdomain":"gb-for-slick-slider","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","render":"file:./render.php"}');

/***/ }),

/***/ "./src/slick-slider/edit.js":
/*!**********************************!*\
  !*** ./src/slick-slider/edit.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./editor.scss */ "./src/slick-slider/editor.scss");
/* harmony import */ var _patterns_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./patterns.js */ "./src/slick-slider/patterns.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);








function Edit(props) {
  const {
    attributes: {
      slidesToShow,
      slideMargin,
      slidesToScroll,
      slideSpeed,
      dots,
      arrows,
      infinite,
      autoplay,
      autoplaySpeed,
      centerMode,
      adaptiveHeight,
      fade,
      responsive,
      arrowStyle,
      arrowBorderStyle,
      arrowBackgroundColor,
      arrowColor,
      arrowPosition,
      arrowFontSize,
      arrowHeight
    },
    setAttributes
  } = props;
  const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)(props);
  const innerBlocksProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useInnerBlocksProps)(blockProps, {
    allowedBlocks: ['gb-for-slick-slider/slick-slider-item'],
    orientation: "horizontal"
  });
  const [localResponsive, setLocalResponsive] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(responsive);
  const [isPatternModalOpen, setPatternModalOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isPatternSelected, setPatternSelected] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setLocalResponsive(responsive);
  }, [responsive]);
  function updateResponsiveSettings(breakpoint, key, value) {
    const newResponsiveSettings = localResponsive.map(item => {
      if (item.breakpoint === breakpoint) {
        return {
          ...item,
          settings: {
            ...item.settings,
            [key]: value
          }
        };
      }
      return item;
    });
    setLocalResponsive(newResponsiveSettings);
    setAttributes({
      responsive: newResponsiveSettings
    });
  }
  const handleSlidesToShow = val => {
    setAttributes({
      slidesToShow: val
    });
    if (val === 1) {
      setAttributes({
        centerMode: false
      });
    } else {
      setAttributes({
        fade: false
      });
    }
  };

  // Check if the block has inner blocks
  const hasInnerBlocks = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select('core/block-editor').getBlock(props.clientId)?.innerBlocks.length > 0, [props.clientId]);

  // Insert pattern blocks into the slider
  const insertPatternBlocks = pattern => {
    if (!pattern.blocks) return;
    const {
      clientId
    } = props;
    const {
      attributes
    } = pattern;

    // Use slider options from the pattern if available
    if (attributes) {
      Object.keys(attributes).forEach(key => {
        setAttributes({
          [key]: attributes[key]
        });
      });
    }

    // Create inner blocks from the pattern
    const innerBlocks = pattern.blocks.map(block => {
      const innerBlocksArray = block.innerBlocks ? block.innerBlocks.map(inner => wp.blocks.createBlock(inner.name, inner.attributes, inner.innerBlocks ? inner.innerBlocks.map(i => wp.blocks.createBlock(i.name, i.attributes)) : [])) : [];
      return wp.blocks.createBlock(block.name, block.attributes, innerBlocksArray);
    });

    // Add the inner blocks to the slider block
    (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.dispatch)('core/block-editor').replaceInnerBlocks(clientId, innerBlocks);
  };
  const handlePatternSelect = pattern => {
    setPatternSelected(true);
    setPatternModalOpen(false);
    // Tüm pattern'ler için blocks varsa ekle
    if (pattern.blocks && pattern.blocks.length > 0) {
      insertPatternBlocks(pattern);
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [
    // First ask the user to select a pattern or use a blank template
    !hasInnerBlocks && !isPatternSelected && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      style: {
        textAlign: 'center',
        padding: '40px 0',
        border: '1px dashed #ccc'
      },
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        variant: "primary",
        onClick: () => setPatternModalOpen(true),
        style: {
          marginRight: '10px'
        },
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select Pattern', 'gb-for-slick-slider')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        variant: "secondary",
        onClick: () => setPatternSelected(true),
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Use Blank Template', 'gb-for-slick-slider')
      })]
    }),
    // If the user has selected to use prebuilt patterns, show the modal
    isPatternModalOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Modal, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select a Pattern', 'gb-for-slick-slider'),
      onRequestClose: () => setPatternModalOpen(false),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        style: {
          display: 'grid',
          gridTemplateColumns: 'repeat(3, 1fr)',
          gap: '20px'
        },
        children: _patterns_js__WEBPACK_IMPORTED_MODULE_6__["default"].map(pattern => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Card, {
          style: {
            cursor: 'pointer'
          },
          onClick: () => handlePatternSelect(pattern),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CardBody, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
              src: pattern.preview,
              alt: pattern.name,
              style: {
                width: '100%',
                marginBottom: '10px'
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
              style: {
                textAlign: 'center'
              },
              children: pattern.name
            })]
          })
        }, pattern.id))
      })
    }),
    // Else show the default blank block inserter
    (hasInnerBlocks || isPatternSelected) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("section", {
      ...innerBlocksProps
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "gb-for-slick-slider-inspector",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
            title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('General Settings', 'gb-for-slick-slider'),
            initialOpen: true,
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Gap between slides (px)', 'gb-for-slick-slider'),
                min: 0,
                value: slideMargin,
                onChange: val => setAttributes({
                  slideMargin: Number(val)
                }),
                __next40pxDefaultSize: true
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Slides to show', 'gb-for-slick-slider'),
                min: 1,
                value: slidesToShow,
                onChange: val => handleSlidesToShow(Number(val)),
                __next40pxDefaultSize: true
              })
            }), slidesToShow <= 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Fade', 'gb-for-slick-slider'),
                checked: fade,
                onChange: val => setAttributes({
                  fade: val
                }),
                __nextHasNoMarginBottom: true
              })
            }), slidesToShow > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Center Mode', 'gb-for-slick-slider'),
                checked: centerMode,
                __nextHasNoMarginBottom: true,
                onChange: val => setAttributes({
                  centerMode: val
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Slides to scroll', 'gb-for-slick-slider'),
                value: slidesToScroll,
                onChange: val => setAttributes({
                  slidesToScroll: Number(val)
                }),
                __next40pxDefaultSize: true
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Slide speed', 'gb-for-slick-slider'),
                value: slideSpeed,
                onChange: val => setAttributes({
                  slideSpeed: Number(val)
                }),
                __next40pxDefaultSize: true
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Autoplay', 'gb-for-slick-slider'),
                checked: autoplay,
                __nextHasNoMarginBottom: true,
                onChange: val => setAttributes({
                  autoplay: val
                })
              })
            }), autoplay && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Autoplay speed', 'gb-for-slick-slider'),
                value: autoplaySpeed,
                onChange: val => setAttributes({
                  autoplaySpeed: Number(val)
                }),
                __next40pxDefaultSize: true
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Infinite loop', 'gb-for-slick-slider'),
                checked: infinite,
                __nextHasNoMarginBottom: true,
                onChange: val => setAttributes({
                  infinite: val
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show Dots', 'gb-for-slick-slider'),
                checked: dots,
                __nextHasNoMarginBottom: true,
                onChange: val => setAttributes({
                  dots: val
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Adaptive Height', 'gb-for-slick-slider'),
                checked: adaptiveHeight,
                __nextHasNoMarginBottom: true,
                onChange: val => setAttributes({
                  adaptiveHeight: val
                })
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
            title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Settings', 'gb-for-slick-slider'),
            initialOpen: false,
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show Arrows', 'gb-for-slick-slider'),
                help: arrows ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show arrows', 'gb-for-slick-slider') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Hide arrows', 'gb-for-slick-slider'),
                checked: arrows,
                __nextHasNoMarginBottom: true,
                onChange: val => setAttributes({
                  arrows: val
                })
              })
            }), arrows && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Style', 'gb-for-slick-slider'),
                value: arrowStyle,
                __next40pxDefaultSize: true,
                __nextHasNoMarginBottom: true,
                options: [{
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Chevron (< >)', 'gb-for-slick-slider'),
                  value: 'chevron'
                }, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Simple Arrow (← →)', 'gb-for-slick-slider'),
                  value: 'simple-arrow'
                }],
                onChange: val => setAttributes({
                  arrowStyle: val
                })
              })
            }), arrows && !dots && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Position', 'gb-for-slick-slider'),
                value: arrowPosition,
                __next40pxDefaultSize: true,
                __nextHasNoMarginBottom: true,
                options: [{
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Sides (Default)', 'gb-for-slick-slider'),
                  value: 'sides'
                }, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Bottom Center', 'gb-for-slick-slider'),
                  value: 'bottom'
                }],
                onChange: val => setAttributes({
                  arrowPosition: val
                })
              })
            }), arrows && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow font size (px)', 'gb-for-slick-slider'),
                  value: arrowFontSize,
                  min: 10,
                  max: 100,
                  onChange: val => setAttributes({
                    arrowFontSize: Number(val)
                  }),
                  __next40pxDefaultSize: true
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Height (px)', 'gb-for-slick-slider'),
                  value: arrowHeight,
                  min: 40,
                  max: 100,
                  onChange: val => setAttributes({
                    arrowHeight: Number(val)
                  }),
                  __next40pxDefaultSize: true
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Border Style', 'gb-for-slick-slider'),
                  value: arrowBorderStyle,
                  __next40pxDefaultSize: true,
                  __nextHasNoMarginBottom: true,
                  options: [{
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Circle', 'gb-for-slick-slider'),
                    value: 'circle'
                  }, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Rounded', 'gb-for-slick-slider'),
                    value: 'rounded'
                  }, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Square', 'gb-for-slick-slider'),
                    value: 'square'
                  }, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('None', 'gb-for-slick-slider'),
                    value: 'none'
                  }],
                  onChange: val => setAttributes({
                    arrowBorderStyle: val
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
                  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Border Style', 'gb-for-slick-slider'),
                  value: arrowBorderStyle,
                  __next40pxDefaultSize: true,
                  __nextHasNoMarginBottom: true,
                  options: [{
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Rounded', 'gb-for-slick-slider'),
                    value: 'rounded'
                  }, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Square', 'gb-for-slick-slider'),
                    value: 'square'
                  }, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('None', 'gb-for-slick-slider'),
                    value: 'none'
                  }],
                  onChange: val => setAttributes({
                    arrowBorderStyle: val
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
                  style: {
                    marginBottom: '16px'
                  },
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
                    style: {
                      display: 'block',
                      marginBottom: '8px',
                      fontWeight: 500
                    },
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Background Color', 'gb-for-slick-slider')
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ColorPicker, {
                    color: arrowBackgroundColor,
                    onChangeComplete: color => setAttributes({
                      arrowBackgroundColor: color.hex
                    })
                  })]
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
                  style: {
                    marginBottom: '16px'
                  },
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
                    style: {
                      display: 'block',
                      marginBottom: '8px',
                      fontWeight: 500
                    },
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Arrow Color', 'gb-for-slick-slider')
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ColorPicker, {
                    color: arrowColor,
                    onChangeComplete: color => setAttributes({
                      arrowColor: color.hex
                    })
                  })]
                })
              })]
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
            title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Responsive Settings', 'gb-for-slick-slider'),
            initialOpen: false,
            children: localResponsive.map(function (breakpoint, index) {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalDivider, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalHeading, {
                  level: 2,
                  children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Breakpoint', 'gb-for-slick-slider'), ": ", breakpoint.breakpoint, "px"]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalDivider, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Slides to show', 'gb-for-slick-slider'),
                    value: breakpoint.settings.slidesToShow,
                    onChange: val => updateResponsiveSettings(breakpoint.breakpoint, 'slidesToShow', Number(val)),
                    __next40pxDefaultSize: true
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalNumberControl, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Slides to scroll', 'gb-for-slick-slider'),
                    value: breakpoint.settings.slidesToScroll,
                    onChange: val => updateResponsiveSettings(breakpoint.breakpoint, 'slidesToScroll', Number(val)),
                    __next40pxDefaultSize: true
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show Arrows', 'gb-for-slick-slider'),
                    help: breakpoint.settings.arrows ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show arrows', 'gb-for-slick-slider') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Hide arrows', 'gb-for-slick-slider'),
                    checked: breakpoint.settings.arrows,
                    __nextHasNoMarginBottom: true,
                    onChange: val => updateResponsiveSettings(breakpoint.breakpoint, 'arrows', val)
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
                    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show Dots', 'gb-for-slick-slider'),
                    help: breakpoint.settings.dots ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Show dots', 'gb-for-slick-slider') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Hide dots', 'gb-for-slick-slider'),
                    checked: breakpoint.settings.dots,
                    __nextHasNoMarginBottom: true,
                    onChange: val => updateResponsiveSettings(breakpoint.breakpoint, 'dots', val)
                  })
                })]
              }, index);
            })
          })
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./src/slick-slider/editor.scss":
/*!**************************************!*\
  !*** ./src/slick-slider/editor.scss ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/slick-slider/index.js":
/*!***********************************!*\
  !*** ./src/slick-slider/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.scss */ "./src/slick-slider/style.scss");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./edit */ "./src/slick-slider/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./save */ "./src/slick-slider/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./block.json */ "./src/slick-slider/block.json");
/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */


/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */


/**
 * Internal dependencies
 */




/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_4__.name, {
  /**
   * @see ./edit.js
   */
  edit: _edit__WEBPACK_IMPORTED_MODULE_2__["default"],
  /**
   * @see ./save.js
   */
  save: _save__WEBPACK_IMPORTED_MODULE_3__["default"]
});

/***/ }),

/***/ "./src/slick-slider/patterns.js":
/*!**************************************!*\
  !*** ./src/slick-slider/patterns.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);

const patterns = [{
  id: 1,
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Single Item', 'gb-for-slick-slider'),
  preview: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-single-item.jpg' : '',
  blocks: [{
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 0
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full'
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }, {
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 0
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full',
        style: {
          color: {
            duotone: ['#111111', '#FFFFFF']
          }
        }
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }],
  attributes: {
    dots: true,
    infinite: true,
    autoplay: true,
    fade: true,
    slidesToShow: 1,
    slideMargin: 0,
    align: 'full',
    responsive: [{
      breakpoint: 1024,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: true,
        dots: true
      }
    }, {
      breakpoint: 768,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }, {
      breakpoint: 600,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }, {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }],
    slideSpeed: 1000,
    arrows: true,
    adaptiveHeight: false,
    autoplaySpeed: 1500,
    centerMode: false,
    slidesToScroll: 1
  }
}, {
  id: 2,
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Multiple Item', 'gb-for-slick-slider'),
  preview: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-multiple-item.jpg' : '',
  blocks: [{
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full'
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }, {
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full',
        style: {
          color: {
            duotone: ['#111111', '#FFFFFF']
          }
        }
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }, {
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full'
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }, {
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full',
        style: {
          color: {
            duotone: ['#111111', '#FFFFFF']
          }
        }
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }],
  attributes: {
    dots: true,
    infinite: true,
    autoplay: true,
    fade: false,
    slidesToShow: 2,
    slideMargin: 5,
    align: 'full',
    responsive: [{
      breakpoint: 1024,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: true,
        dots: true
      }
    }, {
      breakpoint: 768,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }, {
      breakpoint: 600,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }, {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }],
    slideSpeed: 1000,
    arrows: true,
    adaptiveHeight: false,
    autoplaySpeed: 1500,
    centerMode: false,
    slidesToScroll: 1
  }
}, {
  id: 3,
  name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Center Mode', 'gb-for-slick-slider'),
  preview: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-center-mode.jpg' : '',
  blocks: [{
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full'
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }, {
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full',
        style: {
          color: {
            duotone: ['#111111', '#FFFFFF']
          }
        }
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }, {
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full'
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }, {
    name: 'gb-for-slick-slider/slick-slider-item',
    attributes: {
      slideMargin: 5
    },
    innerBlocks: [{
      name: 'core/cover',
      attributes: {
        url: window.gbSlickSliderData ? window.gbSlickSliderData.assetsUrl + 'img/gb-for-slick-slider-sample-bg.jpg' : '',
        dimRatio: 50,
        minHeight: 600,
        minHeightUnit: 'px',
        align: 'full',
        style: {
          color: {
            duotone: ['#111111', '#FFFFFF']
          }
        }
      },
      innerBlocks: [{
        name: 'core/paragraph',
        attributes: {
          align: 'center',
          fontSize: 'large'
        }
      }]
    }]
  }],
  attributes: {
    dots: true,
    infinite: true,
    autoplay: true,
    fade: false,
    slidesToShow: 3,
    slideMargin: 5,
    align: 'full',
    responsive: [{
      breakpoint: 1024,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: true,
        dots: true
      }
    }, {
      breakpoint: 768,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }, {
      breakpoint: 600,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }, {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true
      }
    }],
    slideSpeed: 1000,
    arrows: true,
    adaptiveHeight: false,
    autoplaySpeed: 1500,
    centerMode: true,
    slidesToScroll: 1
  }
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (patterns);

/***/ }),

/***/ "./src/slick-slider/save.js":
/*!**********************************!*\
  !*** ./src/slick-slider/save.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.scss */ "./src/slick-slider/style.scss");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



function save(props) {
  const blockProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__.useBlockProps.save(props);
  const innerBlocksProps = _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__.useInnerBlocksProps.save(blockProps);
  const attr = props.attributes;
  const options = `{"dots":${attr.dots},` + `"arrows":${attr.arrows},` + `"slidesToShow":${attr.slidesToShow},` + `"slidesToScroll":${attr.slidesToScroll},` + `"infinite":${attr.infinite},` + `"adaptiveHeight":${attr.adaptiveHeight},` + `"autoplay":${attr.autoplay},` + `"autoplaySpeed":${attr.autoplaySpeed},` + `"fade":${attr.fade},` + `"speed":${attr.slideSpeed},` + `"centerMode":${attr.centerMode},` + `"responsive": ${JSON.stringify(attr.responsive)}` + `}`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("section", {
    className: "gb-for-slick-slider",
    "data-slick": options,
    ...innerBlocksProps
  });
}

/***/ }),

/***/ "./src/slick-slider/style.scss":
/*!*************************************!*\
  !*** ./src/slick-slider/style.scss ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"slick-slider/index": 0,
/******/ 			"slick-slider/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkgb_for_slick_slider"] = globalThis["webpackChunkgb_for_slick_slider"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["slick-slider/style-index"], () => (__webpack_require__("./src/slick-slider/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map