( function( wp ) {
    const { registerBlockType } = wp.blocks;
    const { createElement } = wp.element;
    const { InspectorControls } = wp.blockEditor;
    const { PanelBody, RangeControl, ToggleControl } = wp.components;
    const { useSelect } = wp.data;

    registerBlockType( 'gam/guest-author-display', {
        title: 'Guest Author(s)',
        icon: 'admin-users',
        category: 'widgets',
        attributes: {
            fontSize: {
                type: 'number',
                default: 16,
            },
            isBold: {
                type: 'boolean',
                default: false,
            },
            isItalic: {
                type: 'boolean',
                default: false,
            },
            isUnderline: {
                type: 'boolean',
                default: false,
            },
            isHidden: {
                type: 'boolean',
                default: false
            },
        },
        usesContext: ['postId'],
        edit: function( props ) {
            const { attributes, setAttributes, context } = props;
            const { fontSize, isBold, isItalic, isUnderline, isHidden } = attributes;
            const postId = context.postId;

            const guestAuthor = useSelect( ( select ) => {
				const entityRecord = select( 'core' ).getEntityRecord( 'postType', 'post', postId );
				const defaultGuest = wp.data.select('core').getEntityRecord('root', 'site', null)?.gam_default_guest_author_name || 'Guest Author';
				const intro = wp.data.select('core').getEntityRecord('root', 'site', null)?.gam_guest_author_intro || 'By:';
				const author = entityRecord && entityRecord.meta ? entityRecord.meta._guest_author_name : defaultGuest;
				return `${intro} ${author}`;
			}, [ postId ]);

            let content;
            if (isHidden) {
                content = '<hidden placeholder>';
            } else {
                content = `${guestAuthor}`;
            }

            const textStyle = {
                fontSize: `${fontSize}px`,
                fontWeight: isBold ? 'bold' : 'normal',
                fontStyle: isItalic ? 'italic' : 'normal',
                textDecoration: isUnderline ? 'underline' : 'none',
            };

            return createElement(
                'div',
                { className: 'wp-block-guest-author', style: textStyle },
                content,
                createElement(
                    InspectorControls,
                    {},
                    createElement(
                        PanelBody,
                        { title: 'Text Formatting Settings', initialOpen: true },
                        createElement(
                            RangeControl,
                            {
                                label: 'Font Size',
                                value: fontSize,
                                onChange: ( newSize ) => setAttributes( { fontSize: newSize } ),
                                min: 10,
                                max: 50,
                            }
                        ),
                        createElement(
                            ToggleControl,
                            {
                                label: 'Bold',
                                checked: isBold,
                                onChange: ( newBold ) => setAttributes( { isBold: newBold } ),
                            }
                        ),
                        createElement(
                            ToggleControl,
                            {
                                label: 'Italic',
                                checked: isItalic,
                                onChange: ( newItalic ) => setAttributes( { isItalic: newItalic } ),
                            }
                        ),
                        createElement(
                            ToggleControl,
                            {
                                label: 'Underline',
                                checked: isUnderline,
                                onChange: ( newUnderline ) => setAttributes( { isUnderline: newUnderline } ),
                            }
                        ),
                        createElement(
                            ToggleControl,
                            {
                                label: 'Hide',
                                checked: isHidden,
                                onChange: ( newHide ) => setAttributes( { isHidden: newHide } ),
                            }
                        )
                    )
                )
            );
        },
        save: function() {
            return null;
        },
    });
} )( window.wp );
