<?php

/**
 * Plugin Name: Guest Author Affiliate
 * Version: 1.1.8
 * Plugin URI: http://GuestAuthorAffiliate.com/
 * Description: Allows your site's content creators to become your affiliates.
 * Author: Oleg Abrosimov
 * Author URI: https://github.com/olegabr
 *
 * Text Domain: guest-author-affiliate
 * Domain Path: /lang/
 *
 * @package WordPress
 * @author Oleg Abrosimov
 * @since 1.0.0
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( !function_exists( 'guest_author_affiliate_plugin_deactivate' ) ) {
    function guest_author_affiliate_plugin_deactivate() {
        if ( !current_user_can( 'activate_plugins' ) ) {
            return;
        }
        deactivate_plugins( plugin_basename( __FILE__ ) );
    }

}
if ( version_compare( phpversion(), '7.0', '<' ) ) {
    add_action( 'admin_init', 'guest_author_affiliate_plugin_deactivate' );
    add_action( 'admin_notices', 'guest_author_affiliate_plugin_admin_notice' );
    function guest_author_affiliate_plugin_admin_notice() {
        if ( !current_user_can( 'activate_plugins' ) ) {
            return;
        }
        echo '<div class="error"><p><strong>Guest Author Affiliate</strong> requires PHP version 7.0 or above.</p></div>';
        if ( isset( $_GET['activate'] ) ) {
            unset($_GET['activate']);
        }
    }

} else {
    if ( function_exists( 'guest_author_affiliate_fs' ) ) {
        guest_author_affiliate_fs()->set_basename( false, __FILE__ );
    } else {
        // Create a helper function for easy SDK access.
        function guest_author_affiliate_fs() {
            global $guest_author_affiliate_fs;
            if ( !isset( $guest_author_affiliate_fs ) ) {
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/vendor/freemius/wordpress-sdk/start.php';
                $guest_author_affiliate_fs = fs_dynamic_init( array(
                    'id'             => '6455',
                    'slug'           => 'guest-author-affiliate',
                    'type'           => 'plugin',
                    'public_key'     => 'pk_6ba218abfd3bbfd07f1ff25b97064',
                    'is_premium'     => false,
                    'premium_suffix' => 'Professional',
                    'has_addons'     => false,
                    'has_paid_plans' => true,
                    'trial'          => array(
                        'days'               => 7,
                        'is_require_payment' => true,
                    ),
                    'menu'           => array(
                        'slug'   => 'guest_author_affiliate_settings',
                        'parent' => array(
                            'slug' => 'options-general.php',
                        ),
                    ),
                    'is_live'        => true,
                ) );
            }
            return $guest_author_affiliate_fs;
        }

        // Init Freemius.
        guest_author_affiliate_fs();
        // Signal that SDK was initiated.
        do_action( 'guest_author_affiliate_fs_loaded' );
        // ... Your plugin's main file logic ...
        if ( guest_author_affiliate_fs()->is_not_paying() ) {
            /**
             * Check if affiliates-manager is active
             * https://wordpress.stackexchange.com/a/193908/137915
             **/
            $wpam = in_array( 'affiliates-manager/boot-strap.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );
            if ( !$wpam ) {
                add_action( 'admin_notices', 'guest_author_affiliate_plugin_admin_notice_wpam' );
                function guest_author_affiliate_plugin_admin_notice_wpam() {
                    if ( !current_user_can( 'activate_plugins' ) ) {
                        return;
                    }
                    echo '<div class="error"><p>' . sprintf( sanitize_text_field( __( '%1$s needs the %2$s plugin to work.', 'guest-author-affiliate' ) ), '<strong>Guest Author Affiliate</strong>', '<a href="https://wordpress.org/plugins/affiliates-manager/" target="_blank">Affiliates Manager</a>' ) . '</p><p>' . sprintf(
                        sanitize_text_field( __( 'The %1$s is also supported in the PRO version. %2$sUpgrade to PRO%3$s if you want to use it.', 'guest-author-affiliate' ) ),
                        '<a href="https://wordpress.org/plugins/yith-woocommerce-affiliates/" target="_blank">YITH WooCommerce Affiliates</a>',
                        '<a href="' . guest_author_affiliate_fs()->get_upgrade_url() . '">',
                        '</a>'
                    ) . '</p>' . '</div>';
                }

            }
        }
        // Load plugin class files.
        require_once 'includes/class-guest-author-affiliate.php';
        require_once 'includes/class-guest-author-affiliate-settings.php';
        // Load plugin libraries.
        require_once 'includes/lib/class-guest-author-affiliate-admin-api.php';
        require_once 'includes/lib/class-guest-author-affiliate-post-type.php';
        require_once 'includes/lib/class-guest-author-affiliate-taxonomy.php';
        /**
         * Returns the main instance of Guest_Author_Affiliate to prevent the need to use globals.
         *
         * @since  1.0.0
         * @return object Guest_Author_Affiliate
         */
        function guest_author_affiliate() {
            $instance = Guest_Author_Affiliate::instance( __FILE__, '1.1.8' );
            if ( is_null( $instance->settings ) ) {
                $instance->settings = Guest_Author_Affiliate_Settings::instance( $instance );
            }
            return $instance;
        }

        guest_author_affiliate();
    }
    // if ( !function_exists( 'guest_author_affiliate_fs' ) ) {
}
// if ( !version_compare( phpversion(), '7.0', '<' ) ) {