/*
 * Guardify Scripts
 * Version: 1.0.7
 */
let activityChart = null;

jQuery(document).ready(function($) {
	
    // Toggle firewall
    $('#toggle-firewall').click(function() {
        var enabled = $(this).data('enabled') ? 0 : 1;
        $.ajax({
            url: guardifyAjax.ajax_url,
            method: 'POST',
            data: {
                action: 'guardify_toggle_firewall',
                nonce: guardifyAjax.nonce,
                enable: enabled
            },
			options: {
				responsive: true,
				animation: {
					duration: 1000, 
					easing: 'easeOutBounce'
				}
			},
            success: function(response) {
                if (response.success) {
                    $('#toggle-firewall')
                        .data('enabled', response.data.enabled)
                        .text(response.data.enabled ? 'Disable Firewall' : 'Enable Firewall');
                }
            }
        });
    });

    // Reset settings
    $('#reset-settings').click(function() {
        if (confirm('Are you sure you want to reset all settings to default?')) {
            $.ajax({
                url: guardifyAjax.ajax_url,
                method: 'POST',
                data: {
                    action: 'guardify_reset_settings',
                    nonce: guardifyAjax.nonce
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.data.message);
                        location.reload();
                    }
                }
            });
        }
    });

    // Add IP rule
    $('#add-ip-rule-form').submit(function(e) {
        e.preventDefault();
        var formData = $(this).serializeArray();
        var data = {
            action: 'guardify_add_ip_rule',
            nonce: guardifyAjax.nonce
        };
        formData.forEach(function(item) {
            data[item.name] = item.value;
        });

        $.ajax({
            url: guardifyAjax.ajax_url,
            method: 'POST',
            data: data,
            success: function(response) {
                if (response.success) {
                    alert(response.data.message);
                    location.reload();
                } else {
                    alert(response.data.message);
                }
            }
        });
    });

    // Remove IP rule
    $(document).on('click', '.remove-ip-rule', function() {
        if (confirm('Are you sure you want to remove this IP rule?')) {
            var index = $(this).data('index');
            $.ajax({
                url: guardifyAjax.ajax_url,
                method: 'POST',
                data: {
                    action: 'guardify_remove_ip_rule',
                    nonce: guardifyAjax.nonce,
                    index: index
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.data.message);
                        location.reload();
                    } else {
                        alert(response.data.message);
                    }
                }
            });
        }
    });

    // Filter IP rules
    $('.filter-button').click(function() {
        $('.filter-button').removeClass('active');
        $(this).addClass('active');
        var filter = $(this).data('filter');
        $.ajax({
            url: guardifyAjax.ajax_url,
            method: 'POST',
            data: {
                action: 'guardify_filter_ip_rules',
                nonce: guardifyAjax.nonce,
                filter: filter
            },
            success: function(response) {
                $('#ip-rules-list').html(response.data);
            }
        });
    });
	



    // Country search
    $('#country-search').on('input', function() {
        var searchTerm = $(this).val().toLowerCase();
        $('.guardify-country-item').each(function() {
            var countryText = $(this).text().toLowerCase();
            if (countryText.includes(searchTerm)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
});