<?php
/**
 * Plugin Name: GSSEO Meta Generator
 * Description: A powerful and magical SEO plugin to optimize your WordPress website in terms of generating Meta Title and Discription.
 * Version: 1.0.0
 * Author: Gauri Shankar
 * Requires PHP: 7.4
 * Requires at least: 5.0
 * Author URI: https://aboutgaurishankar.wordpress.com/
 * License: GPL2
 * Text Domain: gsseo-meta-generator
 */
 
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define Constants
define('GSSEO_VERSION', '1.0.0');
define('GSSEO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('GSSEO_PLUGIN_URL', plugin_dir_url(__FILE__));



// Include Admin Pages
require_once GSSEO_PLUGIN_DIR . 'admin/menu.php';

// Enqueue admin scripts and define ajaxurl
add_action('admin_enqueue_scripts', function () {
    wp_enqueue_script('jquery');

    // Define ajaxurl globally for admin pages
    wp_add_inline_script('jquery', 'var ajaxurl = "' . admin_url('admin-ajax.php') . '";');
});


// Activation Hook
function gsseo_activate() {
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'gsseo_activate');

// Deactivation Hook
function gsseo_deactivate() {
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'gsseo_deactivate');


