<?php
if (!defined('ABSPATH')) exit;

// Enqueue admin scripts
add_action('admin_enqueue_scripts', function ($hook) {
    if ($hook !== 'gsseo-meta-generator_page_gsseo-title-meta') return;

   // Load Bootstrap locally
wp_enqueue_style(
    'gsseo-bootstrap',
    plugins_url('assets/css/bootstrap.min.css', __FILE__),
    [],
    '5.3.3'
);

wp_enqueue_script(
    'gsseo-bootstrap-js',
    plugins_url('assets/js/bootstrap.bundle.min.js', __FILE__),
    [],
    '5.3.3',
    true
);

    // ✅ Local meta-data-generator.js with dynamic versioning
    wp_enqueue_script(
        'gsseo-meta-js',
        plugin_dir_url(__FILE__) . 'assets/js/meta-data-generator.js',
        ['jquery'],
        filemtime(plugin_dir_path(__FILE__) . 'assets/js/meta-data-generator.js'),
        true
    );

    // ✅ Local meta-data-generator.css with dynamic versioning
    wp_enqueue_style(
        'gsseo-admin-style',
        plugin_dir_url(__FILE__) . 'assets/css/meta-data-generator.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/css/meta-data-generator.css')
    );
    
    wp_localize_script('gsseo-meta-js', 'gsseo_ajax', [
        'ajax_url'       => admin_url('admin-ajax.php'),
        'nonce'          => wp_create_nonce('gsseo_nonce'),
        'plugin_active'  => gsseo_is_plugin_active()
    ]);
});

function gsseo_is_plugin_active() {
    return (defined('WPSEO_VERSION') || defined('RANK_MATH_VERSION') || defined('AIOSEO_VERSION') || defined('SEOPRESS_VERSION'));
}

function gsseo_title_meta_settings_page() {
    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">GSSEO AI Meta Generator (Meta Title & Meta Description)</h1>
        <a target="_blank" href="https://aboutgaurishankar.wordpress.com/contact/"
           style="animation: blink-animation 10s steps(10, start) infinite;
           color: #0008ff; text-decoration: underline; font-size: 20px; font-weight: 500;">
           Contact Us for Custom Support
        </a>
        <style>@keyframes blink-animation { to { visibility: hidden; } }</style>
        <hr class="wp-header-end">
        <?php if (!gsseo_is_plugin_active()): ?>
            <div class="notice notice-error is-dismissible"><p><strong>No supported SEO plugin is active.</strong></p></div>
        <?php else: ?>
            <div class="gsseo-filters" style="margin-bottom: 20px;">
                <label for="gsseo-post-type-filter">Filter by:</label>
                <select id="gsseo-post-type-filter">
                    <option value="all">All</option>
                    <option value="post">Posts</option>
                    <option value="page">Pages</option>
                </select>
                <input type="text" id="gsseo-search" placeholder="Search by title..." style="margin-left: 10px; width: 300px;">
                <div class="gsseo-pagination-container"></div>
                <div class="gsseo-count-container" style="margin-top: 10px;"></div>
            </div>
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th>Post Name</th>
                        <th>Meta Title</th>
                        <th>Meta Description</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="gsseo-posts-table"><tr><td colspan="4">Loading...</td></tr></tbody>
            </table>
            <div class="gsseo-pagination-container" style="margin-top: 20px;"></div>
        <?php endif; ?>
    </div>
    <?php
}

// AJAX: Fetch posts
add_action('wp_ajax_gsseo_get_all_posts', function () {
    check_ajax_referer('gsseo_nonce', 'nonce');


 $type = isset($_POST['type']) ? sanitize_text_field(wp_unslash($_POST['type'])) : 'all'; // Unsplash and sanitize 'type'
    $search = isset($_POST['search']) ? sanitize_text_field(wp_unslash($_POST['search'])) : ''; // Unsplash and sanitize 'search'
    $page = isset($_POST['page']) ? intval($_POST['page']) : 1;

    $per_page = 10;

    $args = [
        'post_type'      => ($type === 'all') ? ['post', 'page'] : [$type],
        'post_status'    => 'publish',
        'posts_per_page' => $per_page,
        'paged'          => $page,
        'orderby'        => 'title',
        'order'          => 'ASC',
        's'              => $search
    ];

    $query = new WP_Query($args);
    $results = array_map(function ($post) {
        $meta_title = '';
        $meta_desc  = '';

        if (defined('WPSEO_VERSION')) {
            $meta_title = get_post_meta($post->ID, '_yoast_wpseo_title', true);
            $meta_desc  = get_post_meta($post->ID, '_yoast_wpseo_metadesc', true);
        } elseif (defined('RANK_MATH_VERSION')) {
            $meta_title = get_post_meta($post->ID, 'rank_math_title', true);
            $meta_desc  = get_post_meta($post->ID, 'rank_math_description', true);
        } elseif (defined('AIOSEO_VERSION')) {
            if (class_exists('\AIOSEO\Plugin\Common\Models\Post')) {
                try {
                    $aioseoPost = \AIOSEO\Plugin\Common\Models\Post::getPost($post->ID);
                    if ($aioseoPost) {
                        $meta_title = $aioseoPost->title;
                        $meta_desc = $aioseoPost->description;
                    }
                } catch (Exception $e) {}
            }
        } elseif (defined('SEOPRESS_VERSION')) {
            $meta_title = get_post_meta($post->ID, '_seopress_titles_title', true);
            $meta_desc  = get_post_meta($post->ID, '_seopress_titles_desc', true);
        }
        

        return [
            'id' => $post->ID,
            'title' => $post->post_title ?: '(no title)',
            'edit_link' => get_edit_post_link($post->ID),
            'view_link' => get_permalink($post->ID),
            'meta_title' => $meta_title,
            'meta_description' => $meta_desc
        ];
    }, $query->posts);

    wp_send_json_success([
        'posts' => $results,
        'pagination' => [
            'current_page' => $page,
            'total_pages' => ceil($query->found_posts / $per_page),
            'total_posts' => $query->found_posts
        ]
    ]);
});

// AJAX: Save Meta
add_action('wp_ajax_gsseo_save_post_meta', function () {
    check_ajax_referer('gsseo_nonce', 'nonce');
    //$post_id = intval($_POST['post_id']);
    $post_id = isset($_POST['post_id']) ? intval(wp_unslash($_POST['post_id'])) : 0;
    $title = isset($_POST['title']) ? sanitize_text_field( wp_unslash( $_POST['title'] ) ) : '';
    $desc = isset($_POST['description']) ? sanitize_textarea_field( wp_unslash( $_POST['description'] ) ) : '';
    $plugin  = '';

// Inside gsseo_save_post_meta()
update_post_meta($post_id, 'gsseo_generated_title', $title);
update_post_meta($post_id, 'gsseo_generated_description', $desc);


    if (defined('WPSEO_VERSION')) {
        update_post_meta($post_id, '_yoast_wpseo_title', $title);
        update_post_meta($post_id, '_yoast_wpseo_metadesc', $desc);
        $plugin = 'Yoast SEO';
    } elseif (defined('RANK_MATH_VERSION')) {
        update_post_meta($post_id, 'rank_math_title', $title);
        update_post_meta($post_id, 'rank_math_description', $desc);
        $plugin = 'Rank Math';
    } elseif (defined('AIOSEO_VERSION')) {
        $settings = get_post_meta($post_id, '_aioseo_posts_settings', true) ?: [];
        $settings['title'] = $title;
        $settings['description'] = $desc;
        update_post_meta($post_id, '_aioseo_posts_settings', $settings);

        if (class_exists('\AIOSEO\Plugin\Common\Models\Post')) {
            $aioseo_post = \AIOSEO\Plugin\Common\Models\Post::getPost($post_id);
            if ($aioseo_post) {
                $aioseo_post->title = $title;
                $aioseo_post->description = $desc;
                $aioseo_post->save();
            }
        }
        $plugin = 'AIOSEO';
    } elseif (defined('SEOPRESS_VERSION')) {
        update_post_meta($post_id, '_seopress_titles_title', $title);
        update_post_meta($post_id, '_seopress_titles_desc', $desc);
        $plugin = 'SEOPress';
    }
    
            clean_post_cache($post->ID);

    wp_send_json_success([
        'message' => "Meta updated successfully using $plugin.",
        'plugin'  => $plugin
    ]);
});

/****************AI Generation Meta Code*******************/

// AJAX: Generate AI Meta
add_action('wp_ajax_gsseo_generate_ai_meta', function () {
    check_ajax_referer('gsseo_nonce', 'nonce');
    $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : 0;
    $post = get_post($post_id);
    if (!$post) wp_send_json_error(['message' => 'Invalid post.']);

    $content = apply_filters('the_content', $post->post_content);
    $content = wp_strip_all_tags(html_entity_decode($content));
    $content = preg_replace('/\s+/', ' ', trim($content));
    $content = substr($content, 0, 800);
    if (strlen($content) < 100 && has_excerpt($post_id)) {
        $content .= ' ' . get_the_excerpt($post_id);
    }

    $api_key = 'DWQ4KiXeU9BrUWrOVVqLwICJg9RstOW9XLlx6m8t';
    $api_url = 'https://api.cohere.ai/v1/generate';

    try {
        $response = wp_remote_post($api_url, [
            'timeout' => 45,
            'headers' => [
                'Authorization' => 'Bearer ' . $api_key,
                'Content-Type'  => 'application/json'
            ],
            'body' => json_encode([
                'model'     => 'command-r-plus',
                'prompt'    => "Generate SEO meta title and meta description for this content:\n\n$content",
                'max_tokens' => 200,
                'temperature' => 0.7
            ])
        ]);

        if (is_wp_error($response)) {
            wp_send_json_error(['message' => 'Request failed.']);
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);
        $text = trim($body['generations'][0]['text'] ?? '');

        // Assume format: "Title: ... \nDescription: ..."
        preg_match('/Title:(.*?)Description:(.*)/is', $text, $matches);
        $title = trim($matches[1] ?? '');
        $desc  = trim($matches[2] ?? '');
        
        // ✅ Save to GSSEO meta (report will now reflect this)
        update_post_meta($post_id, 'gsseo_generated_title', $title);
        update_post_meta($post_id, 'gsseo_generated_description', $desc);

        wp_send_json_success([
            'title' => $title,
            'description' => $desc,
            'raw' => $text
        ]);
    } catch (Exception $e) {
        wp_send_json_error(['message' => $e->getMessage()]);
    }
});