<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Enqueue scripts
function gsseo_bulk_meta_scripts($hook) {
    if ($hook !== 'gsseo-meta-generator_page_gsseo-bulk-updater') {
        return;
    }
   wp_enqueue_script(
    'gsseo-bulk-progress',
    plugin_dir_url(__FILE__) . 'assets/js/bulk-progress.js',
    ['jquery'],
    filemtime(plugin_dir_path(__FILE__) . 'assets/js/bulk-progress.js'), // dynamic versioning
    true
);


    if (!function_exists('is_plugin_active')) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    wp_localize_script('gsseo-bulk-progress', 'gsseo_ajax', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('gsseo_bulk_nonce'),
        'active_plugins' => [
            'yoast'     => is_plugin_active('wordpress-seo/wp-seo.php'),
            'rankmath'  => is_plugin_active('seo-by-rank-math/rank-math.php'),
            'aioseo'    => is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php'),
            'seopress'  => is_plugin_active('wp-seopress/seopress.php'),
        ]
    ]);

    wp_enqueue_style(
        'gsseo-admin-style',
        plugin_dir_url(__FILE__) . 'assets/css/bulk-style.css',
        [],
        GSSEO_VERSION // define('GSSEO_VERSION', '1.0.0');
    );
}
add_action('admin_enqueue_scripts', 'gsseo_bulk_meta_scripts');

// Admin UI Page
function gsseo_bulk_meta_page() {
    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('Bulk Meta Title & Description Updater (Post/Pages)', 'gsseo-meta-generator'); ?></h1>
        <a target="_blank" href="<?php echo esc_url('https://aboutgaurishankar.wordpress.com/contact/'); ?>"
           style="animation: blink-animation 10s steps(10, start) infinite; color: #0008ff; text-decoration: underline; font-size: 20px; font-weight: 500;">
            <?php echo esc_html__('Contact Us for Custom Support', 'gsseo-meta-generator'); ?>
        </a>

        <style>
            @keyframes blink-animation {
                to {
                    visibility: hidden;
                }
            }
        </style>

        <h3><?php echo esc_html__('Format of CSV Sheet', 'gsseo-meta-generator'); ?></h3>
        <img 
        src="<?php echo esc_url( plugins_url( 'assets/images/styleforsheet.png', __FILE__ ) ); ?>" 
        alt="<?php esc_attr_e( 'Style for Sheet Preview', 'gsseo-meta-generator' ); ?>" 
        style="width:90%;" 
        />

        <div id="gsseo-message" style="margin-bottom: 15px;"></div>

        <form id="gsseo-bulk-form" enctype="multipart/form-data" method="post">
            <table class="form-table">
                <tr>
                    <th><label for="seo_plugin"><?php echo esc_html__('Select SEO Plugin:', 'gsseo-meta-generator'); ?></label></th>
                    <td>
                        <select name="seo_plugin" id="seo_plugin" required>
                            <option value=""><?php esc_html_e('Select plugin', 'gsseo-meta-generator'); ?></option>
                            <option value="yoast">Yoast</option>
                            <option value="rankmath">Rank Math</option>
                            <option value="aioseo">AIOSEO</option>
                            <option value="seopress">SEOPress</option>
                        </select>
                    </td>
                </tr>
                <tr class="upload-section" style="display:none;">
                    <th><label for="csv_file"><?php echo esc_html__('Upload CSV File:', 'gsseo-meta-generator'); ?></label></th>
                    <td><input type="file" name="csv_file" id="csv_file" accept=".csv" required></td>
                </tr>
            </table>
            <p class="upload-section" style="display:none;"><input type="submit" id="upload-btn" class="button button-primary" value="<?php esc_attr_e('Upload and Update', 'gsseo-meta-generator'); ?>"></p>
        </form>

        <div id="gsseo-progress-wrapper" style="display:none;">
            <div style="margin-bottom: 8px;"><?php esc_html_e('Updating...', 'gsseo-meta-generator'); ?> <span id="gsseo-progress-count">0</span></div>
            <div id="gsseo-progress-bar" style="width:100%; background:#e0e0e0; height:24px;">
                <div style="width:0%; height:100%; background:#0073aa; text-align:center; color:#fff;" id="gsseo-progress-fill">0%</div>
            </div>
        </div>
        <div id="gsseo-finished-message"></div>
    </div>
    <?php
}

// Handle AJAX CSV Update
add_action('wp_ajax_gsseo_process_csv', 'gsseo_process_csv_ajax');


function gsseo_process_csv_ajax() {
    check_ajax_referer('gsseo_bulk_nonce', 'nonce');

    $plugin = isset($_POST['plugin']) ? sanitize_text_field(wp_unslash($_POST['plugin'])) : '';
    //$rows   = isset($_POST['rows']) ? json_decode(wp_unslash(json_encode($_POST['rows'])), true) : [];
//$rows = isset($_POST['rows']) ? wp_unslash($_POST['rows']) : [];

$rows = isset($_POST['rows']) ? array_map('sanitize_text_field', (array) wp_unslash($_POST['rows'])) : [];


if (!is_array($rows) || empty($plugin)) {
    wp_send_json_error(['message' => 'Invalid input data']);
    return;
}

$sanitized_rows = [];

foreach ($rows as $row) {
    if (!is_array($row) || count($row) < 3) {
        continue;
    }

    $url = esc_url_raw($row[0]);
    $title = sanitize_text_field($row[1]);
    $description = sanitize_text_field($row[2]);

    $sanitized_rows[] = [
        'url' => $url,
        'title' => $title,
        'description' => $description,
    ];
}

$count = 0;
foreach ($sanitized_rows as $item) {
    $post_id = url_to_postid($item['url']);
    if (!$post_id) {
        continue;
    }

    switch ($plugin) {
        case 'yoast':
            update_post_meta($post_id, '_yoast_wpseo_title', $item['title']);
            update_post_meta($post_id, '_yoast_wpseo_metadesc', $item['description']);
            break;
        case 'rankmath':
            update_post_meta($post_id, 'rank_math_title', $item['title']);
            update_post_meta($post_id, 'rank_math_description', $item['description']);
            break;
        case 'aioseo':
            update_post_meta($post_id, '_aioseo_title', $item['title']);
            update_post_meta($post_id, '_aioseo_description', $item['description']);
            break;
        case 'seopress':
            update_post_meta($post_id, '_seopress_titles_title', $item['title']);
            update_post_meta($post_id, '_seopress_titles_desc', $item['description']);
            break;
    }

    $count++;
}


    wp_send_json_success(['updated' => $count]);
}
